/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DurationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DurationUtilsTest
extends AbstractLangTest {
    DurationUtilsTest() {
    }

    @Test
    void testGetNanosOfMiili() {
        Assertions.assertEquals((int)0, (int)DurationUtils.getNanosOfMiili(null));
        Assertions.assertEquals((int)0, (int)DurationUtils.getNanosOfMiili((Duration)Duration.ZERO));
        Assertions.assertEquals((int)1, (int)DurationUtils.getNanosOfMiili((Duration)Duration.ofNanos(1L)));
        Assertions.assertEquals((int)10, (int)DurationUtils.getNanosOfMiili((Duration)Duration.ofNanos(10L)));
        Assertions.assertEquals((int)100, (int)DurationUtils.getNanosOfMiili((Duration)Duration.ofNanos(100L)));
        Assertions.assertEquals((int)1000, (int)DurationUtils.getNanosOfMiili((Duration)Duration.ofNanos(1000L)));
        Assertions.assertEquals((int)10000, (int)DurationUtils.getNanosOfMiili((Duration)Duration.ofNanos(10000L)));
        Assertions.assertEquals((int)100000, (int)DurationUtils.getNanosOfMiili((Duration)Duration.ofNanos(100000L)));
        Assertions.assertEquals((int)0, (int)DurationUtils.getNanosOfMiili((Duration)Duration.ofNanos(1000000L)));
        Assertions.assertEquals((int)1, (int)DurationUtils.getNanosOfMiili((Duration)Duration.ofNanos(1000001L)));
    }

    @Test
    void testGetNanosOfMilli() {
        Assertions.assertEquals((int)0, (int)DurationUtils.getNanosOfMilli(null));
        Assertions.assertEquals((int)0, (int)DurationUtils.getNanosOfMilli((Duration)Duration.ZERO));
        Assertions.assertEquals((int)1, (int)DurationUtils.getNanosOfMilli((Duration)Duration.ofNanos(1L)));
        Assertions.assertEquals((int)10, (int)DurationUtils.getNanosOfMilli((Duration)Duration.ofNanos(10L)));
        Assertions.assertEquals((int)100, (int)DurationUtils.getNanosOfMilli((Duration)Duration.ofNanos(100L)));
        Assertions.assertEquals((int)1000, (int)DurationUtils.getNanosOfMilli((Duration)Duration.ofNanos(1000L)));
        Assertions.assertEquals((int)10000, (int)DurationUtils.getNanosOfMilli((Duration)Duration.ofNanos(10000L)));
        Assertions.assertEquals((int)100000, (int)DurationUtils.getNanosOfMilli((Duration)Duration.ofNanos(100000L)));
        Assertions.assertEquals((int)0, (int)DurationUtils.getNanosOfMilli((Duration)Duration.ofNanos(1000000L)));
        Assertions.assertEquals((int)1, (int)DurationUtils.getNanosOfMilli((Duration)Duration.ofNanos(1000001L)));
    }

    @Test
    void testIsPositive() {
        Assertions.assertFalse((boolean)DurationUtils.isPositive((Duration)Duration.ZERO));
        Assertions.assertFalse((boolean)DurationUtils.isPositive((Duration)Duration.ofMillis(-1L)));
        Assertions.assertTrue((boolean)DurationUtils.isPositive((Duration)Duration.ofMillis(1L)));
    }

    @Test
    void testLongToIntRangeFit() {
        Assertions.assertEquals((long)0L, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)0L)));
        Assertions.assertEquals((long)Integer.MIN_VALUE, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)NumberUtils.LONG_INT_MIN_VALUE)));
        Assertions.assertEquals((long)Integer.MIN_VALUE, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)(NumberUtils.LONG_INT_MIN_VALUE - 1L))));
        Assertions.assertEquals((long)Integer.MIN_VALUE, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)(NumberUtils.LONG_INT_MIN_VALUE - 2L))));
        Assertions.assertEquals((long)Integer.MAX_VALUE, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)NumberUtils.LONG_INT_MAX_VALUE)));
        Assertions.assertEquals((long)Integer.MAX_VALUE, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)(NumberUtils.LONG_INT_MAX_VALUE + 1L))));
        Assertions.assertEquals((long)Integer.MAX_VALUE, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)(NumberUtils.LONG_INT_MAX_VALUE + 2L))));
        Assertions.assertEquals((long)Integer.MIN_VALUE, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)Long.MIN_VALUE)));
        Assertions.assertEquals((long)Integer.MAX_VALUE, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)Long.MAX_VALUE)));
        Assertions.assertEquals((long)-32768L, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)-32768L)));
        Assertions.assertEquals((long)32767L, (Long)((Long)DurationUtils.LONG_TO_INT_RANGE.fit((Object)32767L)));
    }

    @Test
    void testOfConsumer() {
        Assertions.assertTrue((DurationUtils.of(start -> Assertions.assertTrue((start.compareTo(Instant.now()) <= 0 ? 1 : 0) != 0)).compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0);
        Instant before = Instant.now();
        DurationUtils.of(start -> Assertions.assertTrue((start.compareTo(before) >= 0 ? 1 : 0) != 0));
    }

    @Test
    void testOfRunnble() {
        Assertions.assertTrue((DurationUtils.of(this::testSince).compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0);
    }

    @Test
    void testOfRunnbleThrowing() {
        Assertions.assertThrows(IOException.class, () -> DurationUtils.of(() -> {
            throw new IOException();
        }));
    }

    @Test
    void testSince() {
        Assertions.assertTrue((DurationUtils.since((Temporal)Instant.EPOCH).compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((DurationUtils.since((Temporal)Instant.MIN).compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((DurationUtils.since((Temporal)Instant.MAX).compareTo(Duration.ZERO) <= 0 ? 1 : 0) != 0);
    }

    @Test
    void testToDuration() {
        Assertions.assertEquals((Object)Duration.ofDays(1L), (Object)DurationUtils.toDuration((long)1L, (TimeUnit)TimeUnit.DAYS));
        Assertions.assertEquals((Object)Duration.ofHours(1L), (Object)DurationUtils.toDuration((long)1L, (TimeUnit)TimeUnit.HOURS));
        Assertions.assertEquals((Object)Duration.ofMillis(1L), (Object)DurationUtils.toDuration((long)1000L, (TimeUnit)TimeUnit.MICROSECONDS));
        Assertions.assertEquals((Object)Duration.ofMillis(1L), (Object)DurationUtils.toDuration((long)1L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((Object)Duration.ofMinutes(1L), (Object)DurationUtils.toDuration((long)1L, (TimeUnit)TimeUnit.MINUTES));
        Assertions.assertEquals((Object)Duration.ofNanos(1L), (Object)DurationUtils.toDuration((long)1L, (TimeUnit)TimeUnit.NANOSECONDS));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)DurationUtils.toDuration((long)1L, (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertEquals((long)1L, (long)DurationUtils.toDuration((long)1L, (TimeUnit)TimeUnit.MILLISECONDS).toMillis());
        Assertions.assertEquals((long)-1L, (long)DurationUtils.toDuration((long)-1L, (TimeUnit)TimeUnit.MILLISECONDS).toMillis());
        Assertions.assertEquals((long)0L, (long)DurationUtils.toDuration((long)0L, (TimeUnit)TimeUnit.SECONDS).toMillis());
    }

    @Test
    void testToMillisInt() {
        Assertions.assertEquals((int)0, (int)DurationUtils.toMillisInt((Duration)Duration.ZERO));
        Assertions.assertEquals((int)1, (int)DurationUtils.toMillisInt((Duration)Duration.ofMillis(1L)));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)DurationUtils.toMillisInt((Duration)Duration.ofMillis(Integer.MIN_VALUE)));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)DurationUtils.toMillisInt((Duration)Duration.ofMillis(Integer.MAX_VALUE)));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)DurationUtils.toMillisInt((Duration)Duration.ofMillis(NumberUtils.LONG_INT_MAX_VALUE + 1L)));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)DurationUtils.toMillisInt((Duration)Duration.ofMillis(NumberUtils.LONG_INT_MAX_VALUE + 2L)));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)DurationUtils.toMillisInt((Duration)Duration.ofMillis(NumberUtils.LONG_INT_MIN_VALUE - 1L)));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)DurationUtils.toMillisInt((Duration)Duration.ofMillis(NumberUtils.LONG_INT_MIN_VALUE - 2L)));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)DurationUtils.toMillisInt((Duration)Duration.ofNanos(Long.MIN_VALUE)));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)DurationUtils.toMillisInt((Duration)Duration.ofNanos(Long.MAX_VALUE)));
    }

    @Test
    void testToMillisIntNullDuration() {
        LangAssertions.assertNullPointerException(() -> DurationUtils.toMillisInt(null));
    }

    @Test
    void testZeroIfNull() {
        Assertions.assertEquals((Object)Duration.ZERO, (Object)DurationUtils.zeroIfNull(null));
        Assertions.assertEquals((Object)Duration.ofDays(1L), (Object)DurationUtils.zeroIfNull((Duration)Duration.ofDays(1L)));
    }
}

