/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerTest;
import org.apache.commons.lang3.concurrent.AtomicSafeInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AtomicSafeInitializerTest
extends AbstractConcurrentInitializerTest<Object> {
    private AtomicSafeInitializerTestImpl initializer;

    AtomicSafeInitializerTest() {
    }

    @Override
    protected ConcurrentInitializer<Object> createInitializer() {
        return this.initializer;
    }

    @BeforeEach
    public void setUp() {
        this.initializer = new AtomicSafeInitializerTestImpl();
    }

    @Test
    void testGetThatReturnsNullFirstTime() throws ConcurrentException {
        AtomicSafeInitializer<Object> initializer = new AtomicSafeInitializer<Object>(){
            final AtomicBoolean firstRun = new AtomicBoolean(true);

            protected Object initialize() {
                if (this.firstRun.getAndSet(false)) {
                    return null;
                }
                return new Object();
            }
        };
        Assertions.assertNull((Object)initializer.get());
        Assertions.assertNull((Object)initializer.get());
    }

    @Test
    void testNumberOfInitializeInvocations() throws ConcurrentException, InterruptedException {
        this.testGetConcurrent();
        Assertions.assertEquals((int)1, (int)this.initializer.initCounter.get(), (String)"Wrong number of invocations");
    }

    private static final class AtomicSafeInitializerTestImpl
    extends AtomicSafeInitializer<Object> {
        final AtomicInteger initCounter = new AtomicInteger();

        private AtomicSafeInitializerTestImpl() {
        }

        protected Object initialize() {
            this.initCounter.incrementAndGet();
            return new Object();
        }
    }
}

