/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LangAssertions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrayUtilsInsertTest
extends AbstractLangTest {
    ArrayUtilsInsertTest() {
    }

    @Test
    void testInsertBooleans() {
        boolean[] array = new boolean[]{true, false, true};
        boolean[] values = new boolean[]{false, true, false};
        boolean[] result = ArrayUtils.insert((int)42, (boolean[])array, null);
        Assertions.assertArrayEquals((boolean[])array, (boolean[])result);
        Assertions.assertNotSame((Object)array, (Object)result);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (boolean[])array));
        Assertions.assertArrayEquals((boolean[])new boolean[0], (boolean[])ArrayUtils.insert((int)0, (boolean[])new boolean[0], null));
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, (boolean[])null, null));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)-1, (boolean[])array, (boolean[])array));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)(array.length + 1), (boolean[])array, (boolean[])array));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, true}, (boolean[])ArrayUtils.insert((int)0, (boolean[])array, (boolean[])new boolean[]{false}));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, true}, (boolean[])ArrayUtils.insert((int)1, (boolean[])array, (boolean[])new boolean[]{false}));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false}, (boolean[])ArrayUtils.insert((int)array.length, (boolean[])array, (boolean[])new boolean[]{false}));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, true, false, true}, (boolean[])ArrayUtils.insert((int)0, (boolean[])array, (boolean[])values));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false, false, true}, (boolean[])ArrayUtils.insert((int)1, (boolean[])array, (boolean[])values));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false, true, false}, (boolean[])ArrayUtils.insert((int)array.length, (boolean[])array, (boolean[])values));
    }

    @Test
    void testInsertBytes() {
        byte[] array = new byte[]{1, 2, 3};
        byte[] values = new byte[]{4, 5, 6};
        byte[] result = ArrayUtils.insert((int)42, (byte[])array, null);
        Assertions.assertArrayEquals((byte[])array, (byte[])result);
        Assertions.assertNotSame((Object)array, (Object)result);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (byte[])array));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])ArrayUtils.insert((int)0, (byte[])new byte[0], null));
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, (byte[])null, null));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)-1, (byte[])array, (byte[])array));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)(array.length + 1), (byte[])array, (byte[])array));
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3}, (byte[])ArrayUtils.insert((int)0, (byte[])array, (byte[])new byte[]{0}));
        Assertions.assertArrayEquals((byte[])new byte[]{1, 0, 2, 3}, (byte[])ArrayUtils.insert((int)1, (byte[])array, (byte[])new byte[]{0}));
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 0}, (byte[])ArrayUtils.insert((int)array.length, (byte[])array, (byte[])new byte[]{0}));
        Assertions.assertArrayEquals((byte[])new byte[]{4, 5, 6, 1, 2, 3}, (byte[])ArrayUtils.insert((int)0, (byte[])array, (byte[])values));
        Assertions.assertArrayEquals((byte[])new byte[]{1, 4, 5, 6, 2, 3}, (byte[])ArrayUtils.insert((int)1, (byte[])array, (byte[])values));
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6}, (byte[])ArrayUtils.insert((int)array.length, (byte[])array, (byte[])values));
    }

    @Test
    void testInsertChars() {
        char[] array = new char[]{'a', 'b', 'c'};
        char[] values = new char[]{'d', 'e', 'f'};
        char[] result = ArrayUtils.insert((int)42, (char[])array, null);
        Assertions.assertArrayEquals((char[])array, (char[])result);
        Assertions.assertNotSame((Object)array, (Object)result);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (char[])array));
        Assertions.assertArrayEquals((char[])new char[0], (char[])ArrayUtils.insert((int)0, (char[])new char[0], null));
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, (char[])null, null));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)-1, (char[])array, (char[])array));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)(array.length + 1), (char[])array, (char[])array));
        Assertions.assertArrayEquals((char[])new char[]{'z', 'a', 'b', 'c'}, (char[])ArrayUtils.insert((int)0, (char[])array, (char[])new char[]{'z'}));
        Assertions.assertArrayEquals((char[])new char[]{'a', 'z', 'b', 'c'}, (char[])ArrayUtils.insert((int)1, (char[])array, (char[])new char[]{'z'}));
        Assertions.assertArrayEquals((char[])new char[]{'a', 'b', 'c', 'z'}, (char[])ArrayUtils.insert((int)array.length, (char[])array, (char[])new char[]{'z'}));
        Assertions.assertArrayEquals((char[])new char[]{'d', 'e', 'f', 'a', 'b', 'c'}, (char[])ArrayUtils.insert((int)0, (char[])array, (char[])values));
        Assertions.assertArrayEquals((char[])new char[]{'a', 'd', 'e', 'f', 'b', 'c'}, (char[])ArrayUtils.insert((int)1, (char[])array, (char[])values));
        Assertions.assertArrayEquals((char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f'}, (char[])ArrayUtils.insert((int)array.length, (char[])array, (char[])values));
    }

    @Test
    void testInsertDoubles() {
        double[] array = new double[]{1.0, 2.0, 3.0};
        double[] values = new double[]{4.0, 5.0, 6.0};
        double delta = 1.0E-6;
        double[] result = ArrayUtils.insert((int)42, (double[])array, null);
        Assertions.assertArrayEquals((double[])array, (double[])result, (double)1.0E-6);
        Assertions.assertNotSame((Object)array, (Object)result);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (double[])array));
        Assertions.assertArrayEquals((double[])new double[0], (double[])ArrayUtils.insert((int)0, (double[])new double[0], null), (double)1.0E-6);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, (double[])null, null));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)-1, (double[])array, (double[])array));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)(array.length + 1), (double[])array, (double[])array));
        Assertions.assertArrayEquals((double[])new double[]{0.0, 1.0, 2.0, 3.0}, (double[])ArrayUtils.insert((int)0, (double[])array, (double[])new double[]{0.0}), (double)1.0E-6);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 0.0, 2.0, 3.0}, (double[])ArrayUtils.insert((int)1, (double[])array, (double[])new double[]{0.0}), (double)1.0E-6);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0, 0.0}, (double[])ArrayUtils.insert((int)array.length, (double[])array, (double[])new double[]{0.0}), (double)1.0E-6);
        Assertions.assertArrayEquals((double[])new double[]{4.0, 5.0, 6.0, 1.0, 2.0, 3.0}, (double[])ArrayUtils.insert((int)0, (double[])array, (double[])values), (double)1.0E-6);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 4.0, 5.0, 6.0, 2.0, 3.0}, (double[])ArrayUtils.insert((int)1, (double[])array, (double[])values), (double)1.0E-6);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, (double[])ArrayUtils.insert((int)array.length, (double[])array, (double[])values), (double)1.0E-6);
    }

    @Test
    void testInsertFloats() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f};
        float[] values = new float[]{4.0f, 5.0f, 6.0f};
        float delta = 1.0E-6f;
        float[] result = ArrayUtils.insert((int)42, (float[])array, null);
        Assertions.assertArrayEquals((float[])array, (float[])result, (float)1.0E-6f);
        Assertions.assertNotSame((Object)array, (Object)result);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (float[])array));
        Assertions.assertArrayEquals((float[])new float[0], (float[])ArrayUtils.insert((int)0, (float[])new float[0], null), (float)1.0E-6f);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, (float[])null, null));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)-1, (float[])array, (float[])array));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)(array.length + 1), (float[])array, (float[])array));
        Assertions.assertArrayEquals((float[])new float[]{0.0f, 1.0f, 2.0f, 3.0f}, (float[])ArrayUtils.insert((int)0, (float[])array, (float[])new float[]{0.0f}), (float)1.0E-6f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 0.0f, 2.0f, 3.0f}, (float[])ArrayUtils.insert((int)1, (float[])array, (float[])new float[]{0.0f}), (float)1.0E-6f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 3.0f, 0.0f}, (float[])ArrayUtils.insert((int)array.length, (float[])array, (float[])new float[]{0.0f}), (float)1.0E-6f);
        Assertions.assertArrayEquals((float[])new float[]{4.0f, 5.0f, 6.0f, 1.0f, 2.0f, 3.0f}, (float[])ArrayUtils.insert((int)0, (float[])array, (float[])values), (float)1.0E-6f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 4.0f, 5.0f, 6.0f, 2.0f, 3.0f}, (float[])ArrayUtils.insert((int)1, (float[])array, (float[])values), (float)1.0E-6f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f}, (float[])ArrayUtils.insert((int)array.length, (float[])array, (float[])values), (float)1.0E-6f);
    }

    @Test
    void testInsertGenericArray() {
        Object[] array = new String[]{"a", "b", "c"};
        Object[] values = new String[]{"d", "e", "f"};
        Object[] result = (String[])ArrayUtils.insert((int)42, (Object[])array, (Object[])null);
        Assertions.assertArrayEquals((Object[])array, (Object[])result);
        Assertions.assertNotSame((Object)array, (Object)result);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (Object[])array));
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])ArrayUtils.insert((int)0, (Object[])new String[0], (Object[])null));
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (Object[])null));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtilsInsertTest.lambda$testInsertGenericArray$10((String[])array));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtilsInsertTest.lambda$testInsertGenericArray$11((String[])array));
        Assertions.assertArrayEquals((Object[])new String[]{"z", "a", "b", "c"}, (Object[])ArrayUtils.insert((int)0, (Object[])array, (Object[])new String[]{"z"}));
        Assertions.assertArrayEquals((Object[])new String[]{"a", "z", "b", "c"}, (Object[])ArrayUtils.insert((int)1, (Object[])array, (Object[])new String[]{"z"}));
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c", "z"}, (Object[])ArrayUtils.insert((int)array.length, (Object[])array, (Object[])new String[]{"z"}));
        Assertions.assertArrayEquals((Object[])new String[]{"d", "e", "f", "a", "b", "c"}, (Object[])ArrayUtils.insert((int)0, (Object[])array, (Object[])values));
        Assertions.assertArrayEquals((Object[])new String[]{"a", "d", "e", "f", "b", "c"}, (Object[])ArrayUtils.insert((int)1, (Object[])array, (Object[])values));
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d", "e", "f"}, (Object[])ArrayUtils.insert((int)array.length, (Object[])array, (Object[])values));
    }

    @Test
    void testInsertInts() {
        int[] array = new int[]{1, 2, 3};
        int[] values = new int[]{4, 5, 6};
        int[] result = ArrayUtils.insert((int)42, (int[])array, null);
        Assertions.assertArrayEquals((int[])array, (int[])result);
        Assertions.assertNotSame((Object)array, (Object)result);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (int[])array));
        Assertions.assertArrayEquals((int[])new int[0], (int[])ArrayUtils.insert((int)0, (int[])new int[0], null));
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, (int[])null, null));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)-1, (int[])array, (int[])array));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)(array.length + 1), (int[])array, (int[])array));
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3}, (int[])ArrayUtils.insert((int)0, (int[])array, (int[])new int[]{0}));
        Assertions.assertArrayEquals((int[])new int[]{1, 0, 2, 3}, (int[])ArrayUtils.insert((int)1, (int[])array, (int[])new int[]{0}));
        Assertions.assertArrayEquals((int[])new int[]{1, 2, 3, 0}, (int[])ArrayUtils.insert((int)array.length, (int[])array, (int[])new int[]{0}));
        Assertions.assertArrayEquals((int[])new int[]{4, 5, 6, 1, 2, 3}, (int[])ArrayUtils.insert((int)0, (int[])array, (int[])values));
        Assertions.assertArrayEquals((int[])new int[]{1, 4, 5, 6, 2, 3}, (int[])ArrayUtils.insert((int)1, (int[])array, (int[])values));
        Assertions.assertArrayEquals((int[])new int[]{1, 2, 3, 4, 5, 6}, (int[])ArrayUtils.insert((int)array.length, (int[])array, (int[])values));
    }

    @Test
    void testInsertLongs() {
        long[] array = new long[]{1L, 2L, 3L};
        long[] values = new long[]{4L, 5L, 6L};
        long[] result = ArrayUtils.insert((int)42, (long[])array, null);
        Assertions.assertArrayEquals((long[])array, (long[])result);
        Assertions.assertNotSame((Object)array, (Object)result);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (long[])array));
        Assertions.assertArrayEquals((long[])new long[0], (long[])ArrayUtils.insert((int)0, (long[])new long[0], null));
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, (long[])null, null));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)-1, (long[])array, (long[])array));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)(array.length + 1), (long[])array, (long[])array));
        Assertions.assertArrayEquals((long[])new long[]{0L, 1L, 2L, 3L}, (long[])ArrayUtils.insert((int)0, (long[])array, (long[])new long[]{0L}));
        Assertions.assertArrayEquals((long[])new long[]{1L, 0L, 2L, 3L}, (long[])ArrayUtils.insert((int)1, (long[])array, (long[])new long[]{0L}));
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 0L}, (long[])ArrayUtils.insert((int)array.length, (long[])array, (long[])new long[]{0L}));
        Assertions.assertArrayEquals((long[])new long[]{4L, 5L, 6L, 1L, 2L, 3L}, (long[])ArrayUtils.insert((int)0, (long[])array, (long[])values));
        Assertions.assertArrayEquals((long[])new long[]{1L, 4L, 5L, 6L, 2L, 3L}, (long[])ArrayUtils.insert((int)1, (long[])array, (long[])values));
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L}, (long[])ArrayUtils.insert((int)array.length, (long[])array, (long[])values));
    }

    @Test
    void testInsertShorts() {
        short[] array = new short[]{1, 2, 3};
        short[] values = new short[]{4, 5, 6};
        short[] result = ArrayUtils.insert((int)42, (short[])array, null);
        Assertions.assertArrayEquals((short[])array, (short[])result);
        Assertions.assertNotSame((Object)array, (Object)result);
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, null, (short[])array));
        Assertions.assertArrayEquals((short[])new short[0], (short[])ArrayUtils.insert((int)0, (short[])new short[0], null));
        Assertions.assertNull((Object)ArrayUtils.insert((int)42, (short[])null, null));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)-1, (short[])array, (short[])array));
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.insert((int)(array.length + 1), (short[])array, (short[])array));
        Assertions.assertArrayEquals((short[])new short[]{0, 1, 2, 3}, (short[])ArrayUtils.insert((int)0, (short[])array, (short[])new short[]{0}));
        Assertions.assertArrayEquals((short[])new short[]{1, 0, 2, 3}, (short[])ArrayUtils.insert((int)1, (short[])array, (short[])new short[]{0}));
        Assertions.assertArrayEquals((short[])new short[]{1, 2, 3, 0}, (short[])ArrayUtils.insert((int)array.length, (short[])array, (short[])new short[]{0}));
        Assertions.assertArrayEquals((short[])new short[]{4, 5, 6, 1, 2, 3}, (short[])ArrayUtils.insert((int)0, (short[])array, (short[])values));
        Assertions.assertArrayEquals((short[])new short[]{1, 4, 5, 6, 2, 3}, (short[])ArrayUtils.insert((int)1, (short[])array, (short[])values));
        Assertions.assertArrayEquals((short[])new short[]{1, 2, 3, 4, 5, 6}, (short[])ArrayUtils.insert((int)array.length, (short[])array, (short[])values));
    }

    private static /* synthetic */ void lambda$testInsertGenericArray$11(String[] array) throws Throwable {
        ArrayUtils.insert((int)(array.length + 1), (Object[])array, (Object[])array);
    }

    private static /* synthetic */ void lambda$testInsertGenericArray$10(String[] array) throws Throwable {
        ArrayUtils.insert((int)-1, (Object[])array, (Object[])array);
    }
}

