/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.commons.lang3.concurrent.ConstantInitializer;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConcurrentUtilsTest
extends AbstractLangTest {
    ConcurrentUtilsTest() {
    }

    @Test
    void testConcurrentExceptionCauseError() {
        LangAssertions.assertIllegalArgumentException(() -> new ConcurrentException("An error", (Throwable)new Error()));
    }

    @Test
    void testConcurrentExceptionCauseNull() {
        LangAssertions.assertIllegalArgumentException(() -> new ConcurrentException(null));
    }

    @Test
    void testConcurrentExceptionCauseUnchecked() {
        LangAssertions.assertIllegalArgumentException(() -> new ConcurrentException((Throwable)new RuntimeException()));
    }

    @Test
    void testConcurrentRuntimeExceptionCauseError() {
        LangAssertions.assertIllegalArgumentException(() -> new ConcurrentRuntimeException("An error", (Throwable)new Error()));
    }

    @Test
    void testConcurrentRuntimeExceptionCauseNull() {
        LangAssertions.assertIllegalArgumentException(() -> new ConcurrentRuntimeException(null));
    }

    @Test
    void testConcurrentRuntimeExceptionCauseUnchecked() {
        LangAssertions.assertIllegalArgumentException(() -> new ConcurrentRuntimeException((Throwable)new RuntimeException()));
    }

    @Test
    void testConstantFuture_Integer() throws Exception {
        Integer value = 5;
        Future test = ConcurrentUtils.constantFuture((Object)value);
        Assertions.assertTrue((boolean)test.isDone());
        Assertions.assertSame((Object)value, test.get());
        Assertions.assertSame((Object)value, test.get(1000L, TimeUnit.SECONDS));
        Assertions.assertSame((Object)value, test.get(1000L, null));
        Assertions.assertFalse((boolean)test.isCancelled());
        Assertions.assertFalse((boolean)test.cancel(true));
        Assertions.assertFalse((boolean)test.cancel(false));
    }

    @Test
    void testConstantFuture_null() throws Exception {
        Object value = null;
        Future test = ConcurrentUtils.constantFuture(value);
        Assertions.assertTrue((boolean)test.isDone());
        Assertions.assertSame(value, test.get());
        Assertions.assertSame(value, test.get(1000L, TimeUnit.SECONDS));
        Assertions.assertSame(value, test.get(1000L, null));
        Assertions.assertFalse((boolean)test.isCancelled());
        Assertions.assertFalse((boolean)test.cancel(true));
        Assertions.assertFalse((boolean)test.cancel(false));
    }

    @Test
    void testCreateIfAbsentKeyNotPresent() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        String key = "testKey";
        Integer value = 42;
        EasyMock.expect((Object)((Integer)init.get())).andReturn((Object)value);
        EasyMock.replay((Object[])new Object[]{init});
        ConcurrentHashMap map = new ConcurrentHashMap();
        Assertions.assertEquals((Integer)value, (Integer)((Integer)ConcurrentUtils.createIfAbsent(map, (Object)"testKey", (ConcurrentInitializer)init)), (String)"Wrong result");
        Assertions.assertEquals((Integer)value, (Integer)((Integer)map.get("testKey")), (String)"Wrong value in map");
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    void testCreateIfAbsentKeyPresent() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        EasyMock.replay((Object[])new Object[]{init});
        String key = "testKey";
        Integer value = 42;
        ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
        map.put("testKey", value);
        Assertions.assertEquals((Integer)value, (Integer)((Integer)ConcurrentUtils.createIfAbsent(map, (Object)"testKey", (ConcurrentInitializer)init)), (String)"Wrong result");
        Assertions.assertEquals((Integer)value, (Integer)((Integer)map.get("testKey")), (String)"Wrong value in map");
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    void testCreateIfAbsentNullInit() throws ConcurrentException {
        ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
        String key = "testKey";
        Integer value = 42;
        map.put("testKey", value);
        Assertions.assertNull((Object)ConcurrentUtils.createIfAbsent(map, (Object)"testKey", null), (String)"Wrong result");
        Assertions.assertEquals((Integer)value, (Integer)((Integer)map.get("testKey")), (String)"Map was changed");
    }

    @Test
    void testCreateIfAbsentNullMap() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        EasyMock.replay((Object[])new Object[]{init});
        Assertions.assertNull((Object)ConcurrentUtils.createIfAbsent(null, (Object)"test", (ConcurrentInitializer)init), (String)"Wrong result");
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    void testCreateIfAbsentUncheckedException() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        Exception ex = new Exception();
        EasyMock.expect((Object)((Integer)init.get())).andThrow((Throwable)new ConcurrentException((Throwable)ex));
        EasyMock.replay((Object[])new Object[]{init});
        ConcurrentRuntimeException crex = (ConcurrentRuntimeException)Assertions.assertThrows(ConcurrentRuntimeException.class, () -> ConcurrentUtils.createIfAbsentUnchecked(new ConcurrentHashMap(), (Object)"test", (ConcurrentInitializer)init));
        Assertions.assertEquals((Object)ex, (Object)crex.getCause(), (String)"Wrong cause");
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    void testCreateIfAbsentUncheckedSuccess() {
        String key = "testKey";
        Integer value = 42;
        ConcurrentHashMap map = new ConcurrentHashMap();
        Assertions.assertEquals((Integer)value, (Integer)((Integer)ConcurrentUtils.createIfAbsentUnchecked(map, (Object)"testKey", (ConcurrentInitializer)new ConstantInitializer((Object)value))), (String)"Wrong result");
        Assertions.assertEquals((Integer)value, (Integer)((Integer)map.get("testKey")), (String)"Wrong value in map");
    }

    @Test
    void testExtractCauseChecked() {
        Exception ex = new Exception("Test");
        ConcurrentException cex = ConcurrentUtils.extractCause((ExecutionException)new ExecutionException(ex));
        Assertions.assertSame((Object)ex, (Object)cex.getCause(), (String)"Wrong cause");
    }

    @Test
    void testExtractCauseError() {
        AssertionError err = new AssertionError((Object)"Test");
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> ConcurrentUtilsTest.lambda$testExtractCauseError$7((Error)((Object)err))));
        Assertions.assertEquals((Object)err, (Object)e, (String)"Wrong error");
    }

    @Test
    void testExtractCauseNull() {
        Assertions.assertNull((Object)((Object)ConcurrentUtils.extractCause(null)), (String)"Non null result");
    }

    @Test
    void testExtractCauseNullCause() {
        Assertions.assertNull((Object)((Object)ConcurrentUtils.extractCause((ExecutionException)new ExecutionException("Test", null))), (String)"Non null result");
    }

    @Test
    void testExtractCauseUncheckedChecked() {
        Exception ex = new Exception("Test");
        ConcurrentRuntimeException cex = ConcurrentUtils.extractCauseUnchecked((ExecutionException)new ExecutionException(ex));
        Assertions.assertSame((Object)ex, (Object)cex.getCause(), (String)"Wrong cause");
    }

    @Test
    void testExtractCauseUncheckedError() {
        AssertionError err = new AssertionError((Object)"Test");
        Error e = (Error)Assertions.assertThrows(Error.class, () -> ConcurrentUtilsTest.lambda$testExtractCauseUncheckedError$8((Error)((Object)err)));
        Assertions.assertEquals((Object)err, (Object)e, (String)"Wrong error");
    }

    @Test
    void testExtractCauseUncheckedException() {
        RuntimeException rex = new RuntimeException("Test");
        Assertions.assertThrows(RuntimeException.class, () -> ConcurrentUtils.extractCause((ExecutionException)new ExecutionException(rex)));
    }

    @Test
    void testExtractCauseUncheckedNull() {
        Assertions.assertNull((Object)ConcurrentUtils.extractCauseUnchecked(null), (String)"Non null result");
    }

    @Test
    void testExtractCauseUncheckedNullCause() {
        Assertions.assertNull((Object)ConcurrentUtils.extractCauseUnchecked((ExecutionException)new ExecutionException("Test", null)), (String)"Non null result");
    }

    @Test
    void testExtractCauseUncheckedUncheckedException() {
        RuntimeException rex = new RuntimeException("Test");
        RuntimeException r = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConcurrentUtils.extractCauseUnchecked((ExecutionException)new ExecutionException(rex)));
        Assertions.assertEquals((Object)rex, (Object)r, (String)"Wrong exception");
    }

    @Test
    void testHandleCauseChecked() {
        Exception ex = new Exception("Test");
        ConcurrentException cex = (ConcurrentException)Assertions.assertThrows(ConcurrentException.class, () -> ConcurrentUtils.handleCause((ExecutionException)new ExecutionException(ex)));
        Assertions.assertEquals((Object)ex, (Object)cex.getCause(), (String)"Wrong cause");
    }

    @Test
    void testHandleCauseError() {
        AssertionError err = new AssertionError((Object)"Test");
        Error e = (Error)Assertions.assertThrows(Error.class, () -> ConcurrentUtilsTest.lambda$testHandleCauseError$12((Error)((Object)err)));
        Assertions.assertEquals((Object)err, (Object)e, (String)"Wrong error");
    }

    @Test
    void testHandleCauseNull() throws ConcurrentException {
        ConcurrentUtils.handleCause(null);
        ConcurrentUtils.handleCause((ExecutionException)new ExecutionException("Test", null));
    }

    @Test
    void testHandleCauseUncheckedChecked() {
        Exception ex = new Exception("Test");
        ConcurrentRuntimeException crex = (ConcurrentRuntimeException)Assertions.assertThrows(ConcurrentRuntimeException.class, () -> ConcurrentUtils.handleCauseUnchecked((ExecutionException)new ExecutionException(ex)));
        Assertions.assertEquals((Object)ex, (Object)crex.getCause(), (String)"Wrong cause");
    }

    @Test
    void testHandleCauseUncheckedError() {
        AssertionError err = new AssertionError((Object)"Test");
        Error e = (Error)Assertions.assertThrows(Error.class, () -> ConcurrentUtilsTest.lambda$testHandleCauseUncheckedError$14((Error)((Object)err)));
        Assertions.assertEquals((Object)err, (Object)e, (String)"Wrong error");
    }

    @Test
    void testHandleCauseUncheckedException() {
        RuntimeException rex = new RuntimeException("Test");
        RuntimeException r = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConcurrentUtils.handleCause((ExecutionException)new ExecutionException(rex)));
        Assertions.assertEquals((Object)rex, (Object)r, (String)"Wrong exception");
    }

    @Test
    void testHandleCauseUncheckedNull() {
        ConcurrentUtils.handleCauseUnchecked(null);
        ConcurrentUtils.handleCauseUnchecked((ExecutionException)new ExecutionException("Test", null));
    }

    @Test
    void testHandleCauseUncheckedUncheckedException() {
        RuntimeException rex = new RuntimeException("Test");
        RuntimeException r = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConcurrentUtils.handleCauseUnchecked((ExecutionException)new ExecutionException(rex)));
        Assertions.assertEquals((Object)rex, (Object)r, (String)"Wrong exception");
    }

    @Test
    void testInitialize() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        Object result = new Object();
        EasyMock.expect((Object)init.get()).andReturn(result);
        EasyMock.replay((Object[])new Object[]{init});
        Assertions.assertSame((Object)result, (Object)ConcurrentUtils.initialize((ConcurrentInitializer)init), (String)"Wrong result object");
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    void testInitializeNull() throws ConcurrentException {
        Assertions.assertNull((Object)ConcurrentUtils.initialize(null), (String)"Got a result");
    }

    @Test
    void testInitializeUnchecked() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        Object result = new Object();
        EasyMock.expect((Object)init.get()).andReturn(result);
        EasyMock.replay((Object[])new Object[]{init});
        Assertions.assertSame((Object)result, (Object)ConcurrentUtils.initializeUnchecked((ConcurrentInitializer)init), (String)"Wrong result object");
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    void testInitializeUncheckedEx() throws ConcurrentException {
        ConcurrentInitializer init = (ConcurrentInitializer)EasyMock.createMock(ConcurrentInitializer.class);
        Exception cause = new Exception();
        EasyMock.expect((Object)init.get()).andThrow((Throwable)new ConcurrentException((Throwable)cause));
        EasyMock.replay((Object[])new Object[]{init});
        ConcurrentRuntimeException crex = (ConcurrentRuntimeException)Assertions.assertThrows(ConcurrentRuntimeException.class, () -> ConcurrentUtils.initializeUnchecked((ConcurrentInitializer)init));
        Assertions.assertSame((Object)cause, (Object)crex.getCause(), (String)"Wrong cause");
        EasyMock.verify((Object[])new Object[]{init});
    }

    @Test
    void testInitializeUncheckedNull() {
        Assertions.assertNull((Object)ConcurrentUtils.initializeUnchecked(null), (String)"Got a result");
    }

    @Test
    void testPutIfAbsentKeyNotPresent() {
        String key = "testKey";
        Integer value = 42;
        ConcurrentHashMap map = new ConcurrentHashMap();
        Assertions.assertEquals((Integer)value, (Integer)((Integer)ConcurrentUtils.putIfAbsent(map, (Object)"testKey", (Object)value)), (String)"Wrong result");
        Assertions.assertEquals((Integer)value, (Integer)((Integer)map.get("testKey")), (String)"Wrong value in map");
    }

    @Test
    void testPutIfAbsentKeyPresent() {
        String key = "testKey";
        Integer value = 42;
        ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<String, Integer>();
        map.put("testKey", value);
        Assertions.assertEquals((Integer)value, (Integer)((Integer)ConcurrentUtils.putIfAbsent(map, (Object)"testKey", (Object)0)), (String)"Wrong result");
        Assertions.assertEquals((Integer)value, (Integer)((Integer)map.get("testKey")), (String)"Wrong value in map");
    }

    @Test
    void testPutIfAbsentNullMap() {
        Assertions.assertNull((Object)ConcurrentUtils.putIfAbsent(null, (Object)"test", (Object)100), (String)"Wrong result");
    }

    @Test
    void testUninitializedConcurrentRuntimeException() {
        Assertions.assertNotNull((Object)new ConcurrentRuntimeException(), (String)"Error creating empty ConcurrentRuntimeException");
    }

    private static /* synthetic */ void lambda$testHandleCauseUncheckedError$14(Error err) throws Throwable {
        ConcurrentUtils.handleCauseUnchecked((ExecutionException)new ExecutionException(err));
    }

    private static /* synthetic */ void lambda$testHandleCauseError$12(Error err) throws Throwable {
        ConcurrentUtils.handleCause((ExecutionException)new ExecutionException(err));
    }

    private static /* synthetic */ void lambda$testExtractCauseUncheckedError$8(Error err) throws Throwable {
        ConcurrentUtils.extractCauseUnchecked((ExecutionException)new ExecutionException(err));
    }

    private static /* synthetic */ void lambda$testExtractCauseError$7(Error err) throws Throwable {
        ConcurrentUtils.extractCause((ExecutionException)new ExecutionException(err));
    }
}

