/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResult
implements Serializable {
    private List<ValidationFailure> failures = new ArrayList<ValidationFailure>();

    public void addFailure(ValidationFailure failure) {
        if (failure == null) {
            throw new IllegalArgumentException("failure cannot be null.");
        }
        this.failures.add(failure);
    }

    public List<ValidationFailure> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public List<ValidationFailure> getFailures(Object source) {
        ArrayList<ValidationFailure> matchingFailures = new ArrayList<ValidationFailure>(5);
        for (ValidationFailure failure : this.failures) {
            if (!Util.nullSafeEquals(source, failure.getSource())) continue;
            matchingFailures.add(failure);
        }
        return matchingFailures;
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    public boolean hasFailures(Object source) {
        for (ValidationFailure failure : this.failures) {
            if (!Util.nullSafeEquals(source, failure.getSource())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        String separator = System.getProperty("line.separator");
        for (ValidationFailure failure : this.failures) {
            if (ret.length() > 0) {
                ret.append(separator);
            }
            ret.append(failure);
        }
        return ret.toString();
    }
}

