'\" Color=Yellow
'\"
'\" Copyright (c) 1996, Expert Interface Technologies
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" software and its documentation for any purpose, provided that the
'\" above copyright notice and the following two paragraphs appear in all
'\" copies of this software.
'\" 
'\" IN NO EVENT SHALL THE AUTHORS OF THIS SOFTWARE BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
'\" THE AUTHORS OF THIS SOFTWARE HAVE BEEN ADVISED OF THE POSSIBILITY OF
'\" SUCH DAMAGE.
'\" 
'\" THE AUTHORS OF THIS SOFTWARE SPECIFICALLY DISCLAIM ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
'\" FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON
'\" AN "AS IS" BASIS, AND THE AUTHORS OF THIS SOFTWARE HAVE NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. 
'\" 
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
.so STk-man.macros
.TH pixmap n 3.2 STk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
pixmap \- Create color images from XPM files.
.SH SYNOPSIS
(\fBimage 'create 'pixmap \fR?\fIname\fR? ?\fIoptions\fR?)
.BE

.SH DESCRIPTION
.PP
XPM is a popular X Window image file format for storing color icons.
The \fBpixmap\fR image type can be used to create color images using
XPM files.

.SH "CREATING PIXMAPS"
.PP
Like all images, pixmaps are created using the \fBimage create\fR
command. Pixmaps support the following \fIoptions\fR:
.TP
\fB:data \fIstring\fR
Specifies the contents of the source pixmap as a string.  The string
must adhere to the XPM file format (e.g., as generated by the
\fBpixmap(1)\fR program). If both the \fB\:data\fR and \fB\:file\fR
options are specified, the \fB\:data\fR option takes precedence.
Please note that the XPM file parsing code in the xpm library is
extremely fragile. The first line of the string must be "\fB/* XPM
*/\fR" or otherwise a segmentation fault will be caused.
.TP
\fB:file \fIname\fR
\fIname\fR gives the name of a file whose contents define the source
pixmap.  The file must adhere to the XPM file format (e.g., as
generated by the \fBpixmap(1)\fR program).
.SH "IMAGE PROCEDURE"
.PP
When a pixmap image is created, Tk also creates a new procedure whose
name is the same as the image.  This procedure may be used to invoke
various operations on the image.  It has the following general form:
.DS C
(\fIimageName option \fR?\fIarg arg ...\fR?)
.DE
\fIOption\fR and the \fIarg\fRs
'
determine the exact behavior of the procedure. The following
commands are possible for pixmap images:
.TP
(\fIimageName \fB'cget\fR \fIoption\fR)
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBimage create pixmap\fR command.
.TP
(\fIimageName \fB'configure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?)
'
Query or modify the configuration options for the image. If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIimageName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s); in this case
the command returns an empty string.  \fIOption\fR may have any of the
values accepted by the \fBimage create pixmap\fR command.

.SH INITIALIZATION
.PP
Use \fB(require "pixmap")\fR to initialize the pixmap package.

.SH CREDITS
.PP
This implementation of the pixmap image format has been stolen in the Tix 
package written by Ioi Kim Lam.

.SH SEE ALSO
bitmap, make-image, image, jpeg, photo
