'\" Color=Green
'\" 
'\" Derived from a document with following copyright
'\"
'\" Copyright (c) 1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) chooseColor.n 1.4 96/09/19 17:01:44
'\" 
.so STk-man.macros
.TH Tk:choose-color n 4.2 STk "STk procedure"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tk:choose-color \- pops up a dialog box for the user to select a color.
.PP
.SH SYNOPSIS
\fB(tk:choose-Color \fR?\fIoption value ...\fR?)
.BE

.SH DESCRIPTION
.PP
This procedure is part of the STk library. 
The procedure \fBTk:choose-color\fR pops up a dialog box for the
user to select a color. The following \fIoption\-value\fR pairs are
possible as command line arguments:
.TP
\fB:initial-color\fR \fIcolor\fR
Specifies the color to display in the color dialog when it pops
up. 
.TP
\fB:title\fR \fItitleString\fR
Specifies a string to display as the title of the dialog box. If this
option is not specified, then an empty title will be displayed.
.LP
If the user selects a color, \fBTk:choose-color\fR will return the
name of the color.  If the
user cancels the operation,  \fBTk:choose-color\fR will return 
\fB#f\fR
.SH EXAMPLE
.CS
(pack (button '.b :text "foo"
        :bg (Tk:choose-color :initial-color "gray" 
                             :title "Choose color")))
.CE


