/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeleton;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySkeletonHeader {
    @NonNls
    public static final String BUILTIN_NAME = "(built-in)";
    @NonNls
    public static final String PREGENERATED = "(pre-generated)";
    private static final Pattern VERSION_LINE_V1 = Pattern.compile("# from (\\S+) by generator (\\S+)\\s*");
    private static final Pattern FROM_LINE_V2 = Pattern.compile("# from (.*)$");
    private static final Pattern BY_LINE_V2 = Pattern.compile("# by generator (.*)$");
    @NotNull
    private final String myFile;
    private final int myVersion;

    public PySkeletonHeader(@NotNull String binaryFile, int version2) {
        if (binaryFile == null) {
            PySkeletonHeader.$$$reportNull$$$0(0);
        }
        this.myFile = binaryFile;
        this.myVersion = version2;
    }

    @NotNull
    public String getBinaryFile() {
        String string = this.myFile;
        if (string == null) {
            PySkeletonHeader.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getVersion() {
        return this.myVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static PySkeletonHeader readSkeletonHeader(@NotNull File file) {
        if (file == null) {
            PySkeletonHeader.$$$reportNull$$$0(2);
        }
        try (LineNumberReader reader = new LineNumberReader(new FileReader(file, StandardCharsets.UTF_8));){
            String line2 = null;
            for (int i = 0; i < 3; ++i) {
                line2 = reader.readLine();
                if (line2 != null) continue;
                PySkeletonHeader pySkeletonHeader = null;
                return pySkeletonHeader;
            }
            Matcher v1Matcher = VERSION_LINE_V1.matcher(line2);
            if (v1Matcher.matches()) {
                PySkeletonHeader pySkeletonHeader = new PySkeletonHeader(v1Matcher.group(1), PySkeletonHeader.fromVersionString(v1Matcher.group(2)));
                return pySkeletonHeader;
            }
            Matcher fromMatcher = FROM_LINE_V2.matcher(line2);
            if (!fromMatcher.matches()) return null;
            String binaryFile = fromMatcher.group(1);
            line2 = reader.readLine();
            if (line2 == null) return null;
            Matcher byMatcher = BY_LINE_V2.matcher(line2);
            if (!byMatcher.matches()) return null;
            int version2 = PySkeletonHeader.fromVersionString(byMatcher.group(1));
            PySkeletonHeader pySkeletonHeader = new PySkeletonHeader(binaryFile, version2);
            return pySkeletonHeader;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static int fromVersionString(String input) {
        int dot_pos = input.indexOf(46);
        try {
            if (dot_pos > 0) {
                int major = Integer.parseInt(input.substring(0, dot_pos));
                int minor = Integer.parseInt(input.substring(dot_pos + 1));
                return (major << 8) + minor;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeleton/PySkeletonHeader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeleton/PySkeletonHeader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSkeletonHeader";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

