/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a*\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u000b"}, d2={"condaEnvFolder", "", "path", "findActivateInPath", "Ljava/io/File;", "shellName", "findActivateOnWindows", "findActivateScript", "Lkotlin/Pair;", "sdkPath", "shellPath", "intellij.python.sdk"})
public final class PyVirtualEnvReaderKt {
    @Nullable
    public static final Pair<String, String> findActivateScript(@Nullable String sdkPath, @Nullable String shellPath) {
        if (PythonSdkUtil.isVirtualEnv(sdkPath)) {
            String shellName = shellPath != null ? new File(shellPath).getName() : null;
            String string = sdkPath;
            Intrinsics.checkNotNull((Object)string);
            File activate = PyVirtualEnvReaderKt.findActivateInPath(string, shellName);
            return activate != null && activate.exists() ? new Pair((Object)activate.getAbsolutePath(), null) : null;
        }
        if (PythonSdkUtil.isConda(sdkPath)) {
            String string = sdkPath;
            Intrinsics.checkNotNull((Object)string);
            String condaExecutable = PyCondaPackageService.Companion.getCondaExecutable(string);
            if (condaExecutable != null) {
                String string2 = new File(condaExecutable).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                File activate = PyVirtualEnvReaderKt.findActivateInPath(string2, null);
                if (activate != null && activate.exists()) {
                    return new Pair((Object)activate.getPath(), (Object)PyVirtualEnvReaderKt.condaEnvFolder(sdkPath));
                }
            }
        }
        return null;
    }

    private static final File findActivateInPath(String path2, String shellName) {
        return SystemInfo.isWindows ? PyVirtualEnvReaderKt.findActivateOnWindows(path2) : (Intrinsics.areEqual((Object)shellName, (Object)"fish") || Intrinsics.areEqual((Object)shellName, (Object)"csh") ? new File(new File(path2).getParentFile(), "activate." + shellName) : new File(new File(path2).getParentFile(), "activate"));
    }

    private static final String condaEnvFolder(String path2) {
        return SystemInfo.isWindows ? new File(path2).getParent() : new File(path2).getParentFile().getParent();
    }

    private static final File findActivateOnWindows(String path2) {
        Object[] objectArray = new String[]{"activate.bat", "Scripts/activate.bat"};
        for (String location : CollectionsKt.arrayListOf((Object[])objectArray)) {
            File file = new File(new File(path2).getParentFile(), location);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }
}

