/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.pom.Navigatable;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.debugger.remote.vfs.PyRemoteDebugVirtualFS;
import com.jetbrains.python.remote.PyRemotePathMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemotePositionConverter
extends PyLocalPositionConverter {
    @NotNull
    private final PyRemotePathMapper myPathMapper;
    private final PyRemoteDebugVirtualFS myVirtualFS;

    public PyRemotePositionConverter(PyDebugProcess debugProcess, @NotNull PathMappingSettings pathMappingSettings) {
        if (pathMappingSettings == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(0);
        }
        this(debugProcess, PyRemotePathMapper.fromSettings(pathMappingSettings, PyRemotePathMapper.PyPathMappingType.USER_DEFINED));
    }

    public PyRemotePositionConverter(PyDebugProcess debugProcess, @NotNull PyRemotePathMapper pathMapper) {
        if (pathMapper == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(1);
        }
        this.myPathMapper = pathMapper;
        this.myVirtualFS = new PyRemoteDebugVirtualFS(debugProcess, pathMapper, this);
    }

    @NotNull
    public PathMapper getPathMapper() {
        PyRemotePathMapper pyRemotePathMapper = this.myPathMapper;
        if (pyRemotePathMapper == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(2);
        }
        return pyRemotePathMapper;
    }

    @Override
    @NotNull
    protected PySourcePosition convertToPython(@NotNull String filePath, int line2) {
        if (filePath == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(3);
        }
        String path2 = this.myPathMapper.convertToRemote(filePath);
        return new PyLocalPositionConverter.PyRemoteSourcePosition(path2, line2);
    }

    @Override
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, String frameName) {
        if (position == null) {
            PyRemotePositionConverter.$$$reportNull$$$0(4);
        }
        String path2 = position.getFile();
        int line2 = position.getLine();
        return this.convert(path2, line2);
    }

    @Override
    protected VirtualFileSystem getLocalFileSystem() {
        return this.myVirtualFS;
    }

    @Override
    public PySignature convertSignature(PySignature signature) {
        String localPath = this.getPathMapper().convertToLocal(signature.getFile());
        return new PySignature(localPath, signature.getFunctionName()).addAllArgs(signature);
    }

    @Nullable
    private XSourcePosition convert(String path2, int line2) {
        VirtualFile file = this.getVirtualFile(path2);
        XSourcePosition xPosition = PyRemotePositionConverter.createXSourcePosition(file, line2);
        if (xPosition != null) {
            return new XRemoteSourcePosition(xPosition);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappingSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/remote/vfs/PyRemotePositionConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/remote/vfs/PyRemotePositionConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToPython";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertFromPython";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class XRemoteSourcePosition
    extends XSourcePositionWrapper {
        private VirtualFile myFile;

        public XRemoteSourcePosition(@NotNull XSourcePosition xPosition) {
            if (xPosition == null) {
                XRemoteSourcePosition.$$$reportNull$$$0(0);
            }
            super(xPosition);
            this.myFile = xPosition.getFile();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                XRemoteSourcePosition.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        public void setFile(VirtualFile file) {
            this.myFile = file;
        }

        @NotNull
        public Navigatable createNavigatable(@NotNull Project project2) {
            if (project2 == null) {
                XRemoteSourcePosition.$$$reportNull$$$0(2);
            }
            Navigatable navigatable = XDebuggerUtilImpl.createNavigatable((Project)project2, (XSourcePosition)this);
            if (navigatable == null) {
                XRemoteSourcePosition.$$$reportNull$$$0(3);
            }
            return navigatable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xPosition";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/remote/vfs/PyRemotePositionConverter$XRemoteSourcePosition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/remote/vfs/PyRemotePositionConverter$XRemoteSourcePosition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createNavigatable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }
}

