/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.reStructuredText.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.reStructuredText.psi.RestElement;
import com.intellij.python.reStructuredText.psi.RestReferenceTarget;
import com.intellij.python.reStructuredText.psi.RestTitle;
import com.intellij.python.reStructuredText.validation.RestElementVisitor;
import org.jetbrains.annotations.NotNull;

public class RestReference
extends RestElement {
    public RestReference(@NotNull ASTNode node) {
        if (node == null) {
            RestReference.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public String toString() {
        return "RestReference:" + this.getNode().getElementType().toString();
    }

    public String getReferenceText() {
        String text = this.getNode().getText();
        text = StringUtil.replace((String)text, (String)"\n", (String)" ");
        if ((text = text.replaceAll("\\\\([^\\\\]+)", "$1")).startsWith("`") && text.endsWith("`_")) {
            return text.substring(1, text.length() - 2);
        }
        if (text.endsWith("__")) {
            return "__";
        }
        if (text.startsWith("|") && text.endsWith("|")) {
            return text;
        }
        return text.substring(0, text.length() - 1);
    }

    @Override
    protected void acceptRestVisitor(RestElementVisitor visitor2) {
        visitor2.visitReference(this);
    }

    public RestElement resolve() {
        RestTitle[] titles;
        String name2 = this.getReferenceText();
        PsiFile file = this.getContainingFile();
        RestReferenceTarget[] elements = (RestReferenceTarget[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestReferenceTarget.class);
        if (elements != null) {
            if (name2.equals("__") || name2.equals("[*]") || name2.equals("[#]")) {
                return this.findAnonimousTarget(file, elements);
            }
            for (RestReferenceTarget element : elements) {
                if (!element.getReferenceName().equalsIgnoreCase(name2) && !element.getReferenceName(false).equalsIgnoreCase(name2)) continue;
                return element;
            }
        }
        if ((titles = (RestTitle[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestTitle.class)) != null) {
            for (RestTitle element : titles) {
                if (!name2.equalsIgnoreCase(element.getName())) continue;
                return element;
            }
        }
        return null;
    }

    private RestReferenceTarget findAnonimousTarget(PsiFile file, RestReferenceTarget[] targets) {
        String name2 = this.getReferenceText();
        RestReference[] references2 = (RestReference[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestReference.class);
        int refIndex = 1;
        int i = 0;
        while (!((Object)((Object)references2[i])).equals((Object)this)) {
            if (references2[i].getReferenceText().equals(name2)) {
                ++refIndex;
            }
            ++i;
        }
        int targetIndex = 0;
        for (int j = 0; j != targets.length; ++j) {
            if (targets[j].getReferenceName().equals(name2)) {
                ++targetIndex;
            }
            if (targetIndex != refIndex) continue;
            return targets[j];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/python/reStructuredText/psi/RestReference", "<init>"));
    }
}

