/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.tree;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SmartList;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaObjectImpl;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import com.jetbrains.jsonSchema.impl.tree.AllOfOperation;
import com.jetbrains.jsonSchema.impl.tree.AnyOfOperation;
import com.jetbrains.jsonSchema.impl.tree.OneOfOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Operation {
    @NotNull
    public final List<JsonSchemaObject> myAnyOfGroup;
    @NotNull
    public final List<List<JsonSchemaObject>> myOneOfGroup;
    @NotNull
    public final List<Operation> myChildOperations;
    @NotNull
    public final JsonSchemaObject mySourceNode;
    public SchemaResolveState myState;

    protected Operation(@NotNull JsonSchemaObject sourceNode) {
        if (sourceNode == null) {
            Operation.$$$reportNull$$$0(0);
        }
        this.myAnyOfGroup = new SmartList();
        this.myOneOfGroup = new SmartList();
        this.myState = SchemaResolveState.normal;
        this.mySourceNode = sourceNode;
        this.myChildOperations = new ArrayList<Operation>();
    }

    protected abstract void map(@NotNull Set<JsonSchemaObject> var1);

    protected abstract void reduce();

    public void doMap(@NotNull Set<JsonSchemaObject> visited) {
        if (visited == null) {
            Operation.$$$reportNull$$$0(1);
        }
        this.map(visited);
        for (Operation operation : this.myChildOperations) {
            ProgressManager.checkCanceled();
            operation.doMap(visited);
        }
    }

    public void doReduce() {
        if (!SchemaResolveState.normal.equals((Object)this.myState)) {
            this.myChildOperations.clear();
            this.myAnyOfGroup.clear();
            this.myOneOfGroup.clear();
            return;
        }
        this.myAnyOfGroup.forEach(Operation::clearVariants);
        this.myOneOfGroup.forEach(list2 -> list2.forEach(Operation::clearVariants));
        for (Operation myChildOperation : this.myChildOperations) {
            ProgressManager.checkCanceled();
            myChildOperation.doReduce();
        }
        this.reduce();
        this.myChildOperations.clear();
    }

    private static void clearVariants(@NotNull JsonSchemaObject object) {
        if (object == null) {
            Operation.$$$reportNull$$$0(2);
        }
        if (!(object instanceof JsonSchemaObjectImpl)) {
            return;
        }
        JsonSchemaObjectImpl cst = (JsonSchemaObjectImpl)object;
        cst.setAllOf(null);
        cst.setAnyOf(null);
        cst.setOneOf(null);
    }

    @Nullable
    protected Operation createExpandOperation(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service) {
        Operation forConflict;
        if (schema == null) {
            Operation.$$$reportNull$$$0(3);
        }
        if (service == null) {
            Operation.$$$reportNull$$$0(4);
        }
        if ((forConflict = Operation.getOperationForConflict(schema, service)) != null) {
            return forConflict;
        }
        if (Registry.is((String)"json.schema.object.v2") && schema.hasChildNode("anyOf") || schema.getAnyOf() != null) {
            return new AnyOfOperation(schema, service);
        }
        if (Registry.is((String)"json.schema.object.v2") && schema.hasChildNode("oneOf") || schema.getOneOf() != null) {
            return new OneOfOperation(schema, service);
        }
        if (Registry.is((String)"json.schema.object.v2") && schema.hasChildNode("allOf") || schema.getAllOf() != null) {
            return new AllOfOperation(schema, service);
        }
        return null;
    }

    @Nullable
    private static Operation getOperationForConflict(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service) {
        boolean allOf2;
        if (schema == null) {
            Operation.$$$reportNull$$$0(5);
        }
        if (service == null) {
            Operation.$$$reportNull$$$0(6);
        }
        boolean anyOf = Registry.is((String)"json.schema.object.v2") && schema.hasChildNode("anyOf") || schema.getAnyOf() != null;
        boolean oneOf = Registry.is((String)"json.schema.object.v2") && schema.hasChildNode("oneOf") || schema.getOneOf() != null;
        boolean bl = allOf2 = Registry.is((String)"json.schema.object.v2") && schema.hasChildNode("allOf") || schema.getAllOf() != null;
        if (anyOf && (oneOf || allOf2)) {
            return new AnyOfOperation(schema, service){
                {
                    this.myState = SchemaResolveState.conflict;
                }
            };
        }
        if (oneOf && allOf2) {
            return new OneOfOperation(schema, service){
                {
                    this.myState = SchemaResolveState.conflict;
                }
            };
        }
        return null;
    }

    protected static List<JsonSchemaObject> mergeOneOf(Operation op) {
        return op.myOneOfGroup.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/tree/Operation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpandOperation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOperationForConflict";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

