/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.analysis.XmlUnusedNamespaceInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlImportOptimizer
implements ImportOptimizer {
    private final XmlUnusedNamespaceInspection myInspection = new XmlUnusedNamespaceInspection();
    private final Condition<ProblemDescriptor> myCondition = descriptor -> {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        return parent != null && !this.myInspection.isSuppressedFor(parent);
    };

    public boolean supports(@NotNull PsiFile file) {
        if (file == null) {
            XmlImportOptimizer.$$$reportNull$$$0(0);
        }
        return file instanceof XmlFile;
    }

    @NotNull
    public ImportOptimizer.CollectingInfoRunnable processFile(@NotNull PsiFile file) {
        if (file == null) {
            XmlImportOptimizer.$$$reportNull$$$0(1);
        }
        XmlFile xmlFile = (XmlFile)file;
        final Project project2 = xmlFile.getProject();
        HighlightDisplayKey key2 = HighlightDisplayKey.find((String)this.myInspection.getShortName());
        final LinkedHashMap<XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix, ProblemDescriptor> fixes = new LinkedHashMap<XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix, ProblemDescriptor>();
        if (InspectionProjectProfileManager.getInstance((Project)project2).getCurrentProfile().isToolEnabled(key2, (PsiElement)xmlFile)) {
            ProblemsHolder holder = new ProblemsHolder(InspectionManager.getInstance((Project)project2), (PsiFile)xmlFile, false);
            final XmlElementVisitor visitor = (XmlElementVisitor)this.myInspection.buildVisitor(holder, false);
            new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof XmlAttribute) {
                        visitor.visitXmlAttribute((XmlAttribute)element);
                    } else {
                        super.visitElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/XmlImportOptimizer$1", "visitElement"));
                }
            }.visitFile((PsiFile)xmlFile);
            Object[] results = holder.getResultsArray();
            List list2 = ContainerUtil.filter((Object[])results, this.myCondition);
            for (ProblemDescriptor result2 : list2) {
                for (QuickFix fix : result2.getFixes()) {
                    if (!(fix instanceof XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)) continue;
                    fixes.put((XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)fix, result2);
                }
            }
        }
        return new ImportOptimizer.CollectingInfoRunnable(){
            int myRemovedNameSpaces = 0;

            public void run() {
                SmartPsiElementPointer<XmlTag> pointer = null;
                for (Map.Entry fix : fixes.entrySet()) {
                    pointer = ((XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)fix.getKey()).doFix(project2, (ProblemDescriptor)fix.getValue(), false);
                    ++this.myRemovedNameSpaces;
                }
                if (pointer != null) {
                    XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix.reformatStartTag(project2, pointer);
                }
            }

            @Nullable
            public String getUserNotificationInfo() {
                return this.myRemovedNameSpaces > 0 ? XmlBundle.message("hint.text.removed.namespace", this.myRemovedNameSpaces, this.myRemovedNameSpaces > 1 ? 0 : 1) : null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/refactoring/XmlImportOptimizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "supports";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

