/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vcs.configurable.RecordInfo;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanelKt;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurationDialog;
import com.intellij.openapi.vcs.configurable.VcsUpdateInfoScopeFilterConfigurable;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0005DEFGHB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010$\u001a\u00020%H\u0002J\u0016\u0010&\u001a\u00020%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\tH\u0002J\b\u0010)\u001a\u00020%H\u0002J\u0006\u0010*\u001a\u00020%J\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020,H\u0002J\b\u0010.\u001a\u00020,H\u0002J\u0010\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020%H\u0016J\b\u00103\u001a\u00020%H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u0002010\tH\u0002J\u000e\u00105\u001a\b\u0012\u0004\u0012\u0002060\tH\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020(0\tH\u0002J\b\u00108\u001a\u00020%H\u0002J\u0010\u00109\u001a\u00020\u000e2\u0006\u00100\u001a\u000201H\u0002J\u0006\u0010:\u001a\u00020\u000eJ\b\u0010;\u001a\u00020\u000eH\u0002J\b\u0010<\u001a\u00020%H\u0002J\u0006\u0010=\u001a\u00020%J\b\u0010>\u001a\u00020\u000eH\u0002J\b\u0010?\u001a\u00020%H\u0002J\u0010\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020\u0007H\u0002J\u0016\u0010B\u001a\u00020%2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "POSTPONE_MAPPINGS_LOADING_PANEL", "", "allSupportedVcss", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "directoryRenderer", "Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer;", "isEditingDisabled", "", "mappingTable", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "mappingTableModel", "Lcom/intellij/util/ui/ListTableModel;", "rootDetectionIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "scopeFilterConfigurable", "Lcom/intellij/openapi/vcs/configurable/VcsUpdateInfoScopeFilterConfigurable;", "tableLoadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "vcsComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "vcsConfiguration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "vcsRootCheckers", "", "", "Lcom/intellij/openapi/vcs/VcsRootChecker;", "addMapping", "", "addSelectedUnregisteredMappings", "infos", "Lcom/intellij/openapi/vcs/configurable/RecordInfo$UnregisteredMapping;", "adjustIgnoredRootsSettings", "apply", "createMainComponent", "Ljavax/swing/JComponent;", "createMappingsTable", "createProjectMappingDescription", "createRegisteredInfo", "mapping", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "dispose", "editMapping", "getModelMappings", "getSelectedRegisteredRoots", "Lcom/intellij/openapi/vcs/configurable/RecordInfo$RegisteredMappingInfo;", "getSelectedUnregisteredRoots", "initializeModel", "isMappingValid", "isModified", "onlyRegisteredRootsInSelection", "removeMapping", "reset", "rootsOfOneKindInSelection", "scheduleUnregisteredRootsLoading", "selectIndex", "index", "setDisplayedMappings", "mappings", "Companion", "MyDirectoryColumnInfo", "MyDirectoryRenderer", "MyVcsColumnInfo", "MyVcsRenderer", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,563:1\n1194#2,2:564\n1222#2,4:566\n1549#2:570\n1620#2,3:571\n1747#2,3:574\n800#2,11:577\n766#2:588\n857#2,2:589\n1549#2:591\n1620#2,3:592\n800#2,11:595\n800#2,11:606\n766#2:617\n857#2,2:618\n1549#2:620\n1620#2,3:621\n1549#2:624\n1620#2,3:625\n1603#2,9:628\n1855#2:637\n1856#2:639\n1612#2:640\n1#3:638\n*S KotlinDebug\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel\n*L\n56#1:564,2\n56#1:566,4\n175#1:570\n175#1:571,3\n244#1:574,3\n267#1:577,11\n272#1:588\n272#1:589,2\n273#1:591\n273#1:592,3\n338#1:595,11\n355#1:606,11\n392#1:617\n392#1:618,2\n393#1:620\n393#1:621,3\n394#1:624\n394#1:625,3\n403#1:628,9\n403#1:637\n403#1:639\n403#1:640\n403#1:638\n*E\n"})
public final class VcsDirectoryConfigurationPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final int POSTPONE_MAPPINGS_LOADING_PANEL;
    private final boolean isEditingDisabled;
    @NotNull
    private final ProjectLevelVcsManager vcsManager;
    @NotNull
    private final VcsConfiguration vcsConfiguration;
    @NotNull
    private final List<AbstractVcs> allSupportedVcss;
    @NotNull
    private final Map<String, VcsRootChecker> vcsRootCheckers;
    @NotNull
    private final JBLoadingPanel tableLoadingPanel;
    @NotNull
    private final TableView<RecordInfo> mappingTable;
    @NotNull
    private final ListTableModel<RecordInfo> mappingTableModel;
    @NotNull
    private final MyDirectoryRenderer directoryRenderer;
    @NotNull
    private final ComboBox<AbstractVcs> vcsComboBox;
    @NotNull
    private final VcsUpdateInfoScopeFilterConfigurable scopeFilterConfigurable;
    @Nullable
    private ProgressIndicator rootDetectionIndicator;

    /*
     * WARNING - void declaration
     */
    public VcsDirectoryConfigurationPanel(@NotNull Project project2) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.POSTPONE_MAPPINGS_LOADING_PANEL = 300;
        this.isEditingDisabled = this.project.isDefault();
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"getInstance(...)");
        this.vcsManager = projectLevelVcsManager;
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsConfiguration, (String)"getInstance(...)");
        this.vcsConfiguration = vcsConfiguration;
        AbstractVcs[] abstractVcsArray = this.vcsManager.getAllSupportedVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllSupportedVcss(...)");
        this.allSupportedVcss = ArraysKt.asList((Object[])abstractVcsArray);
        ColumnInfo[] columnInfoArray = (ColumnInfo[])VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList();
        VcsDirectoryConfigurationPanel vcsDirectoryConfigurationPanel = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            VcsRootChecker vcsRootChecker = (VcsRootChecker)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getSupportedVcs().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            map2.put(string2, element$iv$iv);
        }
        vcsDirectoryConfigurationPanel.vcsRootCheckers = destination$iv$iv;
        this.mappingTable = new TableView();
        this.mappingTable.setShowGrid(false);
        this.mappingTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        TableSpeedSearch.installOn((JTable)((JTable)this.mappingTable), arg_0 -> VcsDirectoryConfigurationPanel._init_$lambda$1(this, arg_0));
        this.scopeFilterConfigurable = new VcsUpdateInfoScopeFilterConfigurable(this.project, this.vcsConfiguration);
        this.tableLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, this.POSTPONE_MAPPINGS_LOADING_PANEL * 2);
        this.setLayout(new BorderLayout());
        this.add(this.createMainComponent());
        this.directoryRenderer = new MyDirectoryRenderer(this.project);
        columnInfoArray = new ColumnInfo[]{new MyDirectoryColumnInfo(), new MyVcsColumnInfo()};
        this.mappingTableModel = new ListTableModel(columnInfoArray);
        this.mappingTable.setModelAndUpdateColumns(this.mappingTableModel);
        this.initializeModel();
        this.vcsComboBox = VcsDirectoryConfigurationPanel.Companion.buildVcsesComboBox(this.allSupportedVcss);
        this.vcsComboBox.addItemListener(arg_0 -> VcsDirectoryConfigurationPanel._init_$lambda$2(this, arg_0));
        this.mappingTable.setRowHeight(this.vcsComboBox.getPreferredSize().height);
        if (this.isEditingDisabled) {
            this.mappingTable.setEnabled(false);
        }
    }

    public void dispose() {
        ProgressIndicator progressIndicator = this.rootDetectionIndicator;
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        this.scopeFilterConfigurable.disposeUIResources();
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeModel() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.scopeFilterConfigurable.reset();
        List items2 = new ArrayList();
        List<VcsDirectoryMapping> list2 = this.vcsManager.getDirectoryMappings();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getDirectoryMappings(...)");
        Iterable iterable = list2;
        List list3 = items2;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsDirectoryMapping vcsDirectoryMapping = (VcsDirectoryMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.createRegisteredInfo((VcsDirectoryMapping)it));
        }
        list3.addAll((List)destination$iv$iv);
        this.setDisplayedMappings(items2);
        this.scheduleUnregisteredRootsLoading();
    }

    private final void scheduleUnregisteredRootsLoading() {
        if (this.project.isDefault() || !TrustedProjects.isTrusted((Project)this.project)) {
            return;
        }
        ProgressIndicator progressIndicator = this.rootDetectionIndicator;
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        if (!VcsUtil.shouldDetectVcsMappingsFor(this.project)) {
            return;
        }
        this.rootDetectionIndicator = BackgroundTaskUtil.executeAndTryWait(arg_0 -> VcsDirectoryConfigurationPanel.scheduleUnregisteredRootsLoading$lambda$4((Function1)new Function1<ProgressIndicator, Runnable>(this){
            final /* synthetic */ VcsDirectoryConfigurationPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Runnable invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                VcsRootError error;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Collection<VcsRootError> collection = VcsRootErrorsFinder.getInstance(VcsDirectoryConfigurationPanel.access$getProject$p(this.this$0)).getOrFind();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getOrFind(...)");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    error = (VcsRootError)element$iv$iv;
                    boolean bl = false;
                    if (!(error.getType() == VcsRootError.Type.UNREGISTERED_ROOT)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    error = (VcsRootError)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(error.getMapping());
                }
                List unregisteredRoots = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                return () -> scheduleUnregisteredRootsLoading.1.invoke$lambda$4(indicator, this.this$0, unregisteredRoots);
            }

            private static final boolean invoke$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            /*
             * WARNING - void declaration
             */
            private static final void invoke$lambda$4(ProgressIndicator $indicator, VcsDirectoryConfigurationPanel this$0, List $unregisteredRoots) {
                Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$unregisteredRoots, (String)"$unregisteredRoots");
                if ($indicator.isCanceled()) {
                    return;
                }
                VcsDirectoryConfigurationPanel.access$getTableLoadingPanel$p(this$0).stopLoading();
                if (!$unregisteredRoots.isEmpty()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list2 = VcsDirectoryConfigurationPanel.access$getMappingTableModel$p(this$0).getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                    List items2 = CollectionsKt.toMutableList((Collection)list2);
                    items2.removeIf(arg_0 -> scheduleUnregisteredRootsLoading.1.invoke$lambda$4$lambda$2(scheduleUnregisteredRootsLoading.1.1.INSTANCE, arg_0));
                    Iterable iterable = $unregisteredRoots;
                    List list3 = items2;
                    boolean $i$f$map = false;
                    void var6_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        VcsDirectoryMapping vcsDirectoryMapping = (VcsDirectoryMapping)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(new RecordInfo.UnregisteredMapping((VcsDirectoryMapping)it));
                    }
                    list3.addAll((List)destination$iv$iv);
                    VcsDirectoryConfigurationPanel.access$setDisplayedMappings(this$0, items2);
                }
            }
        }, arg_0), () -> VcsDirectoryConfigurationPanel.scheduleUnregisteredRootsLoading$lambda$5(this), (long)this.POSTPONE_MAPPINGS_LOADING_PANEL, (boolean)false);
    }

    private final RecordInfo createRegisteredInfo(VcsDirectoryMapping mapping) {
        if (this.isMappingValid(mapping)) {
            return new RecordInfo.ValidMapping(mapping);
        }
        return new RecordInfo.InvalidMapping(mapping);
    }

    private final boolean isMappingValid(VcsDirectoryMapping mapping) {
        if (mapping.isDefaultMapping()) {
            return true;
        }
        VcsRootChecker vcsRootChecker = this.vcsRootCheckers.get(mapping.getVcs());
        if (vcsRootChecker == null) {
            return true;
        }
        VcsRootChecker checker = vcsRootChecker;
        VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(mapping.getDirectory());
        return directory != null && checker.validateRoot(directory);
    }

    private final void addMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.project, VcsBundle.message("directory.mapping.add.title", new Object[0]));
        if (dlg.showAndGet()) {
            List list2 = this.mappingTableModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
            List items2 = CollectionsKt.toMutableList((Collection)list2);
            VcsDirectoryMapping vcsDirectoryMapping = dlg.getMapping();
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"getMapping(...)");
            items2.add(this.createRegisteredInfo(vcsDirectoryMapping));
            this.setDisplayedMappings(items2);
        }
    }

    private final void addSelectedUnregisteredMappings(List<RecordInfo.UnregisteredMapping> infos) {
        List list2 = this.mappingTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        List items2 = CollectionsKt.toMutableList((Collection)list2);
        for (RecordInfo.UnregisteredMapping info : infos) {
            items2.remove(info);
            items2.add(this.createRegisteredInfo(info.getMapping()));
        }
        this.setDisplayedMappings(items2);
    }

    private final void setDisplayedMappings(List<? extends RecordInfo> mappings) {
        boolean bl;
        List items2;
        block4: {
            items2 = CollectionsKt.toMutableList((Collection)mappings);
            items2.removeIf(arg_0 -> VcsDirectoryConfigurationPanel.setDisplayedMappings$lambda$6(setDisplayedMappings.1.INSTANCE, arg_0));
            Iterable $this$any$iv = items2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RecordInfo it = (RecordInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof RecordInfo.UnregisteredMapping)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            items2.add(RecordInfo.UnregisteredHeader.INSTANCE);
        }
        CollectionsKt.sortWith((List)items2, (Comparator)VcsDirectoryConfigurationPanelKt.access$getRECORD_INFO_COMPARATOR$p());
        this.mappingTableModel.setItems(items2);
    }

    private final void editMapping() {
        int row2 = this.mappingTable.getSelectedRow();
        Object object = this.mappingTable.getRow(row2);
        RecordInfo.RegisteredMappingInfo registeredMappingInfo = object instanceof RecordInfo.RegisteredMappingInfo ? (RecordInfo.RegisteredMappingInfo)object : null;
        if (registeredMappingInfo == null) {
            return;
        }
        RecordInfo.RegisteredMappingInfo info = registeredMappingInfo;
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.project, VcsBundle.message("directory.mapping.remove.title", new Object[0]));
        dlg.setMapping(info.getMapping());
        if (dlg.showAndGet()) {
            List list2 = this.mappingTableModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
            List items2 = CollectionsKt.toMutableList((Collection)list2);
            VcsDirectoryMapping vcsDirectoryMapping = dlg.getMapping();
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"getMapping(...)");
            items2.set(row2, this.createRegisteredInfo(vcsDirectoryMapping));
            this.setDisplayedMappings(items2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeMapping() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        RecordInfo.RegisteredMappingInfo info;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        int index = this.mappingTable.getSelectionModel().getMinSelectionIndex();
        Collection collection = this.mappingTable.getSelection();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelection(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RecordInfo.RegisteredMappingInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selection = (List)destination$iv$iv;
        List list2 = this.mappingTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        List items2 = CollectionsKt.toMutableList((Collection)list2);
        items2.removeAll(CollectionsKt.toSet((Iterable)selection));
        $this$filterIsInstanceTo$iv$iv = selection;
        boolean $i$f$filter = false;
        void $i$f$filterIsInstanceTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            info = (RecordInfo.RegisteredMappingInfo)element$iv$iv;
            boolean bl = false;
            if (!(info instanceof RecordInfo.ValidMapping && this.vcsRootCheckers.get(info.getMapping().getVcs()) != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List removedValidRoots = (List)destination$iv$iv2;
        $this$filter$iv = removedValidRoots;
        List list3 = items2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            info = (RecordInfo.RegisteredMappingInfo)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            collection2.add(new RecordInfo.UnregisteredMapping(it.getMapping()));
        }
        list3.addAll((List)destination$iv$iv2);
        this.setDisplayedMappings(items2);
        this.selectIndex(index);
    }

    private final void selectIndex(int index) {
        List list2 = this.mappingTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        List newItems = list2;
        if (newItems.isEmpty()) {
            return;
        }
        int toSelect = index >= newItems.size() ? newItems.size() - 1 : index;
        this.mappingTable.getSelectionModel().setSelectionInterval(toSelect, toSelect);
    }

    private final JComponent createMainComponent() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gridBag = new GridBag().setDefaultInsets((Insets)JBUI.insets((int)0, (int)0, (int)4, (int)10)).setDefaultWeightX(1.0).setDefaultFill(2);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"setDefaultFill(...)");
        GridBag gb = gridBag;
        if (!TrustedProjects.isTrusted((Project)this.project)) {
            EditorNotificationPanel notificationPanel = new EditorNotificationPanel(LightColors.RED, EditorNotificationPanel.Status.Error);
            notificationPanel.setText(VcsBundle.message("configuration.project.not.trusted.label", new Object[0]));
            panel2.add((Component)notificationPanel, gb.nextLine().next());
        }
        JComponent mappingsTable = this.createMappingsTable();
        this.tableLoadingPanel.add((Component)mappingsTable);
        panel2.add((Component)this.tableLoadingPanel, gb.nextLine().next().fillCell().weighty(1.0));
        panel2.add((Component)this.createProjectMappingDescription(), gb.nextLine().next());
        AbstractVcs[] abstractVcsArray = this.vcsManager.getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        if (!AbstractCommonUpdateAction.showsCustomNotification(ArraysKt.asList((Object[])abstractVcsArray))) {
            panel2.add((Component)this.scopeFilterConfigurable.createComponent(), gb.nextLine().next());
        }
        return panel2;
    }

    private final JComponent createMappingsTable() {
        JPanel jPanel = ToolbarDecorator.createDecorator(this.mappingTable, null).setAddActionUpdater(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$10(this, arg_0)).setAddAction(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$11(this, arg_0)).setEditActionUpdater(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$12(this, arg_0)).setEditAction(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$13(this, arg_0)).setRemoveActionUpdater(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$14(this, arg_0)).setRemoveAction(arg_0 -> VcsDirectoryConfigurationPanel.createMappingsTable$lambda$15(this, arg_0)).disableUpDownActions().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel panelForTable = jPanel;
        panelForTable.setPreferredSize((Dimension)new JBDimension(-1, 200));
        return panelForTable;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RecordInfo.UnregisteredMapping> getSelectedUnregisteredRoots() {
        void $this$filterIsInstanceTo$iv$iv;
        Collection collection = this.mappingTable.getSelection();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelection(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RecordInfo.UnregisteredMapping)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean rootsOfOneKindInSelection() {
        Collection selection = this.mappingTable.getSelection();
        if (selection.isEmpty()) {
            return true;
        }
        if (selection.size() == 1 && selection.iterator().next() instanceof RecordInfo.Header) {
            return true;
        }
        List<RecordInfo.RegisteredMappingInfo> selectedRegisteredRoots = this.getSelectedRegisteredRoots();
        return selectedRegisteredRoots.size() == selection.size() || selectedRegisteredRoots.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final List<RecordInfo.RegisteredMappingInfo> getSelectedRegisteredRoots() {
        void $this$filterIsInstanceTo$iv$iv;
        Collection selection = this.mappingTable.getSelection();
        Intrinsics.checkNotNull((Object)selection);
        Iterable $this$filterIsInstance$iv = selection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RecordInfo.RegisteredMappingInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean onlyRegisteredRootsInSelection() {
        return this.getSelectedRegisteredRoots().size() == this.mappingTable.getSelection().size();
    }

    private final JComponent createProjectMappingDescription() {
        HtmlBuilder htmlBuilder = new HtmlBuilder().append(VcsDirectoryMapping.PROJECT_CONSTANT.get()).append(" - ");
        String string2 = DefaultVcsRootPolicy.getInstance(this.project).getProjectConfigurationMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProjectConfigurationMessage(...)");
        String string3 = htmlBuilder.append(StringsKt.replace$default((String)string2, (char)'\n', (char)' ', (boolean)false, (int)4, null)).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String projectMessage = string3;
        JBLabel label2 = new JBLabel(projectMessage);
        label2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        label2.setFontColor(UIUtil.FontColor.BRIGHTER);
        label2.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)0));
        return (JComponent)label2;
    }

    public final void reset() {
        this.initializeModel();
    }

    public final void apply() throws ConfigurationException {
        this.adjustIgnoredRootsSettings();
        this.vcsManager.setDirectoryMappings(this.getModelMappings());
        this.scopeFilterConfigurable.apply();
        this.initializeModel();
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustIgnoredRootsSettings() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        VcsDirectoryMapping mapping;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<VcsDirectoryMapping> newMappings = this.getModelMappings();
        List<VcsDirectoryMapping> previousMappings = this.vcsManager.getDirectoryMappings();
        Intrinsics.checkNotNull(previousMappings);
        Iterable iterable = previousMappings;
        VcsConfiguration vcsConfiguration = this.vcsConfiguration;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            mapping = (VcsDirectoryMapping)element$iv$iv;
            boolean bl = false;
            if (!(!newMappings.contains(mapping) && !mapping.isDefaultMapping())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            mapping = (VcsDirectoryMapping)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(mapping.getDirectory());
        }
        vcsConfiguration.addIgnoredUnregisteredRoots((List)destination$iv$iv);
        $this$map$iv = newMappings;
        vcsConfiguration = this.vcsConfiguration;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            mapping = (VcsDirectoryMapping)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.getDirectory());
        }
        vcsConfiguration.removeFromIgnoredUnregisteredRoots((List)destination$iv$iv);
    }

    public final boolean isModified() {
        if (this.scopeFilterConfigurable.isModified()) {
            return true;
        }
        return !Intrinsics.areEqual(this.getModelMappings(), this.vcsManager.getDirectoryMappings());
    }

    /*
     * WARNING - void declaration
     */
    private final List<VcsDirectoryMapping> getModelMappings() {
        void $this$mapNotNullTo$iv$iv;
        List list2 = this.mappingTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VcsDirectoryMapping it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RecordInfo info = (RecordInfo)element$iv$iv;
            boolean bl2 = false;
            if ((info instanceof RecordInfo.RegisteredMappingInfo ? ((RecordInfo.RegisteredMappingInfo)info).getMapping() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final String _init_$lambda$1(VcsDirectoryConfigurationPanel this$0, Object info) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return info instanceof RecordInfo.MappingInfo ? VcsDirectoryConfigurationPanelKt.access$getPresentablePath(this$0.project, ((RecordInfo.MappingInfo)info).getMapping()) : "";
    }

    private static final void _init_$lambda$2(VcsDirectoryConfigurationPanel this$0, ItemEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.mappingTable.isEditing()) {
            this$0.mappingTable.stopEditing();
        }
    }

    private static final Runnable scheduleUnregisteredRootsLoading$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Runnable)$tmp0.invoke(p0);
    }

    private static final void scheduleUnregisteredRootsLoading$lambda$5(VcsDirectoryConfigurationPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.tableLoadingPanel.startLoading();
    }

    private static final boolean setDisplayedMappings$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean createMappingsTable$lambda$10(VcsDirectoryConfigurationPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isEditingDisabled && this$0.rootsOfOneKindInSelection();
    }

    private static final void createMappingsTable$lambda$11(VcsDirectoryConfigurationPanel this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List<RecordInfo.UnregisteredMapping> unregisteredRoots = this$0.getSelectedUnregisteredRoots();
        if (unregisteredRoots.isEmpty()) {
            this$0.addMapping();
        } else {
            this$0.addSelectedUnregisteredMappings(unregisteredRoots);
        }
    }

    private static final boolean createMappingsTable$lambda$12(VcsDirectoryConfigurationPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isEditingDisabled && this$0.onlyRegisteredRootsInSelection();
    }

    private static final void createMappingsTable$lambda$13(VcsDirectoryConfigurationPanel this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.editMapping();
    }

    private static final boolean createMappingsTable$lambda$14(VcsDirectoryConfigurationPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isEditingDisabled && this$0.onlyRegisteredRootsInSelection();
    }

    private static final void createMappingsTable$lambda$15(VcsDirectoryConfigurationPanel this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.removeMapping();
    }

    @JvmStatic
    @NotNull
    public static final ComboBox<AbstractVcs> buildVcsesComboBox(@NotNull Project project2) {
        return Companion.buildVcsesComboBox(project2);
    }

    public static final /* synthetic */ Project access$getProject$p(VcsDirectoryConfigurationPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ JBLoadingPanel access$getTableLoadingPanel$p(VcsDirectoryConfigurationPanel $this) {
        return $this.tableLoadingPanel;
    }

    public static final /* synthetic */ ListTableModel access$getMappingTableModel$p(VcsDirectoryConfigurationPanel $this) {
        return $this.mappingTableModel;
    }

    public static final /* synthetic */ void access$setDisplayedMappings(VcsDirectoryConfigurationPanel $this, List mappings) {
        $this.setDisplayedMappings(mappings);
    }

    public static final /* synthetic */ ComboBox access$getVcsComboBox$p(VcsDirectoryConfigurationPanel $this) {
        return $this.vcsComboBox;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$Companion;", "", "()V", "buildVcsesComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/openapi/vcs/AbstractVcs;", "project", "Lcom/intellij/openapi/project/Project;", "allVcses", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,563:1\n37#2,2:564\n*S KotlinDebug\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$Companion\n*L\n477#1:564,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ComboBox<AbstractVcs> buildVcsesComboBox(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object[] objectArray = ProjectLevelVcsManager.getInstance(project2).getAllSupportedVcss();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllSupportedVcss(...)");
            Object[] allVcses = objectArray;
            return this.buildVcsesComboBox(ArraysKt.asList((Object[])allVcses));
        }

        private final ComboBox<AbstractVcs> buildVcsesComboBox(List<? extends AbstractVcs> allVcses) {
            Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)allVcses, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ComboBox comboBox = new ComboBox((Object[])thisCollection$iv.toArray(new AbstractVcs[0]));
            comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)VcsBundle.message("none.vcs.presentation", new Object[0]), arg_0 -> Companion.buildVcsesComboBox$lambda$0(buildVcsesComboBox.1.INSTANCE, arg_0)));
            return comboBox;
        }

        private static final String buildVcsesComboBox$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "(Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel;)V", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "vcsDirectoryMapping", "valueOf", "mapping", "intellij.platform.vcs.impl"})
    private final class MyDirectoryColumnInfo
    extends ColumnInfo<RecordInfo, RecordInfo> {
        public MyDirectoryColumnInfo() {
            super(VcsBundle.message("column.info.configure.vcses.directory", new Object[0]));
        }

        @NotNull
        public RecordInfo valueOf(@NotNull RecordInfo mapping) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            return mapping;
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull RecordInfo vcsDirectoryMapping) {
            Intrinsics.checkNotNullParameter((Object)vcsDirectoryMapping, (String)"vcsDirectoryMapping");
            return (TableCellRenderer)((Object)VcsDirectoryConfigurationPanel.this.directoryRenderer);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,563:1\n1549#2:564\n1620#2,3:565\n1549#2:568\n1620#2,3:569\n*S KotlinDebug\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer\n*L\n95#1:564\n95#1:565,3\n97#1:568\n97#1:569,3\n*E\n"})
    private static final class MyDirectoryRenderer
    extends ColoredTableCellRenderer {
        @NotNull
        private final Project project;

        public MyDirectoryRenderer(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row2, int column) {
            Object presentablePath;
            RecordInfo recordInfo;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.configurable.RecordInfo");
            RecordInfo cfr_ignored_0 = (RecordInfo)value2;
            SimpleTextAttributes textAttributes = VcsDirectoryConfigurationPanelKt.access$getAttributes((RecordInfo)value2);
            this.setToolTipText(null);
            if (!selected && ((RecordInfo)value2).isUnregistered()) {
                this.setBackground(UIUtil.getDecoratedRowColor());
            }
            if ((recordInfo = (RecordInfo)value2) instanceof RecordInfo.MappingInfo) {
                presentablePath = VcsDirectoryConfigurationPanelKt.access$getPresentablePath(this.project, ((RecordInfo.MappingInfo)value2).getMapping());
                SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)table, (String)presentablePath, (SimpleTextAttributes)textAttributes, (boolean)selected, (SimpleColoredComponent)((SimpleColoredComponent)this));
            } else if (recordInfo instanceof RecordInfo.Header) {
                this.append(((RecordInfo.Header)value2).getLabel(), textAttributes);
            }
            if (value2 instanceof RecordInfo.RegisteredMappingInfo && ((RecordInfo.RegisteredMappingInfo)value2).getMapping().isDefaultMapping()) {
                String string2 = ((RecordInfo.RegisteredMappingInfo)value2).getMapping().getVcs();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVcs(...)");
                List roots = VcsDirectoryConfigurationPanelKt.access$collectDefaultMappedRoots(this.project, string2);
                if (!((Collection)roots).isEmpty()) {
                    FilePath it;
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    this.append(FontUtil.spaceAndThinSpace(), textAttributes);
                    presentablePath = new Object[]{roots.size()};
                    this.append(VcsBundle.message("project.detected.n.roots.presentation", presentablePath), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                    presentablePath = roots;
                    MyDirectoryRenderer myDirectoryRenderer = this;
                    boolean $i$f$map = false;
                    void var11_12 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(VcsUtil.getFilePath((VirtualFile)it));
                    }
                    Iterable iterable = (List)destination$iv$iv;
                    HierarchicalFilePathComparator hierarchicalFilePathComparator = HierarchicalFilePathComparator.NATURAL;
                    Intrinsics.checkNotNullExpressionValue((Object)hierarchicalFilePathComparator, (String)"NATURAL");
                    $this$map$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)hierarchicalFilePathComparator);
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (FilePath)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(StringUtil.escapeXmlEntities((String)it.getPresentableUrl()));
                    }
                    myDirectoryRenderer.setToolTipText(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"<br/>", null, null, (int)0, null, null, (int)62, null));
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyVcsColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "", "(Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel;)V", "getAdditionalWidth", "", "getEditor", "Ljavax/swing/table/TableCellEditor;", "o", "getMaxStringValue", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "info", "isCellEditable", "", "setValue", "", "newVcs", "valueOf", "intellij.platform.vcs.impl"})
    private final class MyVcsColumnInfo
    extends ColumnInfo<RecordInfo, String> {
        public MyVcsColumnInfo() {
            super(VcsBundle.message("column.name.configure.vcses.vcs", new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull RecordInfo info) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Object object = info instanceof RecordInfo.MappingInfo ? (RecordInfo.MappingInfo)info : null;
            if ((object != null && (object = ((RecordInfo.MappingInfo)object).getMapping()) != null ? ((VcsDirectoryMapping)object).getVcs() : (string2 = null)) == null) {
                string2 = "";
            }
            return string2;
        }

        public boolean isCellEditable(@NotNull RecordInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return info instanceof RecordInfo.RegisteredMappingInfo;
        }

        public void setValue(@NotNull RecordInfo info, @NotNull String newVcs) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)newVcs, (String)"newVcs");
            if (info instanceof RecordInfo.RegisteredMappingInfo) {
                VcsDirectoryMapping oldMapping = ((RecordInfo.RegisteredMappingInfo)info).getMapping();
                ((RecordInfo.RegisteredMappingInfo)info).setMapping(new VcsDirectoryMapping(oldMapping.getDirectory(), newVcs, oldMapping.getRootSettings()));
            }
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull RecordInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return (TableCellRenderer)((Object)new MyVcsRenderer(info, VcsDirectoryConfigurationPanel.this.allSupportedVcss));
        }

        @NotNull
        public TableCellEditor getEditor(@NotNull RecordInfo o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            return (TableCellEditor)new AbstractTableCellEditor(VcsDirectoryConfigurationPanel.this){
                final /* synthetic */ VcsDirectoryConfigurationPanel this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public Object getCellEditorValue() {
                    AbstractVcs selectedVcs;
                    AbstractVcs abstractVcs = selectedVcs = (AbstractVcs)VcsDirectoryConfigurationPanel.access$getVcsComboBox$p(this.this$0).getItem();
                    String string2 = abstractVcs == null ? "" : abstractVcs.getName();
                    Intrinsics.checkNotNull((Object)string2);
                    return string2;
                }

                @NotNull
                public Component getTableCellEditorComponent(@NotNull JTable table, @NotNull Object value2, boolean isSelected, int row2, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    VcsDirectoryConfigurationPanel.access$getVcsComboBox$p(this.this$0).setSelectedItem(value2);
                    return (Component)VcsDirectoryConfigurationPanel.access$getVcsComboBox$p(this.this$0);
                }
            };
        }

        @Nullable
        public String getMaxStringValue() {
            String maxString = null;
            for (AbstractVcs vcs : VcsDirectoryConfigurationPanel.this.allSupportedVcss) {
                String name;
                Intrinsics.checkNotNullExpressionValue((Object)vcs.getDisplayName(), (String)"getDisplayName(...)");
                if (maxString != null && maxString.length() >= name.length()) continue;
                maxString = name;
            }
            return maxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyVcsRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "info", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "allSupportedVcss", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "(Lcom/intellij/openapi/vcs/configurable/RecordInfo;Ljava/util/List;)V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyVcsRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,563:1\n1#2:564\n*E\n"})
    private static final class MyVcsRenderer
    extends ColoredTableCellRenderer {
        @NotNull
        private final RecordInfo info;
        @NotNull
        private final List<AbstractVcs> allSupportedVcss;

        public MyVcsRenderer(@NotNull RecordInfo info, @NotNull List<? extends AbstractVcs> allSupportedVcss) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(allSupportedVcss, (String)"allSupportedVcss");
            this.info = info;
            this.allSupportedVcss = allSupportedVcss;
        }

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row2, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            SimpleTextAttributes textAttributes = VcsDirectoryConfigurationPanelKt.access$getAttributes(this.info);
            if (!selected && this.info.isUnregistered()) {
                this.setBackground(UIUtil.getDecoratedRowColor());
            }
            if (this.info instanceof RecordInfo.MappingInfo) {
                String string2 = ((RecordInfo.MappingInfo)this.info).getMapping().getVcs();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVcs(...)");
                String vcsName = string2;
                if (((CharSequence)vcsName).length() == 0) {
                    this.append(VcsBundle.message("none.vcs.presentation", new Object[0]), textAttributes);
                } else {
                    AbstractVcs vcs;
                    Object object;
                    Object v1;
                    Object[] objectArray;
                    block6: {
                        objectArray = (Object[])this.allSupportedVcss;
                        for (Object t : objectArray) {
                            AbstractVcs it = (AbstractVcs)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)vcsName, (Object)it.getName())) continue;
                            v1 = t;
                            break block6;
                        }
                        v1 = null;
                    }
                    if ((object = (vcs = (AbstractVcs)v1)) == null || (object = ((AbstractVcs)object).getDisplayName()) == null) {
                        objectArray = new Object[]{vcsName};
                        object = VcsBundle.message("unknown.vcs.presentation", objectArray);
                    }
                    this.append((String)object, textAttributes);
                }
            }
        }
    }
}

