/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.commit;

import com.intellij.dvcs.commit.AmendCommitServiceKt;
import com.intellij.dvcs.commit.LoadDetailsTaskInfo;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.EditedCommitDetails;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dvcs/commit/AmendCommitService;", "Lcom/intellij/vcs/commit/AmendCommitAware;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "vcsLog", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "getVcsLog", "()Lcom/intellij/vcs/log/impl/VcsProjectLog;", "vcsLogObjectsFactory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "getVcsLogObjectsFactory", "()Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "getAmendCommitDetails", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lcom/intellij/vcs/commit/EditedCommitDetails;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCommitDetails", "Lorg/jetbrains/concurrency/AsyncPromise;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "hash", "Lcom/intellij/vcs/log/Hash;", "intellij.platform.vcs.dvcs.impl"})
@SourceDebugExtension(value={"SMAP\nAmendCommitService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmendCommitService.kt\ncom/intellij/dvcs/commit/AmendCommitService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,84:1\n31#2,2:85\n*S KotlinDebug\n*F\n+ 1 AmendCommitService.kt\ncom/intellij/dvcs/commit/AmendCommitService\n*L\n38#1:85,2\n*E\n"})
public abstract class AmendCommitService
implements AmendCommitAware {
    @NotNull
    private final Project project;

    public AmendCommitService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    private final VcsProjectLog getVcsLog() {
        return VcsProjectLog.Companion.getInstance(this.project);
    }

    private final VcsLogObjectsFactory getVcsLogObjectsFactory() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<VcsLogObjectsFactory> serviceClass$iv = VcsLogObjectsFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VcsLogObjectsFactory)object;
    }

    @Override
    @NotNull
    public CancellablePromise<EditedCommitDetails> getAmendCommitDetails(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Repository repository = VcsRepositoryManager.getInstance(this.project).getRepositoryForRootQuick(root);
        if (repository == null) {
            Object[] objectArray = new Object[]{root};
            String string2 = DvcsBundle.message("error.message.amend.no.repository.for.root", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return AmendCommitServiceKt.access$rejected(string2);
        }
        Repository repository2 = repository;
        VcsLogData vcsLogData = this.getVcsLog().getDataManager();
        if (vcsLogData == null) {
            String string3 = DvcsBundle.message("error.message.amend.no.vcs.log.available", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            return AmendCommitServiceKt.access$rejected(string3);
        }
        VcsLogData logData = vcsLogData;
        String string4 = repository2.getCurrentRevision();
        if (string4 == null) {
            Object[] objectArray = new Object[]{root};
            String string5 = DvcsBundle.message("error.message.amend.repository.is.empty.for.root", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            return AmendCommitServiceKt.access$rejected(string5);
        }
        String lastCommitId = string4;
        Hash hash2 = this.getVcsLogObjectsFactory().createHash(lastCommitId);
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"createHash(...)");
        return (CancellablePromise)this.getCommitDetails(logData, root, hash2);
    }

    private final AsyncPromise<EditedCommitDetails> getCommitDetails(VcsLogData logData, VirtualFile root, Hash hash2) {
        AsyncPromise promise = new AsyncPromise();
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(this.project, (TaskInfo)new LoadDetailsTaskInfo(), PerformInBackgroundOption.ALWAYS_BACKGROUND);
        promise.onError(arg_0 -> AmendCommitService.getCommitDetails$lambda$0((Function1)new Function1<Throwable, Unit>(indicator){
            final /* synthetic */ BackgroundableProcessIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Promises.errorIfNotMessage((Logger)AmendCommitServiceKt.access$getLOG$p(), (Throwable)it);
                if (this.$indicator.isRunning()) {
                    this.$indicator.cancel();
                }
            }
        }, arg_0));
        logData.getCommitDetailsGetter().loadCommitsData((List<Integer>)CollectionsKt.listOf((Object)logData.getCommitIndex(hash2, root)), arg_0 -> AmendCommitService.getCommitDetails$lambda$1((Function1)new Function1<List<? extends VcsFullCommitDetails>, Unit>((AsyncPromise<EditedCommitDetails>)promise, hash2, logData, root){
            final /* synthetic */ AsyncPromise<EditedCommitDetails> $promise;
            final /* synthetic */ Hash $hash;
            final /* synthetic */ VcsLogData $logData;
            final /* synthetic */ VirtualFile $root;
            {
                this.$promise = $promise;
                this.$hash = $hash;
                this.$logData = $logData;
                this.$root = $root;
                super(1);
            }

            public final void invoke(List<? extends VcsFullCommitDetails> commits2) {
                Intrinsics.checkNotNull(commits2);
                AmendCommitServiceKt.access$setCommit(this.$promise, this.$hash, (VcsFullCommitDetails)CollectionsKt.firstOrNull(commits2), this.$logData.getCurrentUser().get(this.$root));
            }
        }, arg_0), (Consumer<? super Throwable>)((Consumer<Throwable>)((Consumer)arg_0 -> AmendCommitService.getCommitDetails$lambda$2((Function1)new Function1<Throwable, Unit>((AsyncPromise<EditedCommitDetails>)promise){
            final /* synthetic */ AsyncPromise<EditedCommitDetails> $promise;
            {
                this.$promise = $promise;
                super(1);
            }

            public final void invoke(Throwable error) {
                Intrinsics.checkNotNull((Object)error);
                this.$promise.setError(error);
            }
        }, arg_0))), (ProgressIndicator)indicator);
        return promise;
    }

    private static final void getCommitDetails$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void getCommitDetails$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void getCommitDetails$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

