/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.FeatureSuggestersManagerListener;
import training.featuresSuggester.PopupSuggestion;
import training.featuresSuggester.SuggestingUtils;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.EditorFocusGainedAction;
import training.featuresSuggester.settings.FeatureSuggesterSettings;
import training.featuresSuggester.statistics.FeatureSuggesterStatistics;
import training.featuresSuggester.suggesters.FeatureSuggester;
import training.featuresSuggester.ui.NotificationSuggestionPresenter;
import training.featuresSuggester.ui.SuggestionPresenter;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltraining/featuresSuggester/FeatureSuggestersManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "suggestionPresenter", "Ltraining/featuresSuggester/ui/SuggestionPresenter;", "actionPerformed", "", "action", "Ltraining/featuresSuggester/actions/Action;", "dispose", "fireSuggestionFound", "suggestion", "Ltraining/featuresSuggester/PopupSuggestion;", "handleAction", "initFocusListener", "processSuggester", "suggester", "Ltraining/featuresSuggester/suggesters/FeatureSuggester;", "isEnabled", "", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nFeatureSuggestersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureSuggestersManager.kt\ntraining/featuresSuggester/FeatureSuggestersManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n9#2:90\n766#3:91\n857#3:92\n858#3:94\n1#4:93\n*S KotlinDebug\n*F\n+ 1 FeatureSuggestersManager.kt\ntraining/featuresSuggester/FeatureSuggestersManager\n*L\n36#1:90\n42#1:91\n42#1:92\n42#1:94\n*E\n"})
public final class FeatureSuggestersManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final SuggestionPresenter suggestionPresenter;

    public FeatureSuggestersManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.suggestionPresenter = new NotificationSuggestionPresenter();
        if (!this.project.isDefault()) {
            this.initFocusListener();
        }
    }

    public final void actionPerformed(@NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        try {
            this.handleAction(action2);
        }
        catch (Throwable t) {
            FeatureSuggestersManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FeatureSuggestersManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("An error occurred during action processing: " + action2, t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleAction(Action action2) {
        void $this$filterTo$iv$iv;
        Language language = action2.getLanguage();
        if (language == null) {
            return;
        }
        Language language2 = language;
        Iterable $this$filter$iv = FeatureSuggester.Companion.getSuggesters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object v1;
            block4: {
                FeatureSuggester it = (FeatureSuggester)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = it.getLanguages();
                for (Object t : iterable2) {
                    String id = (String)t;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)id, (Object)Language.ANY.getID()) || Intrinsics.areEqual((Object)id, (Object)language2.getID()))) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            boolean bl = v1 != null;
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suggesters = (List)destination$iv$iv;
        for (FeatureSuggester suggester : suggesters) {
            if (!this.isEnabled(suggester)) continue;
            this.processSuggester(suggester, action2);
        }
    }

    private final void processSuggester(FeatureSuggester suggester, Action action2) {
        Suggestion suggestion = suggester.getSuggestion(action2);
        if (suggestion instanceof PopupSuggestion) {
            FeatureSuggesterStatistics.INSTANCE.logSuggestionFound(suggester.getId());
            if (SuggestingUtils.INSTANCE.getForceShowSuggestions() || suggester.isSuggestionNeeded()) {
                this.suggestionPresenter.showSuggestion(this.project, (PopupSuggestion)suggestion, this);
                this.fireSuggestionFound((PopupSuggestion)suggestion);
                FeatureSuggesterSettings.Companion.instance().updateSuggestionShownTime(((PopupSuggestion)suggestion).getSuggesterId());
            }
        }
    }

    private final void fireSuggestionFound(PopupSuggestion suggestion) {
        ((FeatureSuggestersManagerListener)this.project.getMessageBus().syncPublisher(FeatureSuggestersManagerListener.Companion.getTOPIC())).featureFound(suggestion);
    }

    private final void initFocusListener() {
        block0: {
            EditorEventMulticasterEx eventMulticaster;
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            EditorEventMulticasterEx editorEventMulticasterEx = eventMulticaster = editorEventMulticaster instanceof EditorEventMulticasterEx ? (EditorEventMulticasterEx)editorEventMulticaster : null;
            if (editorEventMulticasterEx == null) break block0;
            editorEventMulticasterEx.addFocusChangeListener(new FocusChangeListener(this){
                final /* synthetic */ FeatureSuggestersManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusGained(@NotNull Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    if (!Intrinsics.areEqual((Object)editor.getProject(), (Object)FeatureSuggestersManager.access$getProject$p(this.this$0)) || !SuggestingUtils.INSTANCE.isActionsProcessingEnabled(FeatureSuggestersManager.access$getProject$p(this.this$0))) {
                        return;
                    }
                    this.this$0.actionPerformed(new EditorFocusGainedAction(editor, System.currentTimeMillis()));
                }
            }, (Disposable)this);
        }
    }

    public void dispose() {
    }

    private final boolean isEnabled(FeatureSuggester $this$isEnabled) {
        return FeatureSuggesterSettings.Companion.instance().isEnabled($this$isEnabled.getId());
    }

    public static final /* synthetic */ Project access$getProject$p(FeatureSuggestersManager $this) {
        return $this.project;
    }
}

