/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Strings;

public abstract class AbstractRecursiveOperationConfiguration {
    protected static final String DEFAULT_DELIMITER = ", ";
    private final Set<String> ignoredFields = new LinkedHashSet<String>();
    private final List<Pattern> ignoredFieldsRegexes = new ArrayList<Pattern>();
    private final Set<Class<?>> ignoredTypes = new LinkedHashSet();

    protected AbstractRecursiveOperationConfiguration(AbstractBuilder<?> builder) {
        this.ignoreFields(((AbstractBuilder)builder).ignoredFields);
        this.ignoreFieldsMatchingRegexes(((AbstractBuilder)builder).ignoredFieldsMatchingRegexes);
        this.ignoreFieldsOfTypes(((AbstractBuilder)builder).ignoredTypes);
    }

    protected AbstractRecursiveOperationConfiguration() {
    }

    public void ignoreFields(String ... fieldsToIgnore) {
        List<String> fieldLocations = Lists.list(fieldsToIgnore);
        this.ignoredFields.addAll(fieldLocations);
    }

    public Set<String> getIgnoredFields() {
        return this.ignoredFields;
    }

    public void ignoreFieldsMatchingRegexes(String ... regexes) {
        List patterns = Stream.of(regexes).map(Pattern::compile).collect(Collectors.toList());
        this.ignoredFieldsRegexes.addAll(patterns);
    }

    public List<Pattern> getIgnoredFieldsRegexes() {
        return this.ignoredFieldsRegexes;
    }

    public void ignoreFieldsOfTypes(Class<?> ... types) {
        Arrays.stream(types).map(AbstractRecursiveOperationConfiguration::asWrapperIfPrimitiveType).forEach(this.ignoredTypes::add);
    }

    protected static Class<?> asWrapperIfPrimitiveType(Class<?> type2) {
        if (!type2.isPrimitive()) {
            return type2;
        }
        if (type2.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type2.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type2.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type2.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type2.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type2.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type2.equals(Double.TYPE)) {
            return Double.class;
        }
        return type2;
    }

    public Set<Class<?>> getIgnoredTypes() {
        return this.ignoredTypes;
    }

    protected void describeIgnoredFields(StringBuilder description) {
        if (!this.getIgnoredFields().isEmpty()) {
            description.append(String.format("- the following fields were ignored in the comparison: %s%n", this.describeIgnoredFields()));
        }
    }

    protected void describeIgnoredFieldsRegexes(StringBuilder description) {
        if (!this.getIgnoredFieldsRegexes().isEmpty()) {
            description.append(String.format("- the fields matching the following regexes were ignored in the comparison: %s%n", this.describeRegexes(this.getIgnoredFieldsRegexes())));
        }
    }

    protected String describeIgnoredTypes() {
        List<String> typesDescription = this.getIgnoredTypes().stream().map(Class::getName).collect(Collectors.toList());
        return AbstractRecursiveOperationConfiguration.join(typesDescription);
    }

    protected String describeRegexes(List<Pattern> regexes) {
        List<String> fieldsDescription = regexes.stream().map(Pattern::pattern).collect(Collectors.toList());
        return AbstractRecursiveOperationConfiguration.join(fieldsDescription);
    }

    protected static String join(Collection<String> typesDescription) {
        return Strings.join(typesDescription).with(DEFAULT_DELIMITER);
    }

    public boolean matchesAnIgnoredFieldRegex(FieldLocation fieldLocation) {
        return this.getIgnoredFieldsRegexes().stream().anyMatch(fieldLocation::hierarchyMatchesRegex);
    }

    public boolean matchesAnIgnoredField(FieldLocation fieldLocation) {
        return this.getIgnoredFields().stream().anyMatch(fieldLocation::hierarchyMatches);
    }

    private String describeIgnoredFields() {
        return AbstractRecursiveOperationConfiguration.join(this.getIgnoredFields());
    }

    protected static class AbstractBuilder<BUILDER_TYPE extends AbstractBuilder<BUILDER_TYPE>> {
        private final BUILDER_TYPE thisBuilder;
        private String[] ignoredFields = new String[0];
        private String[] ignoredFieldsMatchingRegexes = new String[0];
        private Class<?>[] ignoredTypes = new Class[0];

        protected AbstractBuilder(Class<? extends AbstractBuilder<BUILDER_TYPE>> selfType) {
            this.thisBuilder = selfType.cast(this);
        }

        public BUILDER_TYPE withIgnoredFields(String ... fieldsToIgnore) {
            this.ignoredFields = fieldsToIgnore;
            return this.thisBuilder;
        }

        public BUILDER_TYPE withIgnoredFieldsMatchingRegexes(String ... regexes) {
            this.ignoredFieldsMatchingRegexes = regexes;
            return this.thisBuilder;
        }

        public BUILDER_TYPE withIgnoredFieldsOfTypes(Class<?> ... types) {
            this.ignoredTypes = types;
            return this.thisBuilder;
        }
    }
}

