/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeLink;
import com.jetbrains.ide.model.uiautomation.BeNotification;
import com.jetbrains.ide.model.uiautomation.BeNotificationClose;
import com.jetbrains.ide.model.uiautomation.BeNotificationType;
import com.jetbrains.rd.ide.model.ColorId;
import com.jetbrains.rd.ide.model.ThemeColorId;
import com.jetbrains.rd.platform.colors.ColorHost;
import com.jetbrains.rd.ui.RdUiBundle;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.ui.bindable.views.utils.BeComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/NotificationViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeNotification;", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rd.ui"})
public final class NotificationViewControl
implements ViewBinder<BeNotification> {
    @Override
    @NotNull
    public JComponent bind(@NotNull BeNotification viewModel, @NotNull Lifetime lifetime) {
        JLabel jLabel;
        OpaquePanel contentPanel;
        OpaquePanel opaquePanel;
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        boolean canBeClosed = viewModel.getCloseAction() == BeNotificationClose.CLOSE;
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)6, (int)10);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        JBEmptyBorder interBorder = jBEmptyBorder;
        OpaquePanel $this$bind_u24lambda_u241 = opaquePanel = (contentPanel = new OpaquePanel((LayoutManager)new BorderLayout()));
        boolean bl = false;
        JComponent label = ViewRegistryKt.getView(viewModel.getPresentation(), lifetime);
        label.setForeground(switch (WhenMappings.$EnumSwitchMapping$0[viewModel.getType().ordinal()]) {
            case 1 -> label.getForeground();
            case 2 -> NamedColorUtil.getErrorForeground();
            case 3 -> ColorHost.Companion.getInstance().getColor(new ThemeColorId(ColorId.Success)).darker();
            case 4 -> MessageType.INFO.getTitleForeground();
            case 5 -> MessageType.WARNING.getTitleForeground();
            case 6 -> UIUtil.getLabelForeground();
            default -> throw new NoWhenBranchMatchedException();
        });
        JComponent toolbar2 = ViewRegistryKt.getView((BeControl)viewModel.getToolbar(), lifetime);
        JPanel linkPanel = (JPanel)new NonOpaquePanel((LayoutManager)new BorderLayout());
        if (canBeClosed) {
            JLabel jLabel2;
            JLabel $this$bind_u24lambda_u241_u24lambda_u240 = jLabel2 = new JLabel(null, AllIcons.Actions.Close, 4);
            boolean bl2 = false;
            $this$bind_u24lambda_u241_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
            $this$bind_u24lambda_u241_u24lambda_u240.addMouseListener(new MouseAdapter(contentPanel){
                final /* synthetic */ OpaquePanel $contentPanel;
                {
                    this.$contentPanel = $contentPanel;
                }

                public void mousePressed(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$contentPanel.setVisible(false);
                }
            });
            $this$bind_u24lambda_u241_u24lambda_u240.setToolTipText(RdUiBundle.INSTANCE.message("becontrols.notification.close", new Object[0]));
            jLabel = jLabel2;
        } else {
            jLabel = null;
        }
        JLabel closeLabel2 = jLabel;
        $this$bind_u24lambda_u241.add((Component)label, (Object)"Center");
        $this$bind_u24lambda_u241.add((Component)linkPanel, (Object)"East");
        $this$bind_u24lambda_u241.add((Component)toolbar2, (Object)"West");
        if (closeLabel2 != null) {
            $this$bind_u24lambda_u241.add((Component)closeLabel2);
        }
        JBEmptyBorder jBEmptyBorder2 = JBUI.Borders.emptyLeft((int)10);
        Intrinsics.checkNotNull((Object)jBEmptyBorder2, (String)"null cannot be cast to non-null type javax.swing.border.Border");
        Border outsideBorder = (Border)jBEmptyBorder2;
        $this$bind_u24lambda_u241.setBackground(switch (WhenMappings.$EnumSwitchMapping$0[viewModel.getType().ordinal()]) {
            case 1 -> JBUI.CurrentTheme.Notification.BACKGROUND;
            case 2 -> MessageType.ERROR.getPopupBackground();
            case 3 -> MessageType.INFO.getPopupBackground();
            case 4 -> HintUtil.getInformationColor();
            case 5 -> MessageType.WARNING.getPopupBackground();
            case 6 -> JBColor.PanelBackground;
            default -> throw new NoWhenBranchMatchedException();
        });
        if (viewModel.getHasBorder()) {
            Color borderColor = switch (WhenMappings.$EnumSwitchMapping$0[viewModel.getType().ordinal()]) {
                case 1 -> JBUI.CurrentTheme.Tooltip.borderColor();
                case 2 -> MessageType.ERROR.getBorderColor();
                case 3 -> ColorHost.Companion.getInstance().getColor(new ThemeColorId(ColorId.Success)).darker();
                case 4 -> MessageType.INFO.getBorderColor();
                case 5 -> MessageType.WARNING.getBorderColor();
                case 6 -> JBColor.border();
                default -> throw new NoWhenBranchMatchedException();
            };
            Border border = JBUI.Borders.customLine((Color)borderColor, (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLine(...)");
            outsideBorder = border;
        }
        $this$bind_u24lambda_u241.setBorder(JBUI.Borders.compound((Border)outsideBorder, (Border)((Border)interBorder)));
        InterfacesKt.viewNotNull((IViewable)((IViewable)viewModel.getLinks()), (Lifetime)lifetime, (Function2)((Function2)new Function2<Lifetime, Pair<? extends Integer, ? extends BeLink>, Unit>(linkPanel, $this$bind_u24lambda_u241){
            final /* synthetic */ JPanel $linkPanel;
            final /* synthetic */ OpaquePanel $this_apply;
            {
                this.$linkPanel = $linkPanel;
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Lifetime lt, @NotNull Pair<Integer, BeLink> pair) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 1>");
                BeLink link2 = (BeLink)((Object)pair.component2());
                this.$linkPanel.add(ViewRegistryKt.getView((BeControl)link2, lt));
                this.$this_apply.revalidate();
            }
        }));
        BeComponentsKt.bindDefaultProperties(viewModel, lifetime, (JComponent)$this$bind_u24lambda_u241);
        return (JComponent)opaquePanel;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BeNotificationType.values().length];
            try {
                nArray[BeNotificationType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeNotificationType.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeNotificationType.SUCCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeNotificationType.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeNotificationType.WARNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeNotificationType.IDE_BACKGROUND.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

