/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.platform.Range;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentLogRangeShifter;", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "documentLog", "Lcom/jetbrains/rd/ide/document/DocumentLog;", "(Lcom/jetbrains/rd/ide/document/DocumentLog;)V", "checkVersions", "", "initialRangeVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "shiftOnePoint", "", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "offset", "isStickingToRight", "shiftRange", "Lcom/jetbrains/rd/platform/Range;", "range", "isVerifiable", "isGreedyToLeft", "isGreedyToRight", "shrinkHistory", "", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentLogRangeShifter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentLogRangeShifter.kt\ncom/jetbrains/rd/ide/document/DocumentLogRangeShifter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public class DocumentLogRangeShifter
implements IDocumentRangeShifter {
    @NotNull
    private final DocumentLog documentLog;

    public DocumentLogRangeShifter(@NotNull DocumentLog documentLog) {
        Intrinsics.checkNotNullParameter((Object)documentLog, (String)"documentLog");
        this.documentLog = documentLog;
    }

    @Override
    public void shrinkHistory() {
    }

    @Override
    @NotNull
    public Range shiftRange(@NotNull AbstractDocumentVersion v, @NotNull Range range, boolean isVerifiable, boolean isGreedyToLeft, boolean isGreedyToRight) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        boolean bl = range.isNormalized();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DocumentLogRangeShifter$shiftRange$22 = false;
            String $i$a$-assert-DocumentLogRangeShifter$shiftRange$22 = "Range: " + range + " is not normalized";
            throw new AssertionError((Object)$i$a$-assert-DocumentLogRangeShifter$shiftRange$22);
        }
        RdDocumentVersion initialVersion = (RdDocumentVersion)v;
        if (!this.checkVersions(initialVersion)) {
            return Range.Companion.getInvalidRange();
        }
        int resultStart = range.getStart();
        int resultEnd = range.getEnd();
        for (Map.Entry<RdDocumentVersion, RdDocumentChangeBase> entry : this.documentLog) {
            RdDocumentVersion version = entry.getKey();
            RdDocumentChangeBase change = entry.getValue();
            if (version.getValue() <= initialVersion.getValue()) continue;
            if (change instanceof RdResetDocumentChange) {
                return Range.Companion.getInvalidRange();
            }
            if (!(change instanceof RdDocumentChange)) {
                boolean $i$a$-check-DocumentLogRangeShifter$shiftRange$32 = false;
                String $i$a$-check-DocumentLogRangeShifter$shiftRange$32 = "Unknown document change type: " + change;
                throw new IllegalStateException($i$a$-check-DocumentLogRangeShifter$shiftRange$32.toString());
            }
            int oldLength = ((RdDocumentChange)change).getOldText().length();
            int newLength = ((RdDocumentChange)change).getNewText().length();
            int start = ((RdDocumentChange)change).getOffset();
            int end = start + oldLength;
            int delta = newLength - oldLength;
            if (oldLength == 0 && ((RdDocumentChange)change).getMoveOffset() != start) {
                int it = ((RdDocumentChange)change).getMoveOffset();
                boolean bl2 = false;
                int moveOffset = it > start ? it - newLength : it;
                if (moveOffset <= resultStart && resultEnd <= moveOffset + newLength) {
                    int moveDelta = start - moveOffset;
                    resultStart += moveDelta;
                    resultEnd += moveDelta;
                    continue;
                }
            }
            if (resultEnd == start && (((RdDocumentChange)change).getModificationKind() == RdTextModificationKind.RightSide || isGreedyToRight)) {
                resultEnd += delta;
                continue;
            }
            if (resultEnd <= start) continue;
            if (resultStart == end && (((RdDocumentChange)change).getModificationKind() == RdTextModificationKind.LeftSide || isGreedyToLeft)) {
                resultEnd += delta;
                continue;
            }
            if (resultStart >= end) {
                resultStart += delta;
                resultEnd += delta;
                continue;
            }
            if (resultStart <= start && end <= resultEnd && !isVerifiable) {
                resultEnd += delta;
                continue;
            }
            return Range.Companion.getInvalidRange();
        }
        return new Range(resultStart, resultEnd);
    }

    @Override
    public int shiftOnePoint(@NotNull AbstractDocumentVersion v, int offset, boolean isStickingToRight) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdDocumentVersion initialVersion = (RdDocumentVersion)v;
        if (!this.checkVersions(initialVersion)) {
            return -1;
        }
        int resultOffset = offset;
        for (Map.Entry<RdDocumentVersion, RdDocumentChangeBase> entry : this.documentLog) {
            RdDocumentVersion version = entry.getKey();
            RdDocumentChangeBase change = entry.getValue();
            if (version.getValue() <= initialVersion.getValue()) continue;
            if (change instanceof RdResetDocumentChange) {
                return -1;
            }
            if (!(change instanceof RdDocumentChange)) {
                boolean $i$a$-check-DocumentLogRangeShifter$shiftOnePoint$22 = false;
                String $i$a$-check-DocumentLogRangeShifter$shiftOnePoint$22 = "Unknown document change type: " + change;
                throw new IllegalStateException($i$a$-check-DocumentLogRangeShifter$shiftOnePoint$22.toString());
            }
            int oldLength = ((RdDocumentChange)change).getOldText().length();
            int start = ((RdDocumentChange)change).getOffset();
            int end = start + oldLength;
            int delta = ((RdDocumentChange)change).getNewText().length() - ((RdDocumentChange)change).getOldText().length();
            if (resultOffset < start) continue;
            if (resultOffset > end || isStickingToRight && oldLength == 0) {
                resultOffset += delta;
                continue;
            }
            return -1;
        }
        return resultOffset;
    }

    protected boolean checkVersions(@NotNull RdDocumentVersion initialRangeVersion) {
        Intrinsics.checkNotNullParameter((Object)initialRangeVersion, (String)"initialRangeVersion");
        return this.documentLog.contains(initialRangeVersion);
    }
}

