/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.OpenFileCommand;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class OpenFileWithTerminateCommand
extends AbstractCallbackBasedCommand {
    @NonNls
    public static final String PREFIX = "%openFileWithTerminate";

    public OpenFileWithTerminateCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            OpenFileWithTerminateCommand.$$$reportNull$$$0(0);
        }
        super(text2, line, true);
    }

    @Override
    protected void execute(@NotNull ActionCallback actionCallback, @NotNull PlaybackContext context) {
        if (actionCallback == null) {
            OpenFileWithTerminateCommand.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OpenFileWithTerminateCommand.$$$reportNull$$$0(2);
        }
        String[] arguments = this.getText().split(" ", 3);
        String filePath = arguments[1];
        long timeout = Long.parseLong(arguments[2]);
        Project project = context.getProject();
        VirtualFile file = OpenFileCommand.findFile(filePath, project);
        assert (file != null) : PerformanceTestingBundle.message("command.file.not.found", filePath);
        FileEditorManager.getInstance((Project)project).openFile(file, true);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                TimeUnit.SECONDS.sleep(timeout);
                ApplicationManager.getApplication().exit(true, true, false);
                actionCallback.setDone();
            }
            catch (InterruptedException e) {
                actionCallback.reject(e.getMessage());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/OpenFileWithTerminateCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

