/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ExpandMenuCommand
extends AbstractCallbackBasedCommand {
    public ExpandMenuCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            ExpandMenuCommand.$$$reportNull$$$0(0);
        }
        super(text2, line, true);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) {
        if (callback2 == null) {
            ExpandMenuCommand.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ExpandMenuCommand.$$$reportNull$$$0(2);
        }
        ActionManager actionManager = ActionManager.getInstance();
        Component focusedComponent = IdeFocusManager.findInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusedComponent);
        ActionGroup mainMenu = (ActionGroup)actionManager.getAction(this.getGroupId());
        Span totalSpan = PerformanceTestSpan.TRACER.spanBuilder(this.getSpanName()).startSpan();
        ((JBTreeTraverser)JBTreeTraverser.from(action -> {
            totalSpan.addEvent(action.getClass().getSimpleName());
            if (!(action instanceof ActionGroup)) {
                return JBIterable.empty();
            }
            ActionGroup group = (ActionGroup)action;
            String groupSpanName = (String)ObjectUtils.coalesce((Object)actionManager.getId((AnAction)group), (Object)group.getTemplateText(), (Object)group.getClass().getName());
            Span groupSpan = PerformanceTestSpan.TRACER.spanBuilder(groupSpanName).setParent(Context.current().with((ImplicitContextKeyed)totalSpan)).startSpan();
            List actions = Utils.expandActionGroup((ActionGroup)group, (PresentationFactory)new PresentationFactory(), (DataContext)dataContext, (String)this.getPlace());
            groupSpan.end();
            return actions;
        }).withRoots((Object[])mainMenu.getChildren(null))).traverse().size();
        totalSpan.end();
        callback2.setDone();
    }

    protected abstract String getSpanName();

    @NotNull
    protected abstract String getGroupId();

    @NotNull
    protected abstract String getPlace();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/ExpandMenuCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

