/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.tests.IgnoreException;
import com.intellij.tests.Retries;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestAdapterCache;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;

public final class JUnit5TeamCityRunnerForTestAllSuite {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ClassNotFoundException {
        try {
            Launcher launcher = LauncherFactory.create((LauncherConfig)LauncherConfig.builder().enableLauncherSessionListenerAutoRegistration(false).build());
            Object selector = args.length == 1 ? DiscoverySelectors.selectClass((String)args[0]) : DiscoverySelectors.selectMethod((String)args[0], (String)args[1]);
            TCExecutionListener listener = new TCExecutionListener();
            launcher.execute(LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{selector}).build(), new TestExecutionListener[]{listener});
            if (!listener.smthExecuted()) {
                System.exit(42);
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public static JUnit4TestAdapterCache createJUnit4TestAdapterCache() {
        return new JUnit4TestAdapterCache(){

            public RunNotifier getNotifier(final TestResult result2, JUnit4TestAdapter adapter) {
                RunNotifier notifier = new RunNotifier();
                notifier.addListener(new RunListener(){

                    public void testFailure(Failure failure) {
                        result2.addError(this.asTest(failure.getDescription()), failure.getException());
                    }

                    public void testFinished(Description description) {
                        result2.endTest(this.asTest(description));
                    }

                    public void testStarted(Description description) {
                        result2.startTest(this.asTest(description));
                    }

                    public void testIgnored(Description description) {
                        result2.addError(this.asTest(description), (Throwable)IgnoreException.INSTANCE);
                    }

                    public void testAssumptionFailure(Failure failure) {
                        this.testFailure(failure);
                    }
                });
                return notifier;
            }
        };
    }

    public static class TCExecutionListener
    implements TestExecutionListener {
        private static final String CLASS_CONFIGURATION = "Class Configuration";
        private final PrintStream myPrintStream = System.out;
        private TestPlan myTestPlan;
        private long myCurrentTestStart = 0L;
        private int myFinishCount = 0;
        private static final int MAX_STACKTRACE_MESSAGE_LENGTH = Integer.getInteger("intellij.build.test.stacktrace.max.length", 102400);

        public TCExecutionListener() {
            this.myPrintStream.println("##teamcity[enteredTheMatrix]");
        }

        public boolean smthExecuted() {
            return this.myCurrentTestStart != 0L;
        }

        public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
            StringBuilder builder = new StringBuilder();
            builder.append("timestamp = ").append(entry.getTimestamp());
            entry.getKeyValuePairs().forEach((key, value2) -> builder.append(", ").append((String)key).append(" = ").append((String)value2));
            builder.append("\n");
            this.myPrintStream.println("##teamcity[testStdOut" + this.idAndName(testIdentifier) + " out = '" + TCExecutionListener.escapeName(builder.toString()) + "']");
        }

        public void testPlanExecutionStarted(TestPlan testPlan) {
            this.myTestPlan = testPlan;
        }

        public void executionSkipped(TestIdentifier testIdentifier, String reason) {
            this.executionStarted(testIdentifier);
            this.executionFinished(testIdentifier, TestExecutionResult.Status.ABORTED, null, reason);
        }

        public void executionStarted(TestIdentifier testIdentifier) {
            if (testIdentifier.isTest()) {
                this.testStarted(testIdentifier);
                this.myCurrentTestStart = System.nanoTime();
            } else if (TCExecutionListener.hasNonTrivialParent(testIdentifier)) {
                this.myFinishCount = 0;
                this.myPrintStream.println("##teamcity[testSuiteStarted" + this.idAndName(testIdentifier) + "]");
            }
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            Throwable throwable = testExecutionResult.getThrowable().orElse(null);
            if (throwable != null && IgnoreException.isIgnoringThrowable(throwable)) {
                String message = throwable.getMessage();
                this.executionFinished(testIdentifier, TestExecutionResult.Status.ABORTED, null, message != null ? message : "");
            } else if (Retries.NUMBER > 0 && testIdentifier.isTest() && Retries.getAndClearSuccessfulStatus(testIdentifier)) {
                this.executionFinished(testIdentifier, TestExecutionResult.Status.SUCCESSFUL, null, null);
            } else {
                this.executionFinished(testIdentifier, testExecutionResult.getStatus(), throwable, null);
            }
        }

        private void executionFinished(TestIdentifier testIdentifier, TestExecutionResult.Status status, Throwable throwableOptional, String reason) {
            if (testIdentifier.isTest()) {
                long duration = this.getDuration();
                if (status == TestExecutionResult.Status.FAILED) {
                    this.testFailure(testIdentifier, "testFailed", throwableOptional, duration, reason);
                } else if (status == TestExecutionResult.Status.ABORTED) {
                    this.testFailure(testIdentifier, "testIgnored", throwableOptional, duration, reason);
                }
                this.testFinished(testIdentifier, duration);
                ++this.myFinishCount;
            } else if (TCExecutionListener.hasNonTrivialParent(testIdentifier)) {
                String messageName = null;
                if (status == TestExecutionResult.Status.FAILED) {
                    messageName = "testFailed";
                } else if (status == TestExecutionResult.Status.ABORTED) {
                    messageName = "testIgnored";
                }
                if (messageName != null) {
                    Set descendants;
                    if (status == TestExecutionResult.Status.FAILED) {
                        String parentId = this.getParentId(testIdentifier);
                        String nameAndId = " name='Class Configuration' nodeId='" + TCExecutionListener.escapeName(TCExecutionListener.getId(testIdentifier)) + "' parentNodeId='" + TCExecutionListener.escapeName(parentId) + "'";
                        this.myPrintStream.println("##teamcity[testStarted" + nameAndId + "]");
                        this.testFailure(CLASS_CONFIGURATION, TCExecutionListener.getId(testIdentifier), parentId, messageName, throwableOptional, 0L, reason);
                        this.myPrintStream.println("##teamcity[testFinished" + nameAndId + "]");
                    }
                    Set set = descendants = this.myTestPlan != null ? this.myTestPlan.getDescendants(testIdentifier) : Collections.emptySet();
                    if (!descendants.isEmpty() && this.myFinishCount == 0) {
                        for (TestIdentifier childIdentifier : descendants) {
                            this.testStarted(childIdentifier);
                            this.testFailure(childIdentifier, "testIgnored", status == TestExecutionResult.Status.ABORTED ? throwableOptional : null, 0L, reason);
                            this.testFinished(childIdentifier, 0L);
                        }
                        this.myFinishCount = 0;
                    }
                }
                this.myPrintStream.println("##teamcity[testSuiteFinished" + this.idAndName(testIdentifier) + "]");
            }
        }

        private static boolean hasNonTrivialParent(TestIdentifier testIdentifier) {
            return testIdentifier.getParentId().isPresent();
        }

        protected long getDuration() {
            return (System.nanoTime() - this.myCurrentTestStart) / 1000000L;
        }

        private void testStarted(TestIdentifier testIdentifier) {
            this.myPrintStream.println("##teamcity[testStarted" + this.idAndName(testIdentifier) + " captureStandardOutput='true']");
        }

        private void testFinished(TestIdentifier testIdentifier, long duration) {
            this.myPrintStream.println("##teamcity[testFinished" + this.idAndName(testIdentifier) + (String)(duration > 0L ? " duration='" + duration + "'" : "") + "]");
        }

        private void testFailure(TestIdentifier testIdentifier, String messageName, Throwable ex, long duration, String reason) {
            this.testFailure(TCExecutionListener.getName(testIdentifier), TCExecutionListener.getId(testIdentifier), this.getParentId(testIdentifier), messageName, ex, duration, reason);
        }

        private static String getName(TestIdentifier testIdentifier) {
            String displayName = testIdentifier.getDisplayName();
            return testIdentifier.getSource().map(s -> {
                if (s instanceof ClassSource) {
                    String className = ((ClassSource)s).getClassName();
                    if (className.equals(TestSuite.class.getName()) || className.equals(displayName)) {
                        return displayName;
                    }
                    String withDisplayName = "." + displayName;
                    return className.endsWith(withDisplayName) ? className : className + withDisplayName;
                }
                return s instanceof MethodSource ? ((MethodSource)s).getClassName() + "." + displayName : null;
            }).orElse(displayName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void testFailure(String methodName, String id, String parentId, String messageName, Throwable ex, long duration, String reason) {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            try {
                attrs.put("name", methodName);
                attrs.put("id", id);
                attrs.put("nodeId", id);
                attrs.put("parentNodeId", parentId);
                if (duration > 0L) {
                    attrs.put("duration", Long.toString(duration));
                }
                if (reason != null) {
                    attrs.put("message", TCExecutionListener.limit(reason));
                }
                if (ex != null) {
                    attrs.put("details", this.getTrace(ex));
                }
                if (ex != null) {
                    if (ex instanceof MultipleFailuresError && ((MultipleFailuresError)ex).hasFailures()) {
                        for (Throwable assertionError : ((MultipleFailuresError)ex).getFailures()) {
                            this.testFailure(methodName, id, parentId, messageName, assertionError, duration, reason);
                        }
                    } else if (ex instanceof AssertionFailedError && ((AssertionFailedError)ex).isActualDefined() && ((AssertionFailedError)ex).isExpectedDefined()) {
                        attrs.put("expected", TCExecutionListener.limit(((AssertionFailedError)ex).getExpected().getStringRepresentation()));
                        attrs.put("actual", TCExecutionListener.limit(((AssertionFailedError)ex).getActual().getStringRepresentation()));
                        attrs.put("type", "comparisonFailure");
                    } else {
                        Class<?> aClass = ex.getClass();
                        if (TCExecutionListener.isComparisonFailure(aClass)) {
                            try {
                                String expected = (String)aClass.getMethod("getExpected", new Class[0]).invoke((Object)ex, new Object[0]);
                                String actual = (String)aClass.getMethod("getActual", new Class[0]).invoke((Object)ex, new Object[0]);
                                attrs.put("expected", TCExecutionListener.limit(expected));
                                attrs.put("actual", TCExecutionListener.limit(actual));
                                attrs.put("type", "comparisonFailure");
                            }
                            catch (Throwable e) {
                                e.printStackTrace(this.myPrintStream);
                            }
                        }
                    }
                }
            }
            finally {
                this.myPrintStream.println(ServiceMessage.asString((String)messageName, attrs));
            }
        }

        private static boolean isComparisonFailure(Class<?> aClass) {
            if (aClass == null) {
                return false;
            }
            String throwableClassName = aClass.getName();
            if (throwableClassName.equals("junit.framework.ComparisonFailure") || throwableClassName.equals("org.junit.ComparisonFailure")) {
                return true;
            }
            return TCExecutionListener.isComparisonFailure(aClass.getSuperclass());
        }

        private static String limit(String string) {
            if (string == null) {
                return null;
            }
            if (string.length() > MAX_STACKTRACE_MESSAGE_LENGTH) {
                return string.substring(0, MAX_STACKTRACE_MESSAGE_LENGTH);
            }
            return string;
        }

        protected String getTrace(Throwable ex) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            ex.printStackTrace(writer);
            StringBuffer buffer = stringWriter.getBuffer();
            if (buffer.length() > MAX_STACKTRACE_MESSAGE_LENGTH) {
                return buffer.substring(0, MAX_STACKTRACE_MESSAGE_LENGTH);
            }
            return buffer.toString();
        }

        private static String getId(TestIdentifier identifier) {
            return identifier.getUniqueId();
        }

        private String idAndName(TestIdentifier testIdentifier) {
            String id = TCExecutionListener.getId(testIdentifier);
            String name = TCExecutionListener.getName(testIdentifier);
            String parentId = this.getParentId(testIdentifier);
            return " id='" + TCExecutionListener.escapeName(id) + "' name='" + TCExecutionListener.escapeName(name) + "' nodeId='" + TCExecutionListener.escapeName(id) + "' parentNodeId='" + TCExecutionListener.escapeName(parentId) + "'";
        }

        private String getParentId(TestIdentifier testIdentifier) {
            Optional parent = this.myTestPlan.getParent(testIdentifier);
            return parent.map(identifier -> identifier.getUniqueId()).orElse("0");
        }

        private static String escapeName(String str) {
            return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider2)MapSerializerUtil.STD_ESCAPER2);
        }
    }
}

