/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.AbstractIntellijClassfileTransformer;
import com.intellij.rt.coverage.instrumentation.InstrumentationStrategy;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.dataAccess.CondyCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.FieldCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.NameCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

public class CoverageTransformer
extends AbstractIntellijClassfileTransformer {
    private final ProjectData data;
    private final boolean shouldSaveSource;
    private final ClassFinder cf;
    private final TestTrackingMode testTrackingMode;
    protected final boolean calculateHits;

    /*
     * WARNING - void declaration
     */
    public CoverageTransformer(ProjectData data, boolean shouldSaveSource) {
        this((ProjectData)var1_1, (boolean)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CoverageTransformer(ProjectData data, boolean shouldSaveSource, ClassFinder cf, TestTrackingMode testTrackingMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.data = var1_1;
        this.shouldSaveSource = var2_2;
        this.cf = var3_3;
        this.testTrackingMode = testTrackingMode;
        this.calculateHits = OptionsUtil.CALCULATE_HITS_COUNT;
    }

    /*
     * WARNING - void declaration
     */
    protected ClassVisitor createClassVisitor(String className, ClassLoader loader, ClassReader cr, ClassVisitor cw) {
        void var3_3;
        void var1_1;
        return InstrumentationStrategy.createInstrumenter(this.data, className, cr, cw, this.testTrackingMode, this.data.isBranchCoverage(), this.shouldSaveSource, this.calculateHits, this.createDataAccess((String)var1_1, (ClassReader)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private CoverageDataAccess createDataAccess(String className, ClassReader cr) {
        void var2_2;
        void var1_1;
        if (OptionsUtil.FIELD_INSTRUMENTATION_ENABLED) {
            if (InstrumentationUtils.isCondyEnabled(cr)) {
                return new CondyCoverageDataAccess(this.createCondyInit(className, cr));
            }
            return new FieldCoverageDataAccess(cr, className, this.createInit(className, cr, false));
        }
        return new NameCoverageDataAccess(this.createInit((String)var1_1, (ClassReader)var2_2, true));
    }

    /*
     * WARNING - void declaration
     */
    protected CoverageDataAccess.Init createInit(String className, ClassReader cr, boolean needCache) {
        void var1_1;
        void var2_2;
        void var3_4;
        String arrayType;
        String string = arrayType = this.calculateHits ? "[I" : "[Z";
        String methodName = this.calculateHits ? (needCache ? "getHitsCached" : "getHits") : (needCache ? "getHitsMaskCached" : "getHitsMask");
        return new CoverageDataAccess.Init("__$hits$__", arrayType, "com/intellij/rt/coverage/instrumentation/CoverageRuntime", (String)var3_4, "(Ljava/lang/String;)" + (String)var2_2, new Object[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    protected CoverageDataAccess.Init createCondyInit(String className, ClassReader cr) {
        void var1_1;
        void var2_2;
        void var3_3;
        String arrayType = this.calculateHits ? "[I" : "[Z";
        String methodName = this.calculateHits ? "getHits" : "getHitsMask";
        return new CoverageDataAccess.Init("__$hits$__", arrayType, "com/intellij/rt/coverage/util/CondyUtils", (String)var3_3, "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)" + (String)var2_2, new Object[]{var1_1});
    }

    protected boolean shouldExclude(String className) {
        return ClassNameUtil.matchesPatterns(className, this.data.getExcludePatterns());
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractIntellijClassfileTransformer.InclusionPattern getInclusionPattern() {
        void var1_1;
        List<Pattern> includes = this.data.getIncudePatterns();
        if (includes == null || includes.isEmpty()) {
            return null;
        }
        return new AbstractIntellijClassfileTransformer.InclusionPattern(this, (List)var1_1){
            final /* synthetic */ List val$includes;
            final /* synthetic */ CoverageTransformer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$includes = list;
            }

            public boolean accept(String className) {
                return ClassNameUtil.matchesPatterns(className, this.val$includes);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected void visitClassLoader(ClassLoader classLoader) {
        if (this.cf != null) {
            void var1_1;
            this.cf.addClassLoader((ClassLoader)var1_1);
        }
    }

    protected boolean isStopped() {
        return this.data.isStopped();
    }
}

