/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;

public final class QuickSort {
    private static final Comparator<? extends Comparable> OBJCOMP = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable object1, Comparable object2) {
            return object1.compareTo(object2);
        }
    };

    private QuickSort() {
    }

    public static <T> void sort(List<T> list2, Comparator<T> cmp) {
        int size = list2.size();
        if (size < 2) {
            return;
        }
        QuickSort.quicksort(list2, cmp);
    }

    public static <T extends Comparable> void sort(List<T> list2) {
        QuickSort.sort(list2, OBJCOMP);
    }

    private static <T> void quicksort(List<T> list2, Comparator<T> cmp) {
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        stack.push(0);
        stack.push(list2.size());
        while (!stack.isEmpty()) {
            int left;
            int right = (Integer)stack.pop();
            if (right - (left = ((Integer)stack.pop()).intValue()) < 2) continue;
            int p = left + (right - left) / 2;
            p = QuickSort.partition(list2, cmp, p, left, right);
            stack.push(p + 1);
            stack.push(right);
            stack.push(left);
            stack.push(p);
        }
    }

    private static <T> int partition(List<T> list2, Comparator<T> cmp, int p, int start, int end) {
        int l = start;
        int h = end - 2;
        T piv = list2.get(p);
        QuickSort.swap(list2, p, end - 1);
        while (l < h) {
            if (cmp.compare(list2.get(l), piv) <= 0) {
                ++l;
                continue;
            }
            if (cmp.compare(piv, list2.get(h)) <= 0) {
                --h;
                continue;
            }
            QuickSort.swap(list2, l, h);
        }
        int idx = h;
        if (cmp.compare(list2.get(h), piv) < 0) {
            ++idx;
        }
        QuickSort.swap(list2, end - 1, idx);
        return idx;
    }

    private static <T> void swap(List<T> list2, int i, int j) {
        T tmp = list2.get(i);
        list2.set(i, list2.get(j));
        list2.set(j, tmp);
    }
}

