/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.builder;

import com.vladsch.flexmark.util.misc.DelimitedBuilder;

public class SegmentStats {
    public static final int NULL_REPEATED_CHAR = -1;
    public static final int NOT_REPEATED_CHAR = -2;
    protected int textLength = 0;
    protected int textSegments = 0;
    protected int textSegmentLength = 0;
    protected int textSpaceLength = 0;
    protected int textSpaceSegments = 0;
    protected int textSpaceSegmentLength = 0;
    protected int textFirst256Length = 0;
    protected int textFirst256Segments = 0;
    protected int textFirst256SegmentLength = 0;
    protected int repeatedChar = -1;
    protected final boolean trackFirst256;

    public SegmentStats(boolean trackFirst256) {
        this.trackFirst256 = trackFirst256;
    }

    public int getTextLength() {
        return this.textLength;
    }

    public int getTextSpaceLength() {
        return this.textSpaceLength;
    }

    public int getTextFirst256Length() {
        return this.textFirst256Length;
    }

    public boolean isTrackTextFirst256() {
        return this.trackFirst256;
    }

    public int getTextSegments() {
        return this.textSegments;
    }

    public int getTextSpaceSegments() {
        return this.textSpaceSegments;
    }

    public int getTextFirst256Segments() {
        return this.textFirst256Segments;
    }

    public boolean isEmpty() {
        return this.textLength == 0 && this.textSegments == 0 && this.textSegmentLength == 0 && (!this.trackFirst256 || this.textSpaceLength == 0 && this.textSpaceSegments == 0 && this.textSpaceSegmentLength == 0 && this.textFirst256Length == 0 && this.textFirst256Segments == 0 && this.textFirst256SegmentLength == 0);
    }

    public boolean isValid() {
        return this.textLength >= this.textSegments && (!this.trackFirst256 || this.textLength >= this.textFirst256Length && this.textSegments >= this.textFirst256Segments && this.textFirst256Length >= this.textFirst256Segments && this.textFirst256Length >= this.textSpaceLength && this.textFirst256Segments >= this.textSpaceSegments && this.textSpaceLength >= this.textSpaceSegments);
    }

    public SegmentStats committedCopy() {
        SegmentStats other = new SegmentStats(this.trackFirst256);
        other.textLength = this.textLength;
        other.textSegments = this.textSegments;
        other.textSegmentLength = this.textSegmentLength;
        if (this.trackFirst256) {
            other.textSpaceLength = this.textSpaceLength;
            other.textSpaceSegments = this.textSpaceSegments;
            other.textSpaceSegmentLength = this.textSpaceSegmentLength;
            other.textFirst256Length = this.textFirst256Length;
            other.textFirst256Segments = this.textFirst256Segments;
            other.textFirst256SegmentLength = this.textFirst256SegmentLength;
        }
        other.commitText();
        return other;
    }

    public void clear() {
        this.textLength = 0;
        this.textSegments = 0;
        this.textSegmentLength = 0;
        this.repeatedChar = -1;
        if (this.trackFirst256) {
            this.textSpaceLength = 0;
            this.textSpaceSegments = 0;
            this.textSpaceSegmentLength = 0;
            this.textFirst256Length = 0;
            this.textFirst256Segments = 0;
            this.textFirst256SegmentLength = 0;
        }
    }

    public void add(SegmentStats other) {
        this.textLength += other.textLength;
        this.textSegments += other.textSegments;
        if (this.trackFirst256 && other.trackFirst256) {
            this.textSpaceLength += other.textSpaceLength;
            this.textSpaceSegments += other.textSpaceSegments;
            this.textFirst256Length += other.textFirst256Length;
            this.textFirst256Segments += other.textFirst256Segments;
        }
    }

    public void remove(SegmentStats other) {
        assert (this.textLength >= other.textLength);
        assert (this.textSegments >= other.textSegments);
        this.textLength -= other.textLength;
        this.textSegments -= other.textSegments;
        this.textSegmentLength = this.textLength;
        if (this.trackFirst256 && other.trackFirst256) {
            assert (this.textSpaceLength >= other.textSpaceLength);
            assert (this.textSpaceSegments >= other.textSpaceSegments);
            assert (this.textFirst256Length >= other.textFirst256Length);
            assert (this.textFirst256Segments >= other.textFirst256Segments);
            this.textSpaceLength -= other.textSpaceLength;
            this.textSpaceSegments -= other.textSpaceSegments;
            this.textFirst256Length -= other.textFirst256Length;
            this.textFirst256Segments -= other.textFirst256Segments;
            this.textSpaceSegmentLength = this.textSpaceLength;
            this.textFirst256SegmentLength = this.textFirst256Length;
        }
    }

    public boolean isTextFirst256() {
        int segmentLength = this.textLength - this.textSegmentLength;
        return this.textFirst256Length - this.textFirst256SegmentLength == segmentLength;
    }

    public boolean isTextRepeatedSpace() {
        int segmentLength = this.textLength - this.textSegmentLength;
        return this.textSpaceLength - this.textSpaceSegmentLength == segmentLength;
    }

    public boolean isRepeatedText() {
        return this.repeatedChar >= 0;
    }

    public void commitText() {
        if (this.textLength > this.textSegmentLength) {
            ++this.textSegments;
            this.repeatedChar = -1;
            if (this.trackFirst256) {
                int segmentLength = this.textLength - this.textSegmentLength;
                if (this.textSpaceLength - this.textSpaceSegmentLength == segmentLength) {
                    ++this.textSpaceSegments;
                }
                if (this.textFirst256Length - this.textFirst256SegmentLength == segmentLength) {
                    ++this.textFirst256Segments;
                }
            }
            this.textSegmentLength = this.textLength;
            if (this.trackFirst256) {
                this.textSpaceSegmentLength = this.textSpaceLength;
                this.textFirst256SegmentLength = this.textFirst256Length;
            }
        }
    }

    public void addText(CharSequence text2) {
        this.textLength += text2.length();
        if (this.trackFirst256) {
            int iMax = text2.length();
            for (int i = 0; i < iMax; ++i) {
                char c = text2.charAt(i);
                if (this.repeatedChar == -1) {
                    this.repeatedChar = c;
                } else if (this.repeatedChar != c) {
                    this.repeatedChar = -2;
                }
                if (c >= '\u0100') continue;
                if (c == ' ') {
                    ++this.textSpaceLength;
                }
                ++this.textFirst256Length;
            }
        }
    }

    public void addText(char c) {
        ++this.textLength;
        if (this.trackFirst256) {
            if (this.repeatedChar == -1) {
                this.repeatedChar = c;
            } else if (this.repeatedChar != c) {
                this.repeatedChar = -2;
            }
            if (c < '\u0100') {
                if (c == ' ') {
                    ++this.textSpaceLength;
                }
                ++this.textFirst256Length;
            }
        }
    }

    public void addText(char c, int repeat) {
        assert (repeat > 0);
        this.textLength += repeat;
        if (this.trackFirst256) {
            if (this.repeatedChar == -1) {
                this.repeatedChar = c;
            } else if (this.repeatedChar != c) {
                this.repeatedChar = -2;
            }
            if (c < '\u0100') {
                if (c == ' ') {
                    this.textSpaceLength += repeat;
                }
                this.textFirst256Length += repeat;
            }
        }
    }

    public void removeText(CharSequence text2) {
        this.textLength -= text2.length();
        if (this.trackFirst256) {
            int iMax = text2.length();
            for (int i = 0; i < iMax; ++i) {
                char c = text2.charAt(i);
                if (this.repeatedChar == -1) {
                    this.repeatedChar = c;
                } else if (this.repeatedChar != c) {
                    this.repeatedChar = -2;
                }
                if (c >= '\u0100') continue;
                if (c == ' ') {
                    assert (this.textSpaceLength > 0);
                    --this.textSpaceLength;
                }
                assert (this.textFirst256Length > 0);
                --this.textFirst256Length;
            }
        }
        if (this.textLength == this.textSegmentLength) {
            this.repeatedChar = -1;
        }
    }

    public String toString() {
        DelimitedBuilder sb = new DelimitedBuilder(", ");
        sb.append("s=").append(this.textSpaceSegments).append(":").append(this.textSpaceLength).mark().append("u=").append(this.textFirst256Segments).append(":").append(this.textFirst256Length).mark().append("t=").append(this.textSegments).append(":").append(this.textLength);
        return sb.toString();
    }
}

