/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.SettingsDialogListener;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEventListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncPromotion;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.statistics.SettingsSyncEventsStatistics;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/settingsSync/SettingsSyncPromotion;", "Lcom/intellij/openapi/options/newEditor/SettingsDialogListener;", "()V", "afterApply", "", "settingsEditor", "Lcom/intellij/openapi/options/newEditor/AbstractEditor;", "getConfigurable", "Lcom/intellij/openapi/options/Configurable;", "path", "Ljavax/swing/tree/TreePath;", "intellij.settingsSync"})
public final class SettingsSyncPromotion
implements SettingsDialogListener {
    public void afterApply(@NotNull AbstractEditor settingsEditor) {
        Object v3;
        SimpleTree settingsTree;
        GotItTooltip gotItTooltip;
        block4: {
            Intrinsics.checkNotNullParameter((Object)settingsEditor, (String)"settingsEditor");
            if (!(settingsEditor instanceof SettingsEditor) || SettingsSyncSettings.Companion.getInstance().getSyncEnabled() || SettingsSyncAuthService.Companion.getInstance().isLoggedIn() || !Registry.is((String)"settingsSync.promotion.in.settings", (boolean)false)) {
                return;
            }
            gotItTooltip = new GotItTooltip("settings.sync.in.settings", SettingsSyncBundle.INSTANCE.message("promotion.in.settings.text", new Object[0]), (Disposable)settingsEditor);
            if (!gotItTooltip.canShow()) {
                Disposer.dispose((Disposable)((Disposable)gotItTooltip));
                return;
            }
            Disposer.register((Disposable)((Disposable)gotItTooltip), () -> SettingsSyncPromotion.afterApply$lambda$0(gotItTooltip));
            SimpleTree simpleTree = ((SettingsEditor)settingsEditor).getTreeView().getTree();
            Intrinsics.checkNotNullExpressionValue((Object)simpleTree, (String)"getTree(...)");
            settingsTree = simpleTree;
            JBTreeTraverser jBTreeTraverser = TreeUtil.treePathTraverser((JTree)((JTree)settingsTree));
            Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"treePathTraverser(...)");
            Iterable iterable = (Iterable)jBTreeTraverser;
            for (Object t : iterable) {
                Configurable configurable;
                TreePath path = (TreePath)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)path);
                Configurable configurable2 = configurable = this.getConfigurable(path);
                if (!Intrinsics.areEqual((Object)(configurable2 != null ? configurable2.getDisplayName() : null), (Object)SettingsSyncBundle.INSTANCE.message("title.settings.sync", new Object[0]))) continue;
                v3 = t;
                break block4;
            }
            v3 = null;
        }
        TreePath treePath = v3;
        if (treePath == null) {
            return;
        }
        TreePath settingsSyncPath = treePath;
        Configurable configurable = this.getConfigurable(settingsSyncPath);
        Intrinsics.checkNotNull((Object)configurable);
        Configurable settingsSyncConfigurable = configurable;
        settingsTree.scrollPathToVisible(settingsSyncPath);
        gotItTooltip.withHeader(SettingsSyncBundle.INSTANCE.message("promotion.in.settings.header", new Object[0])).withButtonLabel(SettingsSyncBundle.INSTANCE.message("promotion.in.settings.open", new Object[0])).withSecondaryButton(SettingsSyncBundle.INSTANCE.message("promotion.in.settings.skip", new Object[0]), (Function0)afterApply.2.INSTANCE).withGotItButtonAction((Function0)new Function0<Unit>(settingsEditor, settingsSyncConfigurable){
            final /* synthetic */ AbstractEditor $settingsEditor;
            final /* synthetic */ Configurable $settingsSyncConfigurable;
            {
                this.$settingsEditor = $settingsEditor;
                this.$settingsSyncConfigurable = $settingsSyncConfigurable;
                super(0);
            }

            public final void invoke() {
                ActionsKt.invokeLater((ModalityState)ModalityState.stateForComponent((Component)((Component)this.$settingsEditor)), (Function0)((Function0)new Function0<Unit>(this.$settingsEditor, this.$settingsSyncConfigurable){
                    final /* synthetic */ AbstractEditor $settingsEditor;
                    final /* synthetic */ Configurable $settingsSyncConfigurable;
                    {
                        this.$settingsEditor = $settingsEditor;
                        this.$settingsSyncConfigurable = $settingsSyncConfigurable;
                        super(0);
                    }

                    public final void invoke() {
                        ((SettingsEditor)this.$settingsEditor).select(this.$settingsSyncConfigurable);
                    }
                }));
                SettingsSyncEventsStatistics.INSTANCE.getPROMOTION_IN_SETTINGS().log((Object)((Object)SettingsSyncEventsStatistics.PromotionInSettingsEvent.GO_TO_SETTINGS_SYNC));
            }
        }).withPosition(Balloon.Position.atRight).show((JComponent)settingsTree, (Function2)new Function2<Component, Balloon, Point>(settingsTree, settingsSyncPath){
            final /* synthetic */ SimpleTree $settingsTree;
            final /* synthetic */ TreePath $settingsSyncPath;
            {
                this.$settingsTree = $settingsTree;
                this.$settingsSyncPath = $settingsSyncPath;
                super(2);
            }

            @NotNull
            public final Point invoke(@NotNull Component component, @NotNull Balloon balloon) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)balloon, (String)"<anonymous parameter 1>");
                Rectangle rectangle = this.$settingsTree.getPathBounds(this.$settingsSyncPath);
                if (rectangle == null) {
                    throw new IllegalStateException(("Failed to get bounds for path: " + this.$settingsSyncPath).toString());
                }
                Rectangle pathBounds = rectangle;
                int x = pathBounds.x + Math.min(pathBounds.width, JBUI.scale((int)150));
                return new Point(x, pathBounds.y + pathBounds.height / 2);
            }
        });
        SettingsSyncEventsStatistics.INSTANCE.getPROMOTION_IN_SETTINGS().log((Object)SettingsSyncEventsStatistics.PromotionInSettingsEvent.SHOWN);
        SettingsSyncEvents.Companion.getInstance().addListener(new SettingsSyncEventListener(){

            public void loginStateChanged() {
                if (SettingsSyncAuthService.Companion.getInstance().isLoggedIn()) {
                    SettingsSyncEventsStatistics.INSTANCE.getPROMOTION_IN_SETTINGS().log((Object)((Object)SettingsSyncEventsStatistics.PromotionInSettingsEvent.LOGGED_IN));
                }
            }

            public void enabledStateChanged(boolean syncEnabled) {
                if (syncEnabled) {
                    SettingsSyncEventsStatistics.INSTANCE.getPROMOTION_IN_SETTINGS().log((Object)((Object)SettingsSyncEventsStatistics.PromotionInSettingsEvent.ENABLED));
                    SettingsSyncEvents.Companion.getInstance().removeListener(this);
                }
            }
        }, (Disposable)settingsEditor);
    }

    private final Configurable getConfigurable(TreePath path) {
        Object object = path.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode lastNode = defaultMutableTreeNode;
        Object object2 = lastNode.getUserObject();
        FilteringTreeStructure.FilteringNode filteringNode = object2 instanceof FilteringTreeStructure.FilteringNode ? (FilteringTreeStructure.FilteringNode)object2 : null;
        if (filteringNode == null) {
            return null;
        }
        FilteringTreeStructure.FilteringNode filteringNode2 = filteringNode;
        Object object3 = filteringNode2.getDelegate();
        SimpleNode simpleNode = object3 instanceof SimpleNode ? (SimpleNode)object3 : null;
        if (simpleNode == null) {
            return null;
        }
        SimpleNode delegate = simpleNode;
        return SettingsTreeView.getConfigurable((SimpleNode)delegate);
    }

    private static final void afterApply$lambda$0(GotItTooltip $gotItTooltip) {
        Intrinsics.checkNotNullParameter((Object)$gotItTooltip, (String)"$gotItTooltip");
        $gotItTooltip.gotIt();
    }
}

