/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.checkin.KeepLocksComponent;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public final class SvnCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance(SvnCheckinEnvironment.class);
    @NotNull
    private final SvnVcs mySvnVcs;

    public SvnCheckinEnvironment(@NotNull SvnVcs svnVcs) {
        if (svnVcs == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(0);
        }
        this.mySvnVcs = svnVcs;
    }

    @NotNull
    public RefreshableOnComponent createCommitOptions(@NotNull CheckinProjectPanel commitPanel, @NotNull CommitContext commitContext) {
        if (commitPanel == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(1);
        }
        if (commitContext == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(2);
        }
        return new KeepLocksComponent(this.mySvnVcs);
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    private void doCommit(@NotNull Collection<? extends FilePath> committables, String comment, List<VcsException> exception, @NotNull Set<? super String> feedback) {
        if (committables == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(3);
        }
        if (feedback == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(4);
        }
        MultiMap<Pair<Url, WorkingCopyFormat>, ? extends FilePath> map = SvnUtil.splitIntoRepositoriesMap(this.mySvnVcs, committables, Convertor.self());
        for (Map.Entry entry : map.entrySet()) {
            try {
                this.doCommitOneRepo((Collection)entry.getValue(), comment, exception, feedback, (WorkingCopyFormat)((Object)((Pair)entry.getKey()).getSecond()));
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                exception.add(e);
            }
        }
    }

    private void doCommitOneRepo(@NotNull Collection<? extends FilePath> committables, String comment, List<VcsException> exception, @NotNull Set<? super String> feedback, @NotNull WorkingCopyFormat format) throws VcsException {
        if (committables == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(5);
        }
        if (feedback == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(6);
        }
        if (format == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(7);
        }
        if (committables.isEmpty()) {
            return;
        }
        CommitInfo[] results = this.mySvnVcs.getFactory(format).createCheckinClient().commit(ChangesUtil.filePathsToFiles(committables), comment);
        StringBuilder committedRevisions = new StringBuilder();
        for (CommitInfo result : results) {
            if (result == CommitInfo.EMPTY || result.getRevisionNumber() <= 0L) continue;
            if (committedRevisions.length() > 0) {
                committedRevisions.append(", ");
            }
            committedRevisions.append(result.getRevisionNumber());
        }
        if (committedRevisions.length() > 0) {
            feedback.add("Subversion: " + SvnBundle.message("status.text.committed.revision", committedRevisions));
        }
    }

    @NotNull
    private Collection<FilePath> getCommitables(@NotNull List<? extends Change> changes) {
        if (changes == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(8);
        }
        Set result = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
        ChangesUtil.getPaths(changes).forEach(path -> {
            if (result.add(path)) {
                this.addParents(result, (FilePath)path);
            }
        });
        Set set = result;
        if (set == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(9);
        }
        return set;
    }

    private void addParents(@NotNull Collection<FilePath> paths, @NotNull FilePath path) {
        if (paths == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(10);
        }
        if (path == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(11);
        }
        FilePath parent = path;
        while ((parent = parent.getParentPath()) != null && this.isAddedOrReplaced(parent)) {
            paths.add(parent);
        }
    }

    private boolean isAddedOrReplaced(@NotNull FilePath file) {
        Status status;
        if (file == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(12);
        }
        return (status = this.getStatus(file)) != null && status.is(StatusType.STATUS_ADDED, StatusType.STATUS_REPLACED);
    }

    @Nullable
    private Status getStatus(@NotNull FilePath file) {
        if (file == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(13);
        }
        Status result = null;
        try {
            result = this.mySvnVcs.getFactory(file.getIOFile()).createStatusClient().doStatus(file.getIOFile(), false);
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return result;
    }

    public String getCheckinOperationName() {
        return SvnBundle.message("checkin.operation.name", new Object[0]);
    }

    @NotNull
    public List<VcsException> commit(@NotNull List<? extends Change> changes, @NotNull String commitMessage, @NotNull CommitContext commitContext, @NotNull Set<? super String> feedback) {
        if (changes == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(14);
        }
        if (commitMessage == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(15);
        }
        if (commitContext == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(16);
        }
        if (feedback == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(17);
        }
        ArrayList<VcsException> exception = new ArrayList<VcsException>();
        Collection<FilePath> committables = this.getCommitables(changes);
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            this.doCommit(committables, commitMessage, exception, feedback);
        } else if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.doCommit(committables, commitMessage, exception, feedback), SvnBundle.message("progress.title.commit", new Object[0]), false, this.mySvnVcs.getProject());
        } else {
            this.doCommit(committables, commitMessage, exception, feedback);
        }
        ArrayList<VcsException> arrayList = exception;
        if (arrayList == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public List<VcsException> scheduleMissingFileForDeletion(@NotNull List<? extends FilePath> filePaths) {
        if (filePaths == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(19);
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        List files = ChangesUtil.filePathsToFiles(filePaths);
        for (File file : files) {
            try {
                this.mySvnVcs.getFactory(file).createDeleteClient().delete(file, true, false, null);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(@NotNull List<? extends VirtualFile> files) {
        if (files == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(20);
        }
        return SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(this.mySvnVcs, files);
    }

    public static List<VcsException> scheduleUnversionedFilesForAddition(@NotNull SvnVcs vcs, List<? extends VirtualFile> files) {
        if (vcs == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(21);
        }
        return SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(vcs, files, false);
    }

    public static List<VcsException> scheduleUnversionedFilesForAddition(@NotNull SvnVcs vcs, List<? extends VirtualFile> files, boolean recursive) {
        if (vcs == null) {
            SvnCheckinEnvironment.$$$reportNull$$$0(22);
        }
        files.sort((Comparator<? extends VirtualFile>)FilePathComparator.getInstance());
        SvnProgressCanceller eventHandler = new SvnProgressCanceller(){

            @Override
            public void consume(ProgressEvent event) {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                File file = event.getFile();
                if (indicator != null && file != null) {
                    indicator.setText(SvnBundle.message("progress.text2.adding", file.getName() + " (" + file.getParent() + ")"));
                }
            }
        };
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Depth depth = Depth.allOrEmpty(recursive);
        for (VirtualFile virtualFile : files) {
            try {
                File convertedFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                vcs.getFactory(convertedFile).createAddClient().add(convertedFile, depth, true, false, true, eventHandler);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnVcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitPanel";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committables";
                break;
            }
            case 4: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feedback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/checkin/SvnCheckinEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitables";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "commit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCommitOptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCommitOneRepo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommitables";
                break;
            }
            case 9: 
            case 18: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addParents";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAddedOrReplaced";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "scheduleMissingFileForDeletion";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUnversionedFilesForAddition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 18 -> new IllegalStateException(string);
        };
    }
}

