/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.protocol;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.ide.model.loggers.JvmThrowableLogEntry;
import com.jetbrains.ide.model.loggers.LogEntry;
import com.jetbrains.ide.model.loggers.LogEntryBase;
import com.jetbrains.ide.model.loggers.LoggerModel;
import com.jetbrains.ide.model.loggers.LoggerModel_GeneratedKt;
import com.jetbrains.ide.model.loggers.RdThrowable;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.platform.diagnostics.BackendException;
import com.jetbrains.rd.platform.diagnostics.ThrowableConversionsKt;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.protocol.FrontendProtocolInitializer;
import com.jetbrains.rdclient.protocol.LoggerModelManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdclient/protocol/LoggerModelManager;", "", "()V", "allModelComponents", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jetbrains/ide/model/loggers/LoggerModel;", "Lcom/jetbrains/rd/util/CopyOnWriteArrayList;", "getAllModelComponents", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "NewProtocolListener", "RootListener", "intellij.rd.client"})
public final class LoggerModelManager {
    @NotNull
    public static final LoggerModelManager INSTANCE = new LoggerModelManager();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final CopyOnWriteArrayList<LoggerModel> allModelComponents;

    private LoggerModelManager() {
    }

    @NotNull
    public final CopyOnWriteArrayList<LoggerModel> getAllModelComponents() {
        return allModelComponents;
    }

    static {
        Logger logger = Logger.getInstance((String)"Projected Logger");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LoggerModelManager.logger = logger;
        allModelComponents = new CopyOnWriteArrayList();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/protocol/LoggerModelManager$NewProtocolListener;", "Lcom/jetbrains/rdclient/protocol/FrontendProtocolInitializer;", "()V", "initialize", "", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "intellij.rd.client"})
    public static final class NewProtocolListener
    implements FrontendProtocolInitializer {
        @Override
        public void initialize(@NotNull IProtocol protocol) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            CollectionExKt.addUnique((Collection)INSTANCE.getAllModelComponents(), (Lifetime)protocol.getLifetime(), (Object)LoggerModel_GeneratedKt.getLoggerModel((IProtocol)protocol));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\"\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J1\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/protocol/LoggerModelManager$RootListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/ide/model/loggers/LoggerModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "fromLogEntry", "Lkotlin/Pair;", "Lcom/jetbrains/rd/platform/diagnostics/BackendException;", "", "Lcom/intellij/openapi/diagnostic/Attachment;", "logEntry", "Lcom/jetbrains/ide/model/loggers/LogEntry;", "logException", "logMessage", "", "backendException", "", "attachments", "(Ljava/lang/String;Ljava/lang/Throwable;[Lcom/intellij/openapi/diagnostic/Attachment;)V", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nLoggerModelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggerModelManager.kt\ncom/jetbrains/rdclient/protocol/LoggerModelManager$RootListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,76:1\n1#2:77\n37#3,2:78\n*S KotlinDebug\n*F\n+ 1 LoggerModelManager.kt\ncom/jetbrains/rdclient/protocol/LoggerModelManager$RootListener\n*L\n57#1:78,2\n*E\n"})
    public static final class RootListener
    implements RootExtListener<LoggerModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull LoggerModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            model.getMessage().advise(lifetime, (Function1)new Function1<LogEntryBase, Unit>(this){
                final /* synthetic */ RootListener this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull LogEntryBase message2) {
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    switch (extensionCreated.WhenMappings.$EnumSwitchMapping$0[message2.getSeverity().ordinal()]) {
                        case 1: {
                            Pair pair;
                            LogEntryBase logEntryBase = message2;
                            if (logEntryBase instanceof LogEntry) {
                                pair = RootListener.access$fromLogEntry(this.this$0, (LogEntry)message2);
                            } else if (logEntryBase instanceof JvmThrowableLogEntry) {
                                boolean $i$f$emptyArray = false;
                                pair = new Pair((Object)ThrowableConversionsKt.toThrowable((RdThrowable)((JvmThrowableLogEntry)message2).getThrowable(), (String)"backend"), (Object)new Attachment[0]);
                            } else {
                                LoggerModelManager.access$getLogger$p().error("Empty throwable from backend");
                                return;
                            }
                            Pair pair2 = pair;
                            Throwable throwable = (Throwable)pair2.component1();
                            Attachment[] attachments = (Attachment[])pair2.component2();
                            RootListener.access$logException(this.this$0, message2.getLogMessage(), throwable, Arrays.copyOf(attachments, attachments.length));
                            break;
                        }
                        case 2: {
                            LoggerModelManager.access$getLogger$p().warn(message2.getLogMessage());
                            break;
                        }
                        case 3: {
                            LoggerModelManager.access$getLogger$p().info(message2.getLogMessage());
                            break;
                        }
                        case 4: {
                            LoggerModelManager.access$getLogger$p().debug(message2.getLogMessage());
                            break;
                        }
                        case 5: {
                            LoggerModelManager.access$getLogger$p().trace(message2.getLogMessage());
                        }
                    }
                }
            });
        }

        private final Pair<BackendException, Attachment[]> fromLogEntry(LogEntry logEntry) {
            List list;
            if (!Intrinsics.areEqual((Object)logEntry.getLogMessage(), (Object)logEntry.getLogMessageWithSensitiveData())) {
                Attachment attachment;
                Attachment it = attachment = new Attachment("full-stacktrace.txt", logEntry.getLogMessageWithSensitiveData());
                boolean bl = false;
                it.setIncluded(true);
                list = CollectionsKt.listOf((Object)attachment);
            } else {
                list = CollectionsKt.emptyList();
            }
            List attachments = list;
            Collection $this$toTypedArray$iv = attachments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new Pair((Object)new BackendException(logEntry.getLogMessage()), (Object)thisCollection$iv.toArray(new Attachment[0]));
        }

        private final void logException(String logMessage, Throwable backendException, Attachment ... attachments) {
            if (attachments.length == 0) {
                logger.error(logMessage, backendException);
            } else {
                logger.error(backendException.getMessage(), backendException, Arrays.copyOf(attachments, attachments.length));
            }
        }

        public static final /* synthetic */ Pair access$fromLogEntry(RootListener $this, LogEntry logEntry) {
            return $this.fromLogEntry(logEntry);
        }

        public static final /* synthetic */ void access$logException(RootListener $this, String logMessage, Throwable backendException, Attachment ... attachments) {
            $this.logException(logMessage, backendException, attachments);
        }
    }
}

