/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.config.ApplyJschBasedOpenSshConfig;
import com.intellij.ssh.config.OpenSshConfigViaToolService;
import com.intellij.ssh.config.ProductionSshConnectionConfigDelegate;
import com.intellij.ssh.config.SshConfigParseException;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshConnectionConfigService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/ssh/config/ProductionSshConnectionConfigDelegate;", "Lcom/intellij/ssh/config/SshConnectionConfigService$Delegate;", "()V", "get", "Lcom/intellij/ssh/config/SshConnectionConfig;", "host", "", "useOpenSshConfig", "", "getJsch", "getOpenSsh", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshConnectionConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionConfigService.kt\ncom/intellij/ssh/config/ProductionSshConnectionConfigDelegate\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,317:1\n11#2:318\n*S KotlinDebug\n*F\n+ 1 SshConnectionConfigService.kt\ncom/intellij/ssh/config/ProductionSshConnectionConfigDelegate\n*L\n284#1:318\n*E\n"})
public final class ProductionSshConnectionConfigDelegate
implements SshConnectionConfigService.Delegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    @NotNull
    public SshConnectionConfig get(@NotNull String host2, boolean useOpenSshConfig) throws SshConfigParseException {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        return switch (WhenMappings.$EnumSwitchMapping$0[SshConnectionConfigService.Companion.getInstance().getKind().ordinal()]) {
            case 1 -> this.getJsch(host2, useOpenSshConfig);
            case 2 -> this.getOpenSsh(host2, useOpenSshConfig);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final SshConnectionConfig getJsch(String host2, boolean useOpenSshConfig) {
        List list2;
        SshConnectionConfig connectionConfig = new SshConnectionConfig(host2);
        if (useOpenSshConfig) {
            Path[] pathArray = new Path[]{SystemInfo.isUnix ? Paths.get("/etc/ssh/ssh_config", new String[0]) : null, Ssh.getHomeSshDirectory().resolve("config")};
            list2 = CollectionsKt.listOfNotNull((Object[])pathArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List configFiles = list2;
        for (Path configFile : configFiles) {
            String string;
            try {
                string = PathsKt.readText$default((Path)configFile, null, (int)1, null);
            }
            catch (IOException err) {
                if (err instanceof FileNotFoundException || err instanceof NoSuchFileException) {
                    LOG.debug(configFile + " was not found.");
                    continue;
                }
                LOG.warn("Failed to read " + configFile, (Throwable)err);
                continue;
            }
            String openSshConfigString = string;
            SshConnectionConfig newConfig = ApplyJschBasedOpenSshConfig.applyJschBasedOpenSshConfig(connectionConfig, openSshConfigString);
            if (LOG.isDebugEnabled()) {
                String diff2 = CollectionsKt.joinToString$default((Iterable)SshConnectionConfigKt.sshConnectionConfigDiff(connectionConfig, newConfig), (CharSequence)"\n", null, null, (int)0, null, (Function1)getJsch.diff.1.INSTANCE, (int)30, null);
                if (((CharSequence)diff2).length() > 0) {
                    LOG.debug("Found specific settings in " + configFile + " for host " + host2 + ":\n" + diff2);
                } else {
                    LOG.debug("Found no specific settings in " + configFile + " for host " + host2);
                }
            }
            connectionConfig = newConfig;
        }
        return ApplyJschBasedOpenSshConfig.addDefaultPrivateKeysIfNeeded(connectionConfig);
    }

    private final SshConnectionConfig getOpenSsh(String host2, boolean useOpenSshConfig) throws SshConfigParseException {
        if (useOpenSshConfig) {
            try {
                return OpenSshConfigViaToolService.Companion.getInstance().get(host2);
            }
            catch (ProcessNotCreatedException err) {
                LOG.warn("Failed to retrieve SSH configuration via OpenSSH. Falling back to the legacy parser. Error: " + err);
            }
        }
        return ApplyJschBasedOpenSshConfig.addDefaultPrivateKeysIfNeeded(new SshConnectionConfig(host2));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProductionSshConnectionConfigDelegate.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ssh/config/ProductionSshConnectionConfigDelegate$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SshConnectionConfigService.Kind.values().length];
            try {
                nArray[SshConnectionConfigService.Kind.LEGACY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigService.Kind.OPENSSH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

