;
; The Brake! FTN-compatible mailer for OS/2
; Version g718
; Copyright () 1995-97 by John Gladkih.
; All rights reserved.
;
; Configuration file.
;

#Import #All			; Import environment variables as macros

Define NodeList			; Nodelists and pointlists. This section
				; must be the first!

  Path .\NodeList		; Path to nodelist(s) (def. - .\nodelist)

  OutboundRoot .		; Outbound root directory (def. - .\)

  Indexes Brake!.Idx		; Nodelists index file
				; ! Keep indices in separate files for each
				; line if you have different sets of nodelists

  Exclude 1,3,4,5,6		; Zones you wish to exclude from indexing
				; ! Separate numbers by commas without spaces

  DefaultDomain FidoNet		; Default domain - assigned to nodes with
				; unknown domain and/or undefined zone number

  Domain FidoNet		; 'FidoNet' domain definition

    Outbound outbound		; Domain outbound (def. - domain name)

    InBound .\files\unsecure	; Inbound path (def. - matches path defined
				; in Misc section)

    Protected .\files		; Inbound path for password-protected
				; sessions (def. - see previous entry)
    Zones 1,2,3,4,5,6		; Zones included in domain
    MainZone 2                  ; Main domain zone (zone which does not
                                ; have zone number in extension of outbound
                                ; directory name) (def. - first zone from the list)
    Add nodelist Diff nodediff  ; Domain nodelist and its Diff file (optional)
    Replace default 2 iskrandl  ; Add - nodes from nodelist would be added
                                ; to indices
                                ; Replace - nodes from nodelist would replace
                                ; existing entries
                                ; Optional 'default' word sets defaults
                                ; on zone: net/node expression
                                ; format: default zone[:net[/node]]
    Add default 2:5051 net5051.pts ; Pointlist must have Boss/Point lines
  End

  Domain TormozNT               ; domain TormozNet(tm)
    Zones 17
    Add tnlist
  End

  Domain APBnet.moon
    outbound apbnet
    Zones 800,711
    Add k:\agromail\nodelist\banknet
  End

End

Define EMSI                         ; EMSI information block

  Address 2:5051/999                ; Full address
  Address 63:15/0@APBnet.moon       ; Full AKAs if present
  Address 333:3/3
  SysOp   "Black Monster"           ; Sysop name (^ works as \ in C language)
  System  #system#                  ; Station name (environment variable
                                    ; substitution used)
  Place   "Woodstock, CA, U.S.A."   ; Station location
  Phone   1-800-Private             ; Phone number
  Speed   1.5Mb                     ; Max. speed
  Flags   X.25,V.All,MO,LO,XW       ; Flags
                                    ; ATTENTION! Our flag is XW

End

#For 1                              ; Only for the first line (-l 1)
  #Display "Line I Block"
#EndFor

#For 2
  #Display "Line 2 Block"
  Define EMSI
    System "Line ]["
  End
#EndFor

Define Miscellaneous                ; Miscellaneous parameters

  TerminalTimeOut 6000         ; Exit terminal after 600 second of inactivity
                               ; (keys were not pressed and no DCD)
                               ; (def. - none)
  TerminalLog No	       ; Enable/Disable of log showing on screen in
			       ;  terminal mode (def. - No);
  ZMH      5:30-6:30           ; Zone Mail Hour in local time
; ZMH      Tcd                 ; ZMH in Greenwich
; AnswerTime 09:00-10:00       ; Answer time
; CallTime CM                  ; Call time
; CallOnlyImmed CM             ; Call time only for Immed
; CallOnlyCrash CM             ; Call time only for Crash
; CallOnlyDirect CM            ; Call time only for Direct
; CallOnlyNormal CM            ; Call time only for Normal
; ImmedPriority   16           ; Priority for 'Immed' queue items
; CrashPriority   8            ; Priority for 'Crash' queue items
; DirectPriority  4            ; Priority for 'Direct' queue items
; NormalPriority  2            ; Priority for 'Normal' queue items
; HoldPriority    1            ; Priority for 'Hold' queue items
                               ; 'Hold' MUST have the lowest priority
                               ; Default values was specified above
  Circle   60 30               ; Time interval between calls,
                               ; max and min (in seconds)
; Redial   5                   ; Time interval between calls for terminal (sec)
                               ; If not specified - no pause
  ConfigCheck 300              ; Period for config files check
                               ; in seconds (def. - 5 minutes)
  FlagsCheck 5                 ; Period for flags check in Flags directory
                               ; in seconds (def. - 5 seconds)
  ScheduleCheck 5              ; Period for event file check
                               ; (Brake!.Sch), in seconds (def. - 5 seconds)
  AddInQueue addin\dbridge.dll "2:5051/1 e:\db\queue"
                               ; Additional queue (many allowed)
                               ; first parameter - DLL name
                               ; second parameter would be passed to INIT function
  AutoReScan   600             ; Queue rescan period (sec)
  ReScanSleep  1000            ; 'Sleep' interval for rescan thread (def. 1000 ms)
  FastScan     No              ; 'Quick' outbound rescan:
                               ; - in fileboxes only first file would be checked
                               ; - in outbound only presence of ?ut  ?lo would be checked,
                               ; - ?lo contents would not be checked
                               ; (def. - No)
  ScanOnLine   No              ; Scan outbound before sending EMSI (def. - No)
                               ; if 'Yes' exact mail size would be passed to remote
                               ; if 'No' - size after last rescan
  ScanBefore Yes               ; if 'Yes' then scan outbound before node call (default)
  4DCompatible No              ; Compatibility with 4D tossers (def. - No),
                               ;  not domained, but zoned outbound
                               ; If 'Yes':
                               ;  only those zones, which were defined in 'Domain'
                               ;  block would be scanned, others ignored, but
                               ;  mail would be sent successfully if session occured
  HoldTime 3600                ; Delay time for calls on node, which was presented
                               ;  HAT or HXT flag (def. - 3600)
  QueueSort  +Priority         ; Queue sorting criteria (def. - Address )
                               ; '+' means ascending, '-' means descending order
                               ; Allowed:
                               ;   Address, +Address    by address
                               ;   -Address
                               ;   Size, +Size          by traffic size
                               ;   -Size
                               ;   Age, +Age            by oldest mail age
                               ;   -Age
                               ;   Priority, +Priority  by priority
                               ;   -Priority
                               ;   NoSort               do not sort
; MaxTry   10                  ; Max. number of attempts to call node
                               ; Brake! do not resets this counter by itself,
                               ; so do it in Brake!.Sch
                               ; (def - none)
; EmptyExit  2                 ; If specified, exit to OS with ErrorLevel
                               ; (between 10 and 255) when queue is empty
  WaitMailer 120               ; Time to wait synchronization with remote (sec)
                               ; (def. - 120)
  Threshold 3600               ; Timeout for EVENTs (sec)
                               ; (def. - 3600)
  MaxInComing 120              ; Max. duration of incoming session in minutes
  MaxOutGoing 120              ; Max. duration of outgoing session in minutes
  MaxCallCost 100000           ; Max. call cost for outgoing call (def. - unlimited)
  Debug   No                   ; Session and protocol debugging (def. - No)
  EMSIDebug No                 ; EMSI debugging (def. - No)
; RexxDebug Yes                ; Trace exported REXX functions calls (def. - No)
  Inbound  .\files\unsecure    ; Inbound path (def. - '.\inbound')
  Protected .\files            ; Inbound path for password-protected sessions
                               ; (def. - Inbound)
  LongOutbound .\longout       ; LongName outbound in form:
			       ;  domain.zone.net.node.point.<flavour>.Mail (?ut)
			       ;  domain.zone.net.node.point.<flavour>.List (?lo)
			       ;  domain.zone.net.node.point.Request        (req)
			       ;  domain.zone.net.node.point.Busy           (bsy)
			       ;  domain.zone.net.node.point.Hold           (hld)
			       ;  domain.zone.net.node.point.Try            (try)
			       ;  flavour ::= immediate|crash|direct|normal|hold|online|request
                               ;  (def. - none)
; TerminalInBound .\files\term ; Inbound path for terminal sessions
                               ; (def. - Inbound)
; SentList line1.sent          ; File where full pathnames of successfully
                               ; transferred files would be placed (for DL-counters)
                               ; (def. - none)
  HPFS      Yes                ; Inbound is located on HPFS partition
                               ; If 'Yes' then FNC flag would be set in EMSI (def. - No)
  CheckName No                 ; If set to 'Yes' then characters > 0x7F and < 0x21 in
                               ; filenames of received files would be replaced by '0'
                               ; (def. - No) (ifmail suxx...:[)
  FileCase  Mixed              ; Letter case in filenames of receiving/sending files
                               ; Allowed:
                               ;  AsIs    do not change
                               ;  Lower   convert to lowercase
                               ;  Mixed   convert to mixed case   (default)
                               ;  Upper   convert to uppercase
  TBoxes   .\boxes             ; Path to T-Mail fileboxes (def. - none)
  LongBoxes .\long.boxes       ; Path to longnamed fileboxes (HPFS) (def. - none)
                               ; Fileboxes are used by echosplitter
  Flags    .\flags             ; Flags directory
  RexxPath .\rexx              ; REXX scripts directory
  Semaphore \Sem32\Brake!\User ; Default semaphores path for
                               ; Semaphore Create/Remove/Post/Reset/Wait actions
  Schedule Brake!.Sch          ; Events file (def. - Brake!.Sch)

  #For 1
    Compiled Brake!.Scc        ; Compiled events file (def. - Brake!.Scc)
  #EndFor

  #For 2
    Compiled Brake!.Sc1        ; Compiled events file for other lines must be different!
  #EndFor

; EMSILog  Brake!.EMS          ; Log file for received/sent EMSI_DAT (def. - none)
  LogName  Brake!.Log          ; Log filename (def. - Brake!.Log)
  LogBuffer 4                  ; Log buffer size in Kbytes
  BinkLog  No                  ; Log in BinkleyTerm format (def. - No)
  FullLog Yes                  ; Log detail - full (def. - No)
  BinaryLog  Brake!.Blg        ; Binary log filename for Vagabondo stat generator
                               ; (def. - none)
; NoLOG REXX:                  ; Do not write to logfile lines which begins
                               ; with 'REXX:' and
; NoLOG "REXX dialer"          ; 'REXX dialer'
; NoSCR REXX:                  ; The same, but - to screen
; NoSCR "REXX dialer"          ; (case insensitive!)

; Pipe \pipe\brake.pipe        ; Pipe name
                               ; Writing to pipe is always performed as with 'FullLog Yes'
                               ; If prefix '\' is not specified then '\PIPE\Brake!\'
                               ; would be added
                               ; Pipe is bidirectonal, can accept key codes (Tail.exe)
                               ; (def. - none)
  HoldOnCall No                ; Send 'hold' traffic on outgoing calls (def. - No)
  RetryAfterExtern Yes         ; Try to establish session after external mailer call
                               ; (external handshake) if DCD is on (def. - Yes)
  DiscardPartialPKT Yes        ; Kill incomplete .PKTs (def. - Yes)
  AbortOnBSY No                ; Abort session if at least one AKA is busy (def. - No)
  DOSTime Yes                  ; If 'Yes' then treat file time while resuming as
                               ; MS-DOS does (only even seconds number)
                               ; No - otherwise
  BSYSemaphore No              ; Use mutex semaphores for AKA busy indication
                               ; instead of .BSY files
                               ; Semaphores are created in BsySemaPath directory:
  BsySemaPath \Sem32\Brake!\Busy ; def. - \Sem32\Brake!\Busy

;  BSYMaxAge 3                 ; DO NOT CHANGE THESE TWO PARAMETERS!
                               ; You don't need them, they are left as a special debug hook ;)
                               ; but I don't want to keep any undocumented features
                               ; If .BSY is older than <n> hours then kill it (def. - 3 hours)
                               ; Used only when BSYSemaphore No
;  BSYCheck  600               ; .BSY files check period in seconds (def. - do not check)

  Priority  TimeCritical       ; Process priority class
                               ;  Allowed (in ascending priority):
                               ;  IdleTime         - PRTYC_IDLETIME
                               ;  Regular          - PRTYC_REGULAR
                               ;  ForeGroundServer - PRTYC_FOREGROUNDSERVER
                               ;  TimeCritical     - PRTYC_TIMECRITICAL
                               ;  (def. - Regular)
; ForeGroundDelta 15           ; Foreground threads priority delta (def.- 0)
                               ; Background threads are echosplitter, status line,
                               ; counter reset thread and managers thread
 ScanPriority ForeGroundServer ; Outbound rescan priority
; ScanPriorityDelta 1          ; and its delta
 TimeSync ^^2:50/0@            ; Synchronize clock with 2:50/0 when in session
                               ;  (v8 ergep expresion)
                               ;  (many TimeSync's allowed)
                               ; Remote must give us EMSI addon TRX#
 TimeSyncDelta 2               ; If time delta with remote is greater then
                               ; specified, then clock synchronization performed
                               ; (def. - 2)
; StatusLine Off               ; Status line control (def. - On)
  StatusPeriod 500	       ; status line refresh perion in milliseconds
			       ;  (def. - 500 )

 Separator ,                   ; Number triads separator (def. - no separator)
 IconMail icons/mail.ico       ; Icon for non-packed mail
 IconXMail icons/xmail.ico     ; Icon for packed mail
 IconRIP icons/rip.ico         ; Icon for dz`s FRIP files
 InFileBufferSize 4	       ; receive file buffer size
			       ;   in Kb (def. - runtime)
 OutFileBufferSize 4	       ; send file buffer size
			       ;   in Kb (def. - runtime)
 EA Yes			       ; support your filesystem extended attributes?
			       ;   (def. - Yes)
 AddressForm Domain @ NoZeroPoint
                               ; format of displayed address:
                               ;  ZeroPoint - show .0
                               ;  NoZeroPoint - not show .0
                               ;  Domain <char> - domain delimiter
                               ;    if delimiter `@' then domain after address
                               ;    if delimiter `I' then domain was not show
                               ;    in other cases domain is placed before address

 CallAfterAnswer Yes	       ; call after answer (Yes) or after circle (No)
			       ;  def. - Yes
End

Define Security                ; Security settings

  PasswordAbort No             ; Abort session if password is incorrect (Yes)
                               ; or set HAT, skip all incoming files and then
                               ; send warning letter (No) (def. - No)
  Password 2:5051/55 qqq       ; Password on session with 2:5051/55

End

Define Protocol                ; Protocol settings

  DirZap Yes                   ; DirZap is allowed globally (def. - No)
; ZStartBlock 512              ; Start block size for Z-modem
                               ; (def. - max. available)

; Timeouts are specified for non-ARQ sessions
; If value is less than 2 seconds then Brake! will set it to 2 seconds

  ZBaseTimeOut  60             ; Z-modem base timeout in seconds (for 300 bps),
                               ; proportionally decreased for greater speeds
                               ; (def. - 60 sec)
  ZTimeOut 300   30            ; Timeout for 300 bps
                               ; Timeout can be specified for any speed,
                               ; if omitted for some speed then ZBaseTimeOut
                               ; value will be used

  ZTimeOut 1200  15
  ZTimeOut 2400  15
  ZTimeOut 4800  10
  ZTimeOut 7200  10
  ZTimeOut 9600  8
  ZTimeOut 12000 8
  ZTimeOut 14400 8
  ZTimeOut 16800 8
  ZTimeOut 19200 8
  ZTimeOut 21600 5
  ZTimeOut 24000 5
  ZTimeOut 26400 5
  ZTimeOut 28800 5
  ZTimeOut 23600 5
  ZTimeOut 64000 5

  ZCheckCpsAfter 60            ; Check minimum allowed CPS on Z-modem
                               ; after <nn> seconds from transfer start
                               ; (def. - 60)

  ZMinOutCps 300   15          ; Minimum allowed CPS for outgoing sessions
                               ; on 300 bps with Z-modem
  ZMinOutCps 1200  90
  ZMinOutCps 2400  120
  ZMinOutCps 4800  240
  ZMinOutCps 7200  360
  ZMinOutCps 9600  480
  ZMinOutCps 12000 600
  ZMinOutCps 14400 720
  ZMinOutCps 16800 840
  ZMinOutCps 19200 960
  ZMinOutCps 21600 1080
  ZMinOutCps 23600 1180
  ZMinOutCps 24000 1200
  ZMinOutCps 26400 1320
  ZMinOutCps 28800 1440
  ZMinOutCps 64000 3200

  ZMinInCps 300   15           ; Minimum allowed CPS for incoming sessions
                               ; on 300 bps with Z-modem
  ZMinInCps 1200  90
  ZMinInCps 2400  120
  ZMinInCps 4800  240
  ZMinInCps 7200  360
  ZMinInCps 9600  480
  ZMinInCps 12000 600
  ZMinInCps 14400 720
  ZMinInCps 16800 840
  ZMinInCps 19200 960
  ZMinInCps 21600 1080
  ZMinInCps 23600 1180
  ZMinInCps 24000 1200
  ZMinInCps 26400 1320
  ZMinInCps 28800 1440
  ZMinInCps 64000 3200

  Hydra Yes                    ; Hydra is allowed globally (def. - Yes)
  HydraChat Yes		       ; Hydra's chat is allowed? (def. - No)
                               ; No auto-open hydra's chat window if following
			       ;  string was received
  NoStartHydraChat " * Remote has chat facility with bell enabled^n"
  NoStartHydraChat " * Remote has no chat facility available^n"
  NoStartHydraChat "^07^07^n * Chat mode end^n"
  NoStartHydraChat " * Chatter online with bell enabled^n"
; HRxWindow      8192          ; Hydra receive window size (def. - 0)
; HTxWindow      8192          ; Hydra send window size (def. - 0)
                               ; If window size <n> is specified then receiver
                               ; and sender will be synchronized after
                               ; transferring of <n> bytes
                               ; This is useful for bad quality lines
  HBaseTimeOut   40            ; Base Hydra timeout in seconds (for 300 bps),
                               ; proportionally decreased for greater speeds
                               ; (def. - 40)
  HTimeOut 300   20            ; Timeout for 300 bps
                               ; Timeout can be specified for any speed,
                               ; if omitted for some speed then
                               ; HBaseTimeOut value will be used
  HTimeOut 1200  10
  HTimeOut 2400  10
  HTimeOut 4800  4
  HTimeOut 7200  4
  HTimeOut 9600  4
  HTimeOut 12000 4
  HTimeOut 14400 4
  HTimeOut 16800 4
  HTimeOut 19200 4
  HTimeOut 21600 3
  HTimeOut 24000 3
  HTimeOut 26400 3
  HTimeOut 28800 3
  HTimeOut 23600 2
  HTimeOut 64000 2

  HCheckCpsAfter 60            ; Check minimum allowed CPS on Hydra
                               ; after <nn> seconds from transfer start
                               ; (def. - 60)

  HMinOutCps 300   15          ; Minimum allowed CPS for outgoing sessions
                               ; on 300 bps with Hydra
  HMinOutCps 1200  90
  HMinOutCps 2400  120
  HMinOutCps 4800  240
  HMinOutCps 7200  360
  HMinOutCps 9600  480
  HMinOutCps 12000 600
  HMinOutCps 14400 720
  HMinOutCps 16800 840
  HMinOutCps 19200 960
  HMinOutCps 21600 1080
  HMinOutCps 23600 1180
  HMinOutCps 24000 1200
  HMinOutCps 26400 1320
  HMinOutCps 28800 1440
  HMinOutCps 64000 3200

  HMinInCps 300   15           ; Minimum allowed CPS for incoming sessions
                               ; on 300 bps with Hydra
  HMinInCps 1200  90
  HMinInCps 2400  120
  HMinInCps 4800  240
  HMinInCps 7200  360
  HMinInCps 9600  480
  HMinInCps 12000 600
  HMinInCps 14400 720
  HMinInCps 16800 840
  HMinInCps 19200 960
  HMinInCps 21600 1080
  HMinInCps 23600 1180
  HMinInCps 24000 1200
  HMinInCps 26400 1320
  HMinInCps 28800 1440
  HMinInCps 64000 3200

;  HOption UUE                  ; Hydra options
                                ; By default Hydra passes any byte sequences
                                ;  Allowed (over comma):
                                ;    XON - channel doesn't pass XON/XOF
                                ;          (set automatically if 'FlowControl SoftWare')
                                ;    TLN - channel doesn't pass "@\r" byte sequences
                                ;    CTL - channel doesn't pass bytes 0x00..0x1F and 0x7F
                                ;    HIC - XON/CTL/TLN include bytes with higher bit set
                                ;    HI8 - channel doesn't pass bytes with higher bit set
  ChatTimeOut 10		; chat timeout in seconds (def. 10)
End

Define Video                   ; Video parameters

; Frame    4 1 648 380         ; Window position (lower left corner) and its size
                               ; Do not specify for fullscreen
  #For 1 2
    Title "The Brake! Mailer"  ; Task name in OS/2 Switch List, if not specified
                               ; then System Name is taken
  #EndFor
; VideoMode 132 50             ; Set video mode, use current if omitted
  Color Yes                    ; Color monitor? (def. - Yes)

; Video attributes:

; Status         0x2f          ; Status line (hexadecimal)
; StatusLampOn    0x10         ; Status light ON (decimal)
; StatusLampOff  077           ; Status light OFF (octal)
; Border         <atr>         ; Window border
; Action         <atr>         ; 'Action' window contents
; ActionBold     <atr>         ; Highlighting in 'Action'
; Abort          <atr>         ; 'Abort' window contents
; PopUp          <atr>         ; Pop-up windows
; PopUpItem      <atr>         ; Inactive fields in pop-up windows
; PopUpBold      <atr>         ; Active fields in pop-up windows
; Terminal       <atr>         ; Terminal
; Help           <atr>         ; Help
; HelpBold       <atr>         ; Highlighted help items
; QueueCrash     <atr>         ; 'Crash' queue element
; Queuenormal    <atr>         ; 'Normal' queue element
; QueueHold      <atr>         ; 'Hold' queue element
; QueueImmed     <atr>         ; 'Immed' queue element
; QueueDirect    <atr>         ; 'Direct' queue element
; QueuePtr       <atr>         ; Queue scroll arrows and pointer
; ModemTo        <atr>         ; Strings being sent to modem
; ModemFrom      <atr>         ; Strings was received modem
; ModemCtlTo     <atr>         ; Control signals/characters to modem
; ModemCtlFrom   <atr>         ; Not printable characters from modem
;
; Format <atr>:  [0][x][ddd]
;
;     [ddd]  =  optional digits
;     [0]    =  optional zero (0)
;     [x]    =  optional x or X
; ScreenSaver 180	       ; Screen saver activation time in seconds
			       ;  (def. - none)
; ScreenSaverModule daemon     ; Screen saver's DLL (def. - builtin saver)

End

Define Melody                   ; Sound settings

  Volume 60                     ; Volume for .WAV/.MID files playback
				;  (def. - current)
  AudioPath .\multimedia        ; Default path to .WAV/.MID files
; NoSound  19:00-07:00          ; Time when suppress all sounds


; Sound format: <repetitions> <values>
;   <values> is a list of four-digit combinations:

;   1st digit -  starting frequency (Hz) (0 - keep silence)
;   2nd       -  frequency increment per tic
;   3rd       -  duration of tic (msec)
;   4th       -  number of tics

; Connect       Sound 1 1000 100 100 4 1300 -100 100 3		; connected
  Connect       Play  Connect.wav
; BeginSession  Sound 3 1000 500 100 2				; start session
  BeginSession  Play  BeginSession.wav
; EndSession    Sound 5 4000 1000 10 5				; session completed
  EndSession    Play  EndSession.wav
; BadSession    Sound 1 1000 10 1 10				; session failed
  BadSession    Play  BadSession.wav
; EndTransfer   Sound 1 900 10 20 25				; terminal end transfer
  EndTransfer   Play  EndTransfer.wav
; Human         Sound 5 300 150 6 10				; human call
  Human         Play  human.wav
; ErrorAbort    Sound 1 100 10 10 100 1090 -10 10 99		; error
  ErrorAbort    Play  Error.wav
; Ring          Sound 4 3500 0 50 1 3000 0 50 1 4000 0 5 1	; incomming call
  Ring          Play  ring.wav
; Alarm         Sound 1 2048 0 249 1				; warning
  Alarm         Play  bell.wav
; Start		Sound 1 1024 0 250 2 512 0 125 4		; at start
  Start		Play  start.wav
; Stop          Sound 1 1024 0 1000 1				; at exit
  Stop          Play  stop.wav
; Bell          Sound 1 1024 0 249 1				; bell
  Bell          Play  bell.wav
					; BTW, _any_ action can be specified here

End

Define EchoSplit               ; Internal echosplitter
                               ; OutBound and TBoxes/LongBox parameters must be specified
                               ; Keep these directories on the same logical disk
                               ; (Brake! would rename files), otherwise you should copy files
                               ; If 'LongNames Yes' is not specified then echosplitter uses
                               ; T-Mail-style fileboxes with T-Mail address limitations
                               ; For longnames limitations are:
                               ;   zone   < 4096
                               ;   net    < 65535
                               ;   node   < 65535
                               ;   point  < 65535
  Size   1                     ; Echobundles greater than 1 Kb will be moved to
                               ; fileboxes (def. - don't do that)
  PKTSize  1                   ; Netmail greater than 1 Kb will be moved to
                               ; fileboxes (def - don't do that)
  Circle 600                   ; Splitter activation period in seconds (def. - 600)
  Delete Yes                   ; Echobundles with 'truncate' attribute would be
                               ; deleted, not truncated (def. - Yes)
  LongNames Yes                ; For HPFS fileboxes will be created with long names
  RemoveNotFound No            ; Delete references to non-existent files from ?lo
                               ; (def. - No)
End

Define Modem                   ; Modem settings

; Port 1                       ; Port number (started from 1!)
                               ; If not specified then Brake! will work as a scheduler
 #For 2
  Port 3
 #EndFor

 #For 3
  Port 4
 #EndFor

  Baud 38400                   ; Locked port speed
                               ; Allowed:
                               ;    300, 600, 1200, 2400, 4800
                               ;    9600, 19200, 38400, 57600
                               ;    76800, 115200, 230400, 345600
  FailSafe 60                  ; Data block debuffering timeout in seconds
                               ; Change this parameter only if sending
                               ; problems occur on VMP/TELNET, in this case
                               ; it should be increased
                               ; 2-3 minutes would be enough for VMP/TELNET
                               ; via Ethernet
; FuckingTelebit Yes           ; If you have Telebit and some files can not be
                               ; transferred (CRC errors on remote or transfer
                               ; hanging) set this parameter to 'Yes'
                               ; This is also possible on AT&T modems and others which have
                               ; the new feature: wait for '\r' after receipt of
                               ; '+++A' sequence
                               ; (def. - No)
 VirtualDCD Off                ; Virtual DCD handling
                               ; DCD is considered 'high' when string defined as
                               ; 'Connect' string was read from port, or when
                               ; it was set with BrkComSetConnectString REXX function
  WaitCall 120                 ; Connection wait time while calling, in seconds
  WaitAnswer 60                ; Connection wait time while answering, in seconds
;  AutoInit  300               ; Modem auto-initialization period (def. - none)
;  Delay      10               ; Pauses between character sending in OffLine (msec)
                               ; for slow modems (def. - none)
;  Monitor    3                ; Ignore carrier loss for 3 seconds
                               ; (def. - none)
  FlowControl Hardware         ; Hardware (CTS/RTS) (recommended) or
                               ; Software (XON/XOFF) flow control
                               ; (DZA will not be used when 'Software' is set)
                               ; (def. - Hardware)
  BreakMode   No               ; Use Break signal while online (configure your modem!)
                               ; (def. - No)
  HardWareRing Yes             ; Detect ring as hardware signal RI (Yes)
                               ; or 'RING' word (No) (def. - No)

  Ring        RING             ; Overriding modem strings
  Busy        BUSY
  Ok          OK
  Connect     CONNECT
  NoDialTone  "NO DIALTONE"
  RRing       RRING
  NoCarrier   "NO CARRIER"
  Error       ERROR
  Voice       VOICE
  NoAnswer    "NO ANSWER"
  NoConnect   "NO CONNECT"

  BadCounter  RRING              ; Strings from modem which increase
                                 ; bad attempts counter while dialing
  BadCounter  ERROR              ; (def. - not defined)
  BadCounter  VOICE
  BadCounter  "NO CARRIER"
  BadCounter  "NO CONNECT"
  BadCounter  "NO DIALTONE"
  BadCounter  *Aborted*          ; String for Ctrl-A/Esc
  BadCounter  *nothing*          ; Timeout string

  Ignore  CARRIER:               ; Strings that begin with these words
  Ignore  COMPRESSION:           ; will be ignored from modem

  Init    ATZ|                   ; Initialization string
  Answer ATH1|~~~~ATA:           ; Answer string
                                 ; NOTE! String ends in : not |
  HangUp v~~^^`+++~~~            ; Hang-up string
                                 ; Brake! doesn't drop DTR, so you should!
  DialPrefix ATDp                ; Dialing prefix
  DialSuffix :                   ; Dialing suffix
  AfterDial  ~                   ; Pause for 500 msec after unsuccessful dial
                                 ; attempt
  AbortDial  v~~~^^`|            ; String sent to abort dialing

; Statistics ats70?s72?s74?s78?s71?s73?: OK
                                 ; Command to get statistics
                                 ; First argument -
                                 ; command to be sent to modem after disconnecting
                                 ; Second argument -
                                 ; statistics last string

; OnExit v                       ; String to send to modem when exiting to OS
; Special PEP ATS50=255DP        ; Special dialing using node flags
; Special ZYX ATS50=3DP
; Special UTVd ATS0=99DT         ; Same, using worktime flag ;)
; SpecialSuf IFC " 60177:"       ; Special dialing suffix (on node flags)
  Collision No                   ; If 'Yes' then try to answer if got
                                 ;  NO DIALTONE while dialing
  MinInBound 1200              ; Min. connection speed when answering
  MinOutBound 1200             ; Min. connection speed when calling
  Window No                    ; Show modem window? (def - No)
  WindowAt 3 3                 ; Modem window X & Y screen coordinates
  WindowOff 10                 ; Modem inactivity time before closing window (sec)
  QueueStats No                ; Modem input queue statistics window
  ARQ /HST                     ; If there is /HST substring in CONNECT string then
                               ; connection will be understood as with error
                               ; correction
                               ;  Defined by default:
                               ;    /MNP /REL /COMP /V42 /LAM /ZYX /HST
                               ;    /TEL /VMO /ARQ FAST
  HalfDuplex FAST              ; If there is FAST substring in CONNECT string then
                               ; connection will be understood to be half-duplex
                               ; and Hydra will work in one-way transfer mode
                               ; (def. - none)
  MaxRRing 50                  ; Abort waiting for connection after getting
                               ; 50 RRING strings from modem (def. - none)
  RingCount 2                  ; Answer after 2nd RING (def. - 1)
  RingWait  5                  ; Max. interval (in seconds) between two RINGs while
                               ; waiting for RingCount
                               ; If interval is greater than RingWait then it is
                               ; another call (def. - 10 sec)
End

Define Translate               ; Phone numbers translation

  Local          7-8422-       ; Local call
  Country        7-            ; Country code
  International  8W010-        ; International call
  Area  7-095- Cost 1960 8W095 ; Cost 1960 per minute
  Area        7-   8W/qq       ; exSU
  Area        8-   8W          ; Iskra-2
  Area       99-   8W/@        ; 8W is dialing prefix, @ is dialing suffix
  Area 7-8422- " "             ; ...the same as Local

End

Define Keys                    ; Keys definitions

   1      EXEC /env:IDLE_SENSITIVITY=50 bbb.bat
   insert Run /noClip /Parent /Child \fido\fe\toss.cmd
;  DELETE Rexx Del
;  alt-f12    Call Alarm
;  alt-z      Poll normal 2:5051/15
;  alt-l      Exit 99
;  alt-b      Run d:\brake\purge.cmd
;  ctrl-t     Rexx "rexx.brk %mode %port %baud %address %box"
;  shift-f10  Exec /Close k:\moscow\user.bat
;  f5         get files normal 1
;  f11        Thread send brake.exe normal 1 ; 'Thread' modifier can be applied
                                             ;   to any action except 'Exec' and 'Exit',
                                             ;   it means that <action> will be executed
                                             ;   by a separate thread
;  ctrl-d     reset
;  ctrl-b     checkbsy
;  ctrl-C     compile                        ; Compile nodelist(s)
                                             ; Don't specify 'Thread' modifier here

;  Alt-F2     Eval "Call BrkLog 'Test of Eval';
;                   mdm=BrkKbdGetString('String to modem','');
;                   if mdm<>'' then
;                     Call BrkComPutString mdm;"
;  Alt-F      Run /fore /parent "e brake!.ctl"
   f2 Play brake.wav

End

Define Process                 ; Processes

  Online File 00000000.flg Exec h:\aaa.cmd
                               ; Exec h:\aaa.cmd on receiving file 00000000.flg
  After Mask .+\.(bnk)|(BNK) Create bnk!.now
                               ; Create flag bnk!.now (if path is not specified
                               ;  then in Flags directory) on receiving file
                               ;  +\.(bnk)|(BNK)
                               ;  Mask is unix v8 egrep regular expression
  After Mask .*\.[Tt][Ii][Cc] Semaphore Post \SEm32\tic-found
  Immediate Files Rexx prcfiles.brk
  After NetMail Create toss!.now ; If NetMail was received
  After ArcMail Create toss!.now ; If mail bundle was received
; ^^^^1 ^^^^^^2 ^^^^^3             ^1 ::== <After>|<Online>|<Immediate>
                                 ;          After     - after session
                                 ;          Online    - after receiving & before sending
                                 ;          Immediate - immediately after receipt of file
                                 ; ^2 ::== <Mask>|<File>|<Files>|<ArcMail>|<NetMail>
                                 ; ^3 Action (like in Keys/Events)
  Process Once                   ; Once  - execute process only for first matching file
                                 ; Multi - execute process for each matching file (default)
                                 ; Note that ArcMail, NetMail, Files are executed only once
  Flag QuQu.flg exit 55          ; Exit on flag (like in Keys definitions)
  Flag Toss!.now wait 5 and Run toss.cmd
  Flag rescan.now rescan         ; Outbound rescan
  Flag split.it! split           ; Start echosplit circle
  NoFlag IsReady.I'm Semaphore Post crazy ; Do when flag is missing
  Flag run.fc exec fc
  ExitFlag Brk-Down              ; Special exit flag, such flag must be unique!
                                 ; It shall not have a filename extension, the Brake!
                                 ; will automatically put line number into extension.
                                 ; File must contain decimal exit code
                                 ; If 'ExitFlag' is detected then Brake! will
                                 ; terminate with specified exit code

End

Define External                         ; External programs (mailers, BBS etc)

  Connect "CONNECT FAX" Exec getfax.cmd ; If CONNECT FAX string is received when connected
  Connect "CONNECT 1200" HangUp         ; While waiting for connect
  Connect VOICE Log "Some idiot is answering :-\"
  HandShake  "any string" HangUp        ; Mailer handshake
  HandShake QUQU log "ᠬ  QuQu"

  Remote "John Gladkih" 228102          ; User with password who is allowed to access
                                        ; internal cmd.exe remotely by pressing
                                        ; Ctrl-C 3 times
                                        ; If not specified then nobody is allowed
                                        ; Password is generated by passwd.exe utility
  AutoBBS Yes                           ; If incoming call was not recognized as mailer's
                                        ; call during the 'WaitMailer' (see Define Misc)
                                        ; period then run BBS (def. - No)
  BBS     Yes                           ; BBS users allowed
  MinBaud 2400                          ; Minimum speed for BBS
  Time    CM                            ; When BBS users accepted
  RunBBS  Run    "doBBS.bat %port"      ; On BBS request - Run/Exec/Create/etc.,
                                        ; like Keys (or simply HangUp)
                                        ; Strings for terminal caller
                                        ; If string begins with '@' then the rest
                                        ; is considered as output filename
  TwiceESC  "Human caller alowed. Please press ESC twice for access to BBS."
                                        ; If BBS is available now
  MailOnly  "This system is MAIL ONLY. Please hangup."
                                        ; If there is no BBS
  SlowModem "Sorry, your modem is too slow for access to BBS. Please hangup."
                                        ; If speed is lower than MinBaud
  Mailnow   "Only MAIL processing at this time. Please call later."
                                        ; If not BBS time
  Loading   "Loading BBS, please wait..."
                                        ; Loading BBS message
  GoodBye   "Good bye dear friend!"     ; HangUp message if BBS is not available

End

Define Actions                          ; Something like macro-procedures
                                        ; which you can use in 'Call' action
 Routine Alarm Sound 1 100 10 10 100 1090 -10 10 99 And
                Log "Something is wrong!" And
                Call Abort              ; Call Abort procedure
 Routine Abort Log "Mailer Exit with error 128" And Exit 128

End

Define StartUp                          ; Actions on start-up

; Do Exec checkdisk.cmd                 ; Syntax is like in Keys/Events
; Do Poll crash 5051/15
; Do Log "StartUp 1"
; Do Log "StartUp 2"
; Do Semaphore Create startup.semaphore
; Do Semaphore Post   startup.semaphore
; Do Semaphore Wait   startup.semaphore

End

Define Exit                             ; Actions on exit

; Do Semaphore Remove startup.semaphore ; (see StartUp)

End

Define XLAT                    ; Character translation in terminal

; In          64 65            ; input, code 64 is replaced by 65
; Out         65 64            ; output
; In          65 64
; Out         64 65
; XLATfile    koi8.xlt         ; Binary file with translation table
  Answer "ces login:" "john^r" ; If modem response is "ces login:" then send "john<cr>"
; Display     pp password      ; If modem response is "pp" then display "password"

End

Define FReq                      ; Freqs management

  Freq Yes                       ; No        - not accepted
                                 ; Yes       - accepted
                                 ; Listed    - accepted only from listed systems
                                 ; Protected - accepted only from secure links
  CheckReq Yes                   ; Yes - process .Req files addressed to our system only
                                 ; No - any .Req file is processed
  MinBaud 2400                   ; Minimal FReq speed
  Time CM                        ; Time when FReqs accepted
  Path k:\t-mail\files           ; Path to FReq'able files
  Tree k:\files                  ; Tree - directory with its subdirectories
  BaseFile Brake!.Frq            ; FREQ's data base with limits
  Index FreqBase.Idx		 ; FREQ'able files data base (def. FreqBase.Idx)
  Policy   Freq.Pol              ; FRequesting policy (can be omitted)
  SessionTime 60                 ; Time limit - minutes per session
  SessionSize 1024               ; Size limit - KBytes per session
  DayTime 120                    ; Time limit - minutes per day
  DaySize 4096                   ; Size limit - KBytes per day
  WeekTime 4800                  ; Time limit - minutes per week
  WeekSize 40960                 ; Size limit - KBytes per week
  MonthTime 1200                 ; Time limit - minutes per month
  MonthSize 409600               ; Size limit - Kbytes per month
  Alias FILES k:\files\list      ; Aliases
  Alias NEWS k:\files\news
  Alias *.* /dev/null
  Alias com2 e:\swapper.dat
  Alias con "`ncftp -r ftp.cdrom.com:/pub/os2/*`"

End

Define Calls                            ; Allowable calls -
                                        ; addresses which we can (or can't) call to

 Abort Yes                              ; If 'Yes' then abort session if at least
                                        ; one AKA from presented is not acceptable
                                        ; (default)
                                        ; If 'No' then exclude this AKA
                                        ; and continue session

; Allowed                               ; 'Allowed' keyword is optional
;   Address ^^((2:5051/)((1)|(9)|(11)|(14)|(16)))@
                                        ;  Address -> V8 egrep expression
;   Address ^^(17:.*)@                  ;  first or second
;   Flag    ^^(V32b)$                   ;  flag (egrep)
;   Flag    ^^(V32)$
;   Flag    ^^(PEP)$
; Except                                ; Except following addresses
;   Address ^^(2:5051/2)@
;   Flag    ^^((V32b)|(V32B))$
;   Flag    ^^(UISKRA)$                 ; User-defined flags must begin with 'U'
;   Flag    ^^(UNEC)$
                                        ; Many Allowed/Except blocks can follow
                                        ; each other, or can be put together
End

Define Accept                           ; Acceptable calls from other systems
                                        ; see 'Define Calls'
; Allowed
;   Address ^^((2:5051/)((1)|(9)|(11)|(14)|(16)))@
;   Address ^^(17:.*)@
; Except
;   Address ^^(2:5051/2)@

End

Define RexxHook                         ; Rexx hooks for some actions

; BeforeScan befscan.brk                ; Procedure executed before queue rescan
; AfterScan aa.brk                      ; Procedure executed after queue rescan
; Translate trans.brk                   ; Phone number translation:
                                        ; 'Call trans.brk node, phone'
                                        ; If returns empty string then the Brake!
                                        ; will translate by itself, otherwise - translated
                                        ; phone number returned
; CallAvailable calls.brk               ; Check if call is allowed now
                                        ; Returns:
                                        ;  'YES'      - call is allowed,
                                        ;  'NO'       - call is not allowed,
                                        ;  'YOURSELF' - decide yourself ;)
; AnswerAvailable answers.brk           ; Check if answer is allowed now
                                        ; (see above for return values)
; CallableNode callnode.brk             ; Check if call is allowed to specified address
                                        ; 'Call callnode.brk node'
                                        ; (see above for return values)
; AcceptableNode accnode.brk            ; Check node for acceptance
                                        ; 'Call accnode.brk node'
                                        ; (see above for return values)
; BeforeScanNode nodebef.brk            ; Procedure executed before rescan for
                                        ; specified address
                                        ; (see AfterScanNode)
; AfterScanNode nodeaft.brk             ; Procedure executed after rescan for
                                        ; specified address
;
;   This two procedures is called with one parameter - node address
;   Must return a string in the following format:
;
; 'Flavour ImmedMail  ImmedXMail  ImmedFiles
;          CrashMail  CrashXMail  CrashFiles
;          DirectMail DirectXMail DirectFiles
;          NormalMail NormalXMail NormalFiles
;          HoldMail   HoldXMail   HoldFiles
;          Request'
;
; Flavour :== Default|Immed|Crash|Direct|Normal|Hold
; Everything else is ignored
;
; Other elements - numbers (traffic), string tail elements may be empty

; Terminal terminal.brk                 ; Executed instead of terminal
; Mailer   mailer.brk                   ; Executed instead of internal mailer =)
; RecoverFile recover.brk               ; Executed instead of internal file
                                        ; recovering check
; Usage: Call recover.brk 'Query',name
;        Call recover.brk 'Ok',name
;        Call recover.brk 'Fail',name
;
;  name     - full pathname of file to receive
;  'Query'  - asks if file resuming is needed, waits for:
                'Yes <path>'      needed
;               'No <path>'       not needed
;               'Skip <path>'     skip (destructive, ZSKIP)
;               'Error <path>'    can't receive (non-destructive, ZFERR)
;               'YourSelf'        decide yourself
;               where <path> sets pathname of file to receive
;  'Ok'     - receiving of <name> was ok
;  'Fail'   - error

;  BeforeSession befsess.brk            ; Called before session after EMSI
                                        ; Has two parameters:
                                        ;  1st - incoming/outgoing
                                        ;  2nd - primary address
;  AfterSession aftsess.brk             ; Called after session before disconnecting
                                        ; Has three parameters:
                                        ;  1st - incoming/outgoing
                                        ;  2nd - primary addresss
                                        ;  3rd - OK/FAIL, session termination status
;  Statistics stat.brk                  ; Called after session and after hangup
;  SendThisFile sendfile.brk            ; Called before sending file
;    Parameters: <name>, <flavour>, <type>, <location>, <aka>, <session>
;
;       <name>     ::= file to send
;       <flavour>  ::= Immed|Crash|Direct|Normal|Hold|Online|FReq
;                      Online - when sending from .qlo/.qut
;                      FReq   - when sending freqs (from .rlo/.rut)
;       <type>     ::= mail|xmail|file
;       <location> ::= Outbound|T-Box|Long-Box|Cfg-Box
;       <aka>      ::= target AKA for sending
;       <session>  ::= In|Out
;
;    Must return:
;
;       'YourSelf' - decide yourself (default algorithm)
;       'No'       - do not send (file & ?lo reference are not changed)
;       'Yes'      - send file anyway (ignoring default algorithm)
;                    zero-length file could be send in such way
;
; FReq "process freq"                   ; Called when freq was received
                                        ; Has two parameters:
                                        ;  1st - path to .req
                                        ;  2nd - primary remote address
                                        ; Must return:
                                        ;  'Yes'      - freq is processed (*)
                                        ;  'No'       - freq is ignored (*)
                                        ;  'YourSelf' - process yourself
                                        ; (*) - if .req file is already exists then
                                        ; it will be deleted automatically
; Answer AnswerHook                     ; Called when answering on call,
                                        ; without parameters
                                        ; Must return:
                                        ;  'Yes'      - answered successfully
                                        ;  'No'       - failed
                                        ;  'YourSelf' - process yourself
; InitModem initModem                   ; Called when modem is initialized,
                                        ; with one parameter - init string
                                        ; Must return:
                                        ;  'Yes'      - init ok
                                        ;  'No'       - init failed
                                        ;  'YourSelf' - process yourself
; BadModem BadModem                     ; Called when problem with modem/port
                                        ; is occured
                                        ; Must return:
                                        ;  'Yes' - problem was fixed
; ToEMSI_DAT emsito.brk                 ; 뢠 ᫥ ନ஢
                                        ;   EMSI_DAT  ।  
				        ;  ࠬ஬ - ନ஢ ⮬
					;     
                                        ;     ப
; FromEMSI_DAT emsifrom.brk		; 뢠 ᫥ ਥ  ६
                                        ;   EMSI_DAT  
				        ;  ࠬ஬ - 祭 ⮬
					;     
                                        ;     ப
                                        ;  'No'  - problem was not fixed
End

Define 2:5051/1@Fidonet        ; Special overriding for 2:5051/1
                               ; You can overrride many nodes! :)
  Address 2:5051/16            ; We'll present only 2:5051/16 AKA
                               ; (multiple 'Address' directives allowed)
; Mode     Normal              ; Mode (Hold, Normal, Direct, Crash, Immed)
                               ; (def. - Normal)
; Priority 100                 ; Node priority in queue, overrides 'Mode'
  Password xxxxxxx             ; Session password (optional)
  Phone    7-8422-312813       ; Phone number overriding (optional)
                               ; If number begins with '#' then it will not be translated
  Dial     ATm1DP              ; Dialing prefix (optional)
  Carrier  20                  ; Time to wait for carrier (optional)
; Time     1.7:0-5.8:0,6.0:0-7.0:0
                               ; Work time a-la T-Mail or CM or Txy/Wxy
                               ; (work time is rounded by minute)
                               ; Txy & Wxy must be defined in GMT!!!
                               ; Combination is allowed, over comma
                               ; If combination of time and Txy is specified then
                               ; The Brake! will detect GMT or Local using last element
  Cost 1                       ; Cost of 1 minute
  CPS  960                     ; Speed bytes/sec for cost calculation
                               ; (taken from nodelist if omitted)
  Flags ZYX,V32,UNEC,UISKRA    ; System flags - if present then The Brake!
                               ; doesn't look to nodelist flags!
                               ; All user defined flags must begin with 'U',
                               ; so go ahead! ;)
  Crash    .\brake             ; Fileboxes (optional)
  Normal   outbound\1          ; -la bink/+
  Hold     .\login
  Immed    .\immed
  Direct   .\direct
  Inbound  .\inbound\1         ; Inbound path (optional)
  DirZap No                    ; Disable DirZedZap (def. - Yes)
  Hydra  No                    ; Disable Hydra (def. - Yes)
  MaxInComing 120              ; Max. duration of incoming session in minutes
  MaxOutGoing 10               ; Max. duration of outgoing session in minutes
; MaxTry   100                 ; Max. number of attempts to call node
  Hidden                       ; Hidden lines definitions
    Phone    7-8422-08001800   ;   phone
    Dial     ats50=255dp       ;   dialing prefix
    Carrier  22                ;   CONNECT waiting time
    Time     CM                ;   worktime
  End                          ; Hiddens must be defined after Time/Carrier/Dial
                               ; which are needed for default settings
                               ; If Hiddens are before Time/Carrier/Dial then
                               ; Modem section defaults would be taken
  Chain Yes                    ; Yes - sequentially use all phone numbers during a call
                               ; No  - use next phone number only after processing
                               ;       the rest of the queue
                               ; (def. - No)
;  BeforeCall exec "load.cmd v34.rom %handle"  ; Execute before call
;  AfterCall exec "load.cmd v32b.rom %handle"  ; Execute after call
;  Do Copy 2:5051/1 .\5051_1   ; Execute _instead of_ call
                               ; (see Keys/Events)
; RexxDial call.brk            ; Rexx procedure for calling specified address
                               ; Has two parameters:
                               ;  1st - primary address
                               ;  2nd - current phone number
                               ; Must return a number:
                               ;     1 - no connection
                               ;     2 - connection established
                               ;     4 - incoming RING (the Brake! will try to
                               ;         answer  if 'Collision Yes')
                               ;     (see BrkComDial function)
                               ;     everything else is understood as 1 ;-)
End

Define Mask 2:5051/            ; Overriding using egrep-mask
                               ; All parameters from 'Define <Node>' is allowed
                               ; except Hidden/Phone
                               ; All 'Define <node>' blocks following 'Define Mask'
                               ; which match the mask will take missing parameters
                               ; from it
 Dial ATDT

End

Define Fax                      ; Fax processor
                                ; Fax processor is executed when answering
                                ; on call and getting +FCO from modem
                                ; (Group 3, Class 2 or Class 2.0)
  Inbound .\Faxes               ; Directory for received faxes
                                ; If not specified then fax processor is disabled
                                ; Received fax has format as BinkleyTerm 2.60 fax,
                                ; one page per file
  Baud 9600                     ; Port speed when receiving fax
                                ; If not specified then speed from 'Modem' block
                                ; would be used
End

Complete. - config ends there, the rest is comments :)

