#if !defined(__NODELIST_H)

#define __NODELIST_H

#include <stdio.h>
#include <sys\stat.h>
#include <iostream.h>

#include "buffer.h"
#include "semaphor.h"

class Nodelist;

class CacheItem
{
  unsigned long last;
  short zone, net, node, point;
  char *str;
  char *phone, *time, *name, *sysop, *flags;
  char callable;
  short baud;

private:
  void init();

public:

  CacheItem();
  CacheItem( short zone, short net, short node, short point, char *str);
  CacheItem( CacheItem* );
  ~CacheItem();

  friend ostream& operator << ( ostream& o, const CacheItem& c );
  friend ostream& operator << ( ostream& o, const Nodelist& c );

  char *getNdlField( int );

  char *getTime() const { return time; }
  char *getPhone() const { return phone; }
  char *getSystem() const { return name; }
  char *getSysop() const { return sysop; }
  char *getFlags() const { return flags; }
  char *getString() const { return str; }
  int getBaud() const { return baud; }

  char isCallable() const { return callable; }

  friend class Nodelist;
};

#pragma pack(1)
struct FileEntry
{
  short num;
  long ptr;
};

struct NodeEntry
{
  long num;
  long ptr;
};

struct FileInfo
{
  off_t size;
  time_t mtime;
};
#pragma pack()

struct NDLEntry
{
  short zone, net, node, point;
  long pointer;
};

class Nodelist
{
  char **files;
  char filesCount;

  FileInfo *fileInfo;
  FileInfo idxInfo;

  char needReadNodes;

  FileEntry *zones;
  short zonesCount;

  FileEntry *nets;
  short netsCount,
	netsOfZone;

  NodeEntry *nodes;
  short nodesCount,
	nodesOfNet;

  FILE *idx;
  char *name;

  CacheItem **cache;
  int cacheSize;

  unsigned long cacheHit, totalFind;

  static unsigned long mutex;

protected:
  int getNets( short zone );
  int getNodes( short net );
  void closeIndex();
  void freeList();
  void allocList();

public:

  friend ostream& operator << ( ostream& o, const Nodelist& c );

  int getCacheUsage() const;

  int getCacheHints() const
    { return totalFind ? int( (cacheHit*100)/totalFind ) : 100; }

  CacheItem *find( short zone, short net, short node, short point );
  void compile();

  static int lock( long how = -1, long mutex = Nodelist::mutex );

  static void unlock( long mutex = Nodelist::mutex )
    { unlockMutexSemaphore( mutex ); }


  static int createNodeListMutex()
  { 
    return createNamedMutex( "\\Sem32\\Brake!\\Task\\NodeList.Access.Flag",
                             &mutex );
  }


  void reset() { freeList(); allocList(); }

  int needToCompile();

  Nodelist( int iCacheSize=50 );
  ~Nodelist() { freeList(); }
};

extern Nodelist *nodeListPtr;
#define nodeList (*nodeListPtr)

char * latestFile( char *path );
void compiler();

#endif
