#define INCL_DOSSEMAPHORES
#define INCL_DOSERRORS
#include <os2.h>

#include <stddef.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <share.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <builtin.h>

#include "language.h"

#include "nodelist.h"
#include "misc.h"
#include "semaphor.h"

unsigned long Nodelist::mutex = 0xffffffff;

char *CacheItem::getNdlField( register int pos )
{
  register char *prev = str,
		*old = str;

  for( register int i(0); i<pos; i++ )
  {
    char *next = strchr( prev, ',' );

    if( next==NULL )
      return NULL;

    old = prev;
    prev = next+1;
  }

  --prev;

  int len = int(prev-old);

  if( len<0 )
  {
    len = 0;
    log( "char *CacheItem::getNdlField( register int pos ) len<0" );
  }

  char *ret = new char [ len+1 ];

  if( len )
    memcpy( ret, old, len );

  ret[ len ] = 0;

  return ret;
}

void blanker( register char *p )
{
  for( ; *p; p++ )
    if( *p=='_' )
      *p = ' ';
}

static void addItem( char **to, char *from )
{
  int len( strlen( from )+1 );

  if( *to!=NULL )
    len += strlen( *to )+1;

  char *q = new char [ len ];

  if( *to!=NULL )
  {
    strcpy( q, *to );
    strcat( q, "," );
  }
  else
    *q = 0;

  strcat( q, from );

  delete *to;
  *to = q;
}

void CacheItem::init()
{
  last = ::time( NULL );

  phone = NULL;
  time = NULL;
  name = NULL;
  sysop = NULL;
  flags = NULL;

  callable = 1;
  baud = 0;

  if( str==NULL )
    return;

  char *ret = new char [ strlen(str)+2 ];

  strcpy( ret, str );
  strcat( ret, "," );
  delete str;
  str = ret;

  ret = getNdlField( 1 );

  if( *str!=',' && ret!=NULL )
    addItem( &flags, strupr( ret ) );

  if( ret!=NULL && ( !stricmp( ret, "hold" )
       || !stricmp( ret, "down" ) ) )
    callable = 0;

  delete ret;

  name = getNdlField( 3 );
  sysop = getNdlField( 5 );
  phone = getNdlField( 6 );

  ret = getNdlField( 7 );
  baud = short(atoi( ret ));
  delete ret;

  if( !baud )
    baud = 300;

  blanker( name );
  blanker( sysop );

  char user( 0 );

  for( int i=8; ; i++ )
  {
    if( (ret = getNdlField( i ))==NULL )
      break;

    if( user )
    {
      {
        char *q = (char *)_alloca( strlen(ret)+2 );

	strcpy( q, "U" );
	strcat( q, ret );
	addItem( &flags, q );
      }

to_user:
      if( strlen(ret)==3 && ( toupper(*ret)=='W' || toupper(*ret)=='T' ) )
	addItem( &time, ret );
    }
    else
      if( !stricmp( ret, "CM" ) )
      {
	addItem( &time, ret );
	addItem( &flags, ret );
      }
      else
	if( !stricmp( ret, "U" ) )
	  user = 1;
	else
	  if( toupper(*ret)=='U' )
	  {
	    user = 1;
	    addItem( &flags, ret );
	    strcpy( ret, ret+1 );
	    goto to_user;
	  }
	  else
	    addItem( &flags, ret );

    delete ret;
  }
}

CacheItem::CacheItem() :
  zone( 0 ),
  net( 0 ),
  node( 0 ),
  point( 0 ),
  str( NULL )
{
  init();
}

CacheItem::CacheItem( short izone, short inet, short inode, short ipoint,
		      char *istr) :
  zone( izone ),
  net( inet ),
  node( inode ),
  point( ipoint ),
  str( newStr( istr ) )
{
  init();
}

CacheItem::CacheItem( CacheItem *i )
{
  if( i==NULL )
  {
    last = 0;
    zone = net = node = point = 0;
    str = phone  = time = name = sysop = flags = NULL;
    callable = 0;
    baud = 0;
  }
  else
  {
    last = i->last;
    zone = i->zone;
    net = i->net;
    node = i->node;
    point = i->point;
    str = newStr( i->str );
    phone = newStr( i->phone );
    time = newStr( i->time );
    name = newStr( i->name );
    sysop = newStr( i->sysop );
    flags = newStr( i->flags );
    callable = i->callable;
    baud = i->baud;
  }
}

CacheItem::~CacheItem()
{
  delete str;
  delete phone;
  delete time;
  delete name;
  delete sysop;
  delete flags;
}

ostream& operator << ( ostream& o, const CacheItem& c )
{
  o << "    {{Last:" << c.last
    << "}{Addr:" << c.zone << char(':') << c.net << char('/') << c.node
    << char('.') << c.point
    << "}{Ndl:";
  strItem( o, c.str );
  o << char('}') << endl;
  o << "    {Phone:";
  strItem( o, c.phone );
  o << "}\n    {Time:";
  strItem( o, c.time );
  o << "}\n    {Name:";
  strItem( o, c.name );
  o << "}\n    {Sysop:";
  strItem( o, c.sysop );
  o << "}\n    {Flags:";
  strItem( o, c.flags );
  o << "}\n    {Callable:" << (c.callable?"Yes":"No");
  o << "}\n    {Baud:" << c.baud;
  o << "}}";

  return o;
}

static char *errRead = Msg_WarnErrReading;

void Nodelist::allocList()
{
  idx = NULL;
  files = NULL;
  fileInfo = NULL;
  filesCount = 0;
  zones = NULL;
  zonesCount = 0;
  nets = NULL;
  netsCount = 0;
  netsOfZone = 0;
  nodes = NULL;
  nodesCount = 0;
  nodesOfNet = 0;
  name = NULL;
  cacheHit = 0;
  totalFind = 0;
  needReadNodes = 1;

  cache = new CacheItem * [ cacheSize ];

  for( int i=0; i<cacheSize; i++ )
    cache[i] = new CacheItem;

  name = new char [ strlen(outboundInfo.path)+strlen(outboundInfo.index)+1 ];
  strcpy( name, outboundInfo.path );
  strcat( name, outboundInfo.index );

  idx = _fsopen( name, "rb" );

  if( idx!=NULL )
  {
    struct stat st;

    if( fstat( fileno(idx), &st ) )
      st.st_mtime = st.st_size = 0;

    idxInfo.size = st.st_size;
    idxInfo.mtime = st.st_mtime;
  }

//

  if( idx==NULL )
  {
    log( Msg_WarnErrIndexOpen, name );
please_recompile:
    compiler();
  }
  else
  {
    char test;
    extern char ndlVersion;

    if( fread( &test, 1, 1, idx )!=1 )
      goto read_error;

    if( test!=ndlVersion )
    {
      log( Msg_ErrIndexWrong );
mustdie:
      fclose( idx );
      unlink( name );
      goto please_recompile;
    }

    if( fread( &zonesCount, 1, sizeof(zonesCount), idx )!=sizeof(zonesCount) )
    {
read_error:
      log( errRead, name );
      goto mustdie;
    }
    else
    {
      zones = new FileEntry [ zonesCount ];

      if( fread( zones, 1, sizeof(FileEntry)*zonesCount, idx ) !=
			   sizeof(FileEntry)*zonesCount )
	goto read_error;

      if( fread( &filesCount, 1, sizeof(filesCount), idx )!=sizeof(filesCount) )
	goto read_error;

      files = new char * [ int(filesCount) ];
      fileInfo = new FileInfo [  int(filesCount) ];

      for( int i=0; i<filesCount; i++ )
      {
	if( fread( fileInfo+i, 1, sizeof(FileInfo), idx )!=sizeof(FileInfo) )
	  goto read_error;

	char len;

	if( fread( &len, 1, sizeof(len), idx )!=sizeof(len) )
	  goto read_error;

	files[i] = new char [ int(len)+1 ];

	if( fread( files[i], 1, len, idx )!=len )
	  goto read_error;

	files[i][len] = 0;
      }
    }
  }
}

void Nodelist::freeList()
{
  filesCount = 0;
  zonesCount = 0;
  netsCount = 0;
  netsOfZone = 0;
  nodesCount = 0;
  nodesOfNet = 0;
  needReadNodes = 1;

  if( cache!=NULL )
  {
    for( int i=0; i<cacheSize; i++ )
      delete cache[i];

    delete cache;
    cache = NULL;
  }

  for( int i=0; i<filesCount; i++ )
    delete files[i];

  delete files;
  files = NULL;

  delete fileInfo;
  fileInfo = NULL;

  delete zones;
  zones = NULL;

  delete nets;
  nets = NULL;

  delete nodes;
  nodes = NULL;

  delete name;
  name = NULL;

  closeIndex();
}

int Nodelist::getNets( short zone )
{
  needReadNodes = 1;

Again:

  if( zones==NULL)
    return 0;

  for( short i=0; i<zonesCount; i++ )
    if( zone==zones[i].num )
      break;

  if( i==zonesCount )
    return 0;

  delete nets;
  nets = NULL;
  netsCount = 0;

  struct stat st;

  if( fstat( fileno(idx), &st ) )
    st.st_mtime = st.st_size = 0;

  if( idxInfo.size != st.st_size || idxInfo.mtime != st.st_mtime )
  {
    reset();
    goto Again;
  }

  fseek( idx, zones[i].ptr, SEEK_SET );

  if( fread( &netsCount, 1, sizeof(netsCount), idx )!=sizeof(netsCount) )
  {
read_error:
     log( errRead, name );

     closeIndex();
     return 0;
  }

  nets = new FileEntry [ netsCount ];

  if( fread( nets, 1, sizeof(FileEntry)*netsCount, idx ) !=
		      sizeof(FileEntry)*netsCount )
    goto read_error;

  return 1;
}

int Nodelist::getNodes( short net )
{
Again:

  if( nets==NULL )
    return 0;

  for( short i=0; i<netsCount; i++ )
    if( net==nets[i].num )
      break;

  if( i==netsCount )
    return 0;

  delete nodes;
  nodes = NULL;
  nodesCount = 0;

  struct stat st;

  if( fstat( fileno(idx), &st ) )
    st.st_mtime = st.st_size = 0;

  if( idxInfo.size != st.st_size || idxInfo.mtime != st.st_mtime )
  {
    reset();
    goto Again;
  }

  fseek( idx, nets[i].ptr, SEEK_SET );

  if( fread( &nodesCount, 1, sizeof(nodesCount), idx )!=sizeof(nodesCount) )
  {
read_error:
     log( errRead, name );

     closeIndex();
     return 0;
  }

  nodes = new NodeEntry [ nodesCount ];

  if( fread( nodes, 1, sizeof(NodeEntry)*nodesCount, idx ) !=
		       sizeof(NodeEntry)*nodesCount )
    goto read_error;

  needReadNodes = 0;
  return 1;
}

CacheItem *Nodelist::find( short zone, short net, short node, short point )
{
  totalFind++;

  CacheItem *item = NULL;
  register long search = (long(node)<<16)|point;
  Buffer ret;
  unsigned long oldest( 0xffffffffl );
  int  oldestIndex = 0;
  long current = time( NULL );
  FILE *ndl = NULL;
  char index;

  for( int i=0; i<cacheSize; i++ )
    if( cache[i]->zone==zone && cache[i]->net==net &&
	cache[i]->node==node && cache[i]->point==point )
      break;

  if( i!=cacheSize )
  {
    cacheHit++;
    cache[i]->last = current;
    return cache[i]->str==NULL ? (CacheItem *)NULL : cache[i];
  }

  if( idx==NULL )
    goto not_found;

  if( zone!=netsOfZone )
    if( !getNets( zone ) )
      goto not_found;

  if( idx==NULL )
    goto not_found;

  netsOfZone = zone;

  if( net!=nodesOfNet || needReadNodes )
    if( !getNodes( net ) )
      goto not_found;

  if( idx==NULL )
    goto not_found;

  nodesOfNet = net;

  for( i=0; i<nodesCount; i++ )
    if( search==nodes[i].num )
      break;

  if( i==nodesCount )
    goto not_found;

  index = char((nodes[i].ptr>>24)&0xff);

  search = nodes[i].ptr&0xffffffl;

  if( index > filesCount )
  {
    log( Msg_WarnErrIndexCorr );

unable_use:
    closeIndex();
    compiler();
    goto not_found;
  }

  ndl = _fsopen( files[ int(index) ], "r", SH_DENYWR );

  if( ndl==NULL )
  {
    log( Msg_WarnErrNoAccess, files[ int(index) ] );
    goto unable_use;
  }

  struct stat st;

  if( fstat( fileno(ndl), &st ) || st.st_size!=fileInfo[index].size ||
                                   st.st_mtime!=fileInfo[index].mtime ||
                                   search>=st.st_size-10 )
  {
    log( Msg_WarnErrChanged, files[ int(index) ] );

error_ndl:
    fclose( ndl );
    goto unable_use;
  }

  if( fseek( ndl, search, SEEK_SET ) )
  {
error_read:
    log( Msg_ErrUnableRead, files[ int(index) ], strError() );
    goto error_ndl;
  }

  for( ;; )
  {
    i = getc( ndl );

    if( ferror( ndl ) )
      goto error_read;

    if( i==EOF || i=='\n' )
      break;

    ret.putInto( char(i) );
  }

  ret.putInto( 0 );

  fclose( ndl );

  if( !ret[0] )
    goto not_found;

  item = new CacheItem( zone, net, node, point, ret.str );

put_to_cache:
  for( i=0; i<cacheSize; i++ )
    if( cache[i]->last<oldest )
    {
      oldest = cache[i]->last;
      oldestIndex = i;
    }

  delete cache[oldestIndex];
  cache[oldestIndex] = item;

  return cache[oldestIndex]->str==NULL ? (CacheItem *)NULL : cache[oldestIndex];

not_found:
  item = new CacheItem( zone, net, node, point, NULL );
  goto put_to_cache;
}

void Nodelist::closeIndex()
{
  if( idx!=NULL )
  {
    fclose( idx );
    idx = NULL;
  }
}

int Nodelist::getCacheUsage() const
{
  for( int i(0), count(0); i<cacheSize; i++ )
    if( cache[i]->zone )
      count++;

  return int( (count*100)/cacheSize );
}

ostream& operator << ( ostream& o, const Nodelist& c )
{
  for( int i(0); i<c.cacheSize; i++ )
    if( c.cache[i]->zone || c.cache[i]->net ||
        c.cache[i]->node || c.cache[i]->point )
    {
      o << (i+1) << "> ";
      o << *c.cache[i];
      o << endl;
    }

  return o;
}

Nodelist::Nodelist( int iCacheSize ) :
  cacheSize( iCacheSize ),
  needReadNodes( 1 )
{
  allocList();

  if( needToCompile() )
    compiler();
}

int Nodelist::needToCompile()
{
  int needCompile = 0;

  for( int ii=0; ii<filesCount && !needCompile; ii++ )
  {
    struct stat st;

    if( stat( files[ii], &st ) )
    {
      char *ls = latestFile( files[ii] );

      if( ls==NULL || stat( ls, &st ) )
      {
        st.st_mtime = 0;
        st.st_size = 0;
      }

      delete ls;
    }

    if( st.st_mtime!=fileInfo[ii].mtime || st.st_size!=fileInfo[ii].size )
      needCompile = 1;
  }

  return needCompile;
}

int Nodelist::lock( long how, long mutex )
{
  return DosRequestMutexSem( mutex, how )==ERROR_TIMEOUT ? 0 : 1;
}
