#define INCL_DOSPROCESS
#define INCL_DOSEXCEPTIONS
#include <os2.h>

#include <stdlib.h>
#include <malloc.h>
#include <io.h>
#include <time.h>
#include <share.h>
#include <fcntl.h>
#include <string.h>
#include <process.h>
#include <ctype.h>
#include <sys\stat.h>

#include "except.h"

#include "misc.h"
#include "crc.h"
#include "nodelist.h"
#include "queue.h"
#include "direct.h"
#include "ea.h"

#include "language.h"

typedef unsigned short uShort;

#define window (*cmpWindowPtr)

Window *cmpWindowPtr = NULL;

static long used = 0,
	    count = 0,
            start = 0;

static NDLEntry *nodeArray = NULL;

static int _Optlink compare( void const *x, void const *y )
{
  if( ((NDLEntry *)x)->zone > ((NDLEntry *)y)->zone )
    return 1;

  if( ((NDLEntry *)x)->zone < ((NDLEntry *)y)->zone )
    return -1;

  if( ((NDLEntry *)x)->net > ((NDLEntry *)y)->net )
    return 1;

  if( ((NDLEntry *)x)->net < ((NDLEntry *)y)->net )
    return -1;

  if( ((NDLEntry *)x)->node > ((NDLEntry *)y)->node )
    return 1;

  if( ((NDLEntry *)x)->node < ((NDLEntry *)y)->node )
    return -1;

  if( ((NDLEntry *)x)->point > ((NDLEntry *)y)->point )
    return 1;

  if( ((NDLEntry *)x)->point < ((NDLEntry *)y)->point )
    return -1;

  return 0;
}

static long tzone =0,
	    tnet = 0,
	    tnode = 0,
	    tpoint = 0,
	    tregion = 0,
	    tentry = 0,
	    maxNet = 0,
            lists = 0;

static char *str = NULL;

static void sort()
{
  if( !used )
    return;

  window.centre( 8, Msg_ScrCmpSorting );
  qsort( nodeArray, used, sizeof(NDLEntry), compare );
  window( 1, 8 ).clearLine();
}

static void compileFile( char *name, long curNdl, char *exclude,
                                NDLItemType type, long& ttlSize,
                                short defZone, short defNet, short defNode )
{
  FILE *ndl = _fsopen( name, "r" );

  if( ndl==NULL )
  {
    log( Msg_ErrCmpUnableOpen, name, strError() );
    return;
  }

  log( Msg_CmpCompile, name );
  window( strlen(Msg_ScrCmpName)+3, 2 ) << fileName( name );
  window.clearLine();

  short zone( defZone ),
        net( defNet ),
        node( defNode ),
        point(0),
        region(0);

  short wzone(-1),
        wnet(-1),
        wregion(-1);

  int done(0);
  long size = filelength( fileno( ndl ) );
  char needExclude( 0 ),
       string[20],
       *end;
  long startCmp = time( NULL );

  lists++;

  while( !feof(ndl) )
  {
    *str = 0;

    long position = ftell( ndl );

    fgets( str, 512, ndl );

    if( ferror( ndl ) )
    {
      log( Msg_ErrUnableRead, name, strError() );
      break;
    }

    tentry++;;

    register char *c = strchr( str, ';' );

    if( c!=NULL )
      *c = 0;

    c = strchr( str, '\n' );

    if( c!=NULL )
      *c = 0;

    if( *str )
      if( *str== ',' || begin( str, "hub," ) ||
			begin( str, "hold," )  ||
			begin( str, "pvt," )  ||
			begin( str, "down," ) )
      {
	c = str;

	if( *c!=',' )
	  c = strchr( c, ',' );

	if( c==NULL )
	  goto illegal_entry;

	node = short( strtol( c+1, &end, 10 ) );

	if( *end!=',' )
	  goto illegal_entry;

	point = 0;

add_entry:
        if( (net!=wnet || region!=wregion || zone!=wzone) && curNdl )
          sort();

	if( !needExclude )
	{
          NDLEntry newEnt = { zone, net, node, point, curNdl | (position&0xffffffl) };
          NDLEntry *old = NULL;

          if( curNdl )
            old  = (NDLEntry *)bsearch( &newEnt, nodeArray, used,
                                        sizeof(NDLEntry), compare );
          register NDLEntry *cur;

          if( type==NDLItemAdd )
          {
            if( old==NULL )
            {
Add:  	      if( newEnt.zone==0 ||  newEnt.net==0 )
                log( Msg_ErrCmpIllZoneNet, (int)newEnt.zone, (int)newEnt.net, (int)newEnt.node, (int)newEnt.point, str );
              else
              {
                if( used==count )
                {
                  long count1 = count;

                  count <<= 1;

                  NDLEntry *node = new NDLEntry[ count ];

                  memcpy( node, nodeArray, count1*sizeof(NDLEntry) );

                  if( node==NULL )
                  {
                    count >>= 1;
                    log( Msg_ErrCmpNoMemory, count );
	            break;
                  }
                  else
                  {
                    delete nodeArray;
                    nodeArray = node;
                  }
                }

	        cur = nodeArray+used;
	        used++;
Replace:
  	        if( newEnt.zone==0 ||  newEnt.net==0 )
                  log( Msg_ErrCmpIllZoneNet, (int)newEnt.zone, (int)newEnt.net, (int)newEnt.node, (int)newEnt.point, str );
                else
  	          memcpy( cur, &newEnt, sizeof(newEnt) );
              }
            }
          }
          else
            if( old==NULL )
              goto Add;
            else
            {
              cur = old;
              goto Replace;
            }
	}
      }
      else
	if( begin( str, "host," ) )
	{
       	  net = short( strtol( str+5, &end, 10 ) );

	  if( *end!=',' )
	    goto illegal_entry;

	  node = 0;

	  if( !needExclude )
	    goto add_entry;

	}
	else
	  if( begin( str, "region," ) )
	  {
	    region = short( strtol( str+7, &end, 10 ) );

	    if( *end!=',' )
	      goto illegal_entry;

	    net = region;
	    node = 0;

	    if( !needExclude )
	    {
	      tregion++;
	      goto add_entry;
	    }
	  }
	  else
	    if( begin( str, "zone," ) )
	    {
	      zone = short( strtol( str+5, &end, 10 ) );

	      if( *end!=',' )
		goto illegal_entry;

	      itoa( zone, string+1, 10 );
	      *string = ',';
	      strcat( string, "," );
	      needExclude = char( exclude==NULL ? 0 : strstr( exclude, string )!=NULL );

	      net = zone;
	      node = 0;

	      if( !needExclude )
		goto add_entry;

	    }
	    else
	      if( begin( str, "point," ) )
	      {
		point = short( strtol( str+6, &end, 10 ) );

		if( *end!=',' )
		  goto illegal_entry;

		if( !needExclude )
		  goto add_entry;
	      }
	      else
		if( begin( str, "boss," ) )
		{
		  char *adomain;
		  uShort azone, anet, anode, apoint;
		  int rc=checkAddress( str+5, azone, anet, anode, apoint, &adomain );

		  if( !rc )
		    goto illegal_entry;

		  zone = azone;
		  net = anet;
		  node = anode;

		  itoa( zone, string+1, 10 );
		  *string = ',';
		  strcat( string, "," );
		  needExclude = char( exclude==NULL ? 0 : strstr( exclude, string )!=NULL );
		}
	      else
illegal_entry:
		log( Msg_ErrCmpIllegalEntry, str );

    done = int(position*100/size);

    if( net!=wnet || region!=wregion || zone!=wzone )
    {
      char b[32];
      long ela = time( NULL )-startCmp;

      sprintf( b, "%02lu:%02lu, %d%%", ela/60, ela%60, done );
      window( strlen( Msg_ScrCmpDone )+3, 3 ) << b;
      window.clearLine();
      window( strlen( Msg_ScrCmpZone )+3, 4 ) << zone;
      window.clearLine();
      window( strlen( Msg_ScrCmpRegion )+3, 5 ) << region;
      window.clearLine();
      window( strlen( Msg_ScrCmpNet )+3, 6 ) << net;
      window.clearLine();
      window( strlen( Msg_ScrCmpTotal )+3, 7 ) << used;
      window.clearLine();

      wzone = zone;
      wregion = region;
      wnet = net;
    }
  }

  {
    char b[32];
    long ela = time( NULL )-startCmp;

    sprintf( b, "%02lu:%02lu, %d%%", ela/60, ela%60, done );
    window( strlen( Msg_ScrCmpDone )+3, 3 ) << b;
  }
  window.clearLine();
  window( strlen( Msg_ScrCmpTotal )+3, 7 ) << used;
  window.clearLine();
  ttlSize += ftell( ndl );
  sort();
  fclose( ndl );
}

static int flushArray( FILE *ndl,
				    int netsPtr,
				    FileEntry *nets,
				    long &filePtr )
{
  filePtr = ftell( ndl );

  short netCount = short( netsPtr );

  if( fwrite( &netCount, 1, sizeof(netCount), ndl )!=sizeof(netCount) )
    return 1;

  int len = int( sizeof(*nets)*netsPtr );

  if( !len )
  {
    log( "Compiller: * Internal error: size of array is zero" );
    return 1;
  }

  if( fwrite( nets, 1, len, ndl )!=len )
    return 1;

  return 0;
}

char * latestFile( char *path )
{
  char *full = new char [ strlen(path)+_MAX_EXT+1 ];

  if( full==NULL )
    return NULL;

  char dir[_MAX_DIR],
       drive[_MAX_DRIVE],
       name[_MAX_FNAME],
       ext[_MAX_EXT];

  _splitpath( path, drive, dir, name, ext );

  strcpy( full, path );

  if( !*ext )
  {
    int len = strlen(full);

    strcat( full, ".*" );

    Directory rc( full );

    if( !rc )
      full[ len ] = 0;
    else
    {
      for( int max = 0; rc; rc++ )
      {
	for( char *str=rc.getName(), *p=str; *p; p++ )
	  if( *p=='.' )
	    str = p+1;

        char *end;
	int c = (int)strtol( str, &end, 10 );

	if( !*end && c>max )
	  max = c;
      }

      sprintf( full+len+1, "%03d", max );
    }
  }

  return full;
}

char ndlVersion = 3;

/*
    ndl  ᥣ p뢠!!!
*/

static long writeNdl( char fileCount )
{
  if( !tentry )
    return 0;

  FileEntry *zones = new FileEntry [ int(tzone) ],
	    *nets = new FileEntry [ int(maxNet) ];

  if( zones==NULL || nets==NULL )
  {
    log( Msg_ErrCmpNoMemInd );
    delete zones;
    delete nets;
    return 0;
  }

  char *idxName = new char [ strlen(outboundInfo.index)+
                             strlen(outboundInfo.path)+1 ];

  strcpy( idxName, outboundInfo.path );
  strcat( idxName, outboundInfo.index );
  capitalize( idxName );
  makeFilePath( idxName );

  FILE *ndl = _fsopen( idxName, "wb" );

  if( ndl==NULL )
  {
    log( Msg_ErrCmpUnableOpen, idxName, strError() );
    delete zones;
    delete nets;
    delete idxName;
    return 0;
  }

  int done,
      oldDone = -1;

  window( strlen(Msg_ScrCmpName)+3, 2 ) << fileName( idxName );
  window.clearLine();

  if( fwrite( &ndlVersion, 1, 1, ndl )!=1 )
    goto write_error;

  fseek( ndl, sizeof(FileEntry)*tzone+sizeof(short)+1, SEEK_SET );

  if( fwrite( &fileCount, 1, sizeof(fileCount), ndl )!=sizeof(fileCount) )
  {
write_error:
    log( Msg_ErrCmpUnableWrite, idxName, strError() );
abb:
    fclose( ndl );
    unlink( idxName );
    delete zones;
    delete nets;
    delete idxName;
    return 0;
  }

  for( DomainIterator i3( *outboundInfo.domains ); i3; i3++ )
  {
    NDLList *l = i3().getNdl();

    if( l!=NULL )
      for( NDLIterator i2( *l ); i2; i2++ )
      {
        char *name1 = i2().constructName();
        char *name = latestFile( name1 );

        if( name==NULL )
        {
          log( Msg_ErrCmpNoMemWrt );
          goto abb;
        }

        capitalize( name );

        struct stat st;

        if( stat( name, &st ) )
        {
          st.st_mtime = 0;
          st.st_size = 0;
        }

        if( fwrite( &st.st_size, 1, sizeof(st.st_size), ndl )!=sizeof(st.st_size) )
          goto write_error;

        if( fwrite( &st.st_mtime, 1, sizeof(st.st_mtime), ndl )!=sizeof(st.st_mtime) )
          goto write_error;

        fileCount = char( strlen( name ) );

        if( fwrite( &fileCount, 1, sizeof(fileCount), ndl )!=sizeof(fileCount) )
          goto write_error;

        if( fwrite( name, 1, fileCount, ndl )!=fileCount )
          goto write_error;

        delete name;
        delete name1;
      }
  }

  done = 0;

  int zonesPtr( 0 ),
      netsPtr( 0 );

  short prevZone( 0 ),
	prevNet( 0 ),
	nodeCount( 0 );

  long netFilePtr( -1 ),
       filePtr( -1 );

  for( count=0; count<used; count++ )
  {
    register NDLEntry *cur= nodeArray+count;
    long number = (long(cur->node)<<16)|cur->point;
    char resetPtr( 0 );

    if( (prevNet!=cur->net && prevNet) || (prevZone!=cur->zone && prevZone) )
    {
      if( netsPtr>=maxNet )
      {
	log( "Compiller: Internal error: netsPtr>=maxNet" );
        delete zones;
        delete nets;
        delete idxName;
	return 1;
      }
      if( netFilePtr==-1 )
      {
	log( "Compiller: Internal error: netFilePtr==-1 %d:%d/%d.%d",
		cur->zone, cur->net, cur->node, cur->point );
        delete zones;
        delete nets;
        delete idxName;
	return 1;
      }
      nets[ netsPtr ].ptr = netFilePtr;
      nets[ netsPtr ].num = prevNet;
      netsPtr++;
      prevNet = cur->net;
      resetPtr = 1;
    }

    if( !prevNet )
      prevNet = cur->net;

    if( prevZone!=cur->zone && prevZone )
    {
      if( flushArray( ndl, netsPtr, nets, filePtr ) )
	goto write_error;

      netsPtr = 0;

      if( zonesPtr>=tzone )
      {
	log( "Compiller: Internal error: zonesPtr>=tzone" );
        delete zones;
        delete nets;
        delete idxName;
	return 1;
      }

      if( filePtr==-1 )
      {
	log( "Compiller: Internal error: filePtr==-1 %d:%d/%d.%d",
	     cur->zone, cur->net, cur->node, cur->point );
        delete zones;
        delete nets;
        delete idxName;
	return 1;
      }
      zones[ zonesPtr ].ptr = filePtr;
      zones[ zonesPtr ].num = prevZone;
      zonesPtr++;
      prevZone = cur->zone;
    }

    if( !prevZone )
      prevZone = cur->zone;

    if( resetPtr || netFilePtr==-1 )
    {
      long prevPos = ftell( ndl );

      if( netFilePtr!=-1 )
      {
	fseek( ndl, netFilePtr, SEEK_SET );

	if( fwrite( &nodeCount, 1, sizeof(nodeCount), ndl )!=sizeof(nodeCount) )
	  goto write_error;

	fseek( ndl, prevPos, SEEK_SET );
      }

      netFilePtr = ftell( ndl );
      short countMask = 0xffff;

      if( fwrite( &countMask, 1, sizeof(countMask), ndl )!=sizeof(countMask) )
	goto write_error;

      nodeCount = 0;
    }

    if( fwrite( &number, 1, sizeof(number), ndl )!=sizeof(number) )
      goto write_error;

    if( fwrite( &cur->pointer, 1, sizeof(cur->pointer), ndl )!=sizeof(cur->pointer) )
      goto write_error;

    nodeCount++;

    done = int(count*100/used);

    if( (done%5)==0 && done!=oldDone )
    {
      window( strlen( Msg_ScrCmpDone )+3, 3 ) << done << char('%');
      window.clearLine();
      oldDone = done;
    }
  }

  if( zonesPtr>=tzone )
  {
    log( "Compiller: Internal error: zonesPtr>=tzone" );
    delete zones;
    delete nets;
    delete idxName;
    return 1;
  }

  if( netsPtr>=maxNet )
  {
    log( "Compiller: Internal error: netsPtr>=maxNet" );
    delete zones;
    delete nets;
    delete idxName;
    return 1;
  }

  nets[ netsPtr ].ptr = netFilePtr;
  nets[ netsPtr ].num = prevNet;
  netsPtr++;

  long prevPos = ftell( ndl );

  if( netFilePtr!=-1 )
  {
    fseek( ndl, netFilePtr, SEEK_SET );

    if( fwrite( &nodeCount, 1, sizeof(nodeCount), ndl )!=sizeof(nodeCount) )
      goto write_error;

    fseek( ndl, prevPos, SEEK_SET );
  }

  netFilePtr = ftell( ndl );

  if( flushArray( ndl, netsPtr, nets, filePtr ) )
    goto write_error;

  zones[ zonesPtr ].ptr = filePtr;
  zones[ zonesPtr ].num = prevZone;
  zonesPtr++;

  fseek( ndl, 1, SEEK_SET );

  if( flushArray( ndl, zonesPtr, zones, filePtr ) )
    goto write_error;

  fflush( ndl );

  long ret = filelength( fileno( ndl ) );

  fclose( ndl );
  setExtendedAttribute( idxName, ".TYPE", Msg_EANdlIdx );
  delete zones;
  delete nets;
  delete idxName;
  return ret;
}

static const strSize = 512;

static int readLine( FILE *dif, char *difStr, char *difName,
                            int mayEmpty=0 )
{
  *difStr = 0;
  fgets( difStr, strSize, dif );

  if( ferror( dif ) || !*difStr )
  {
    if( ferror( dif ) || (!*difStr && !mayEmpty) )
    {
      log( Msg_ErrCmpUnableRead, difName, strError() );
      return 1;
    }

    return 2;
  }

  return 0;
}

static int writeLine( FILE *out, char *difStr, char& line,
                             char *outName,
                             unsigned short& crc, unsigned short& origCrc )
{
  fputs( difStr, out );

  if( ferror( out ) )
  {
    log( Msg_ErrCmpUnableWrite, outName, strError() );
    return 1;
  }

  if( line==1 )
  {
    char *p = strrchr( difStr, ':' ),
         *end;

    line = 0;

    if( p==NULL )
    {
ill_format:
      log( Msg_ErrCmpIllegalOut, outName, line );
      return 1;
    }
    else
    {
      if( strlen(p)<3 )
        goto ill_format;

      origCrc = (unsigned short)strtoul( p+2, &end, 10 );

      if( *end && *end!='\n' )
        goto ill_format;
    }
  }
  else
    for( ; *difStr; difStr++ )
    {
      if( *difStr=='\n' )
        crc = (unsigned short)Z_UpdateCRC( ((unsigned short)('\r')), crc );

      crc = (unsigned short)Z_UpdateCRC( ((unsigned short)(*difStr)), crc );
    }

  return 0;
}

static void makeNdlPercent( Window& wndow, unsigned long ndlLen,
                                   FILE *ndl, int& old, long start )
{
  int per = (ftell( ndl )*100)/ndlLen;

  if( old!=per )
  {
    char b[32];

    old = per;
    start = time( NULL )-start;
    sprintf( b, "%02lu:%02lu, %d%%", start/60, start%60, per );
    wndow( strlen(Msg_ScrAppDone)+3, 4 ) << b;
  }
}

static void hideFile( char *difName, int fl )
{
  char ddir[_MAX_DIR],
       ddrive[_MAX_DRIVE],
       dname[_MAX_FNAME],
       dext[_MAX_EXT];

  _splitpath( difName, ddrive, ddir, dname, dext );

  char bad[] = "bad\\",
       ok[] = "ok\\",
       *nname = (char *)_alloca( strlen(ddir)+strlen(ddrive)+strlen(dname)+
                                 strlen(dext)+(fl ? sizeof(ok) : sizeof(bad)) );
  strcpy( nname, ddrive );
  strcat( nname, ddir );
  strcat( nname, fl ? ok : bad );
  strcat( nname, dname );
  strcat( nname, dext );
  capitalize( nname );

  log( fl ? Msg_CmpRenameOk : Msg_CmpRenameBad, difName, nname );

  makeFilePath( nname );

  if( rename( difName, nname ) )
    log( Msg_ErrUnableRename, difName, nname, strError() );
}

static int applyThisDiff( FILE *ndl, FILE *dif,
                                 char *ndlName, char *difName )
{
  char ddir[_MAX_DIR],
       ddrive[_MAX_DRIVE],
       dname[_MAX_FNAME],
       dext[_MAX_EXT],
       ldir[_MAX_DIR],
       ldrive[_MAX_DRIVE],
       lname[_MAX_FNAME],
       lext[_MAX_EXT],
       *outName,
       tmpExt[] = ".Tmp",
       tmpFName[16],
       *tmpName;

  _splitpath( ndlName, ldrive, ldir, lname, lext );
  _splitpath( difName, ddrive, ddir, dname, dext );
  outName = (char *)_alloca( strlen(ldrive)+strlen(ldir)+strlen(lname)+
                             strlen(dext)+1 );
  strcpy( outName, ldrive );
  strcat( outName, ldir );
  strcat( outName, lname );
  strcat( outName, dext );
  capitalize( outName );
  makeFilePath( outName );

  unlink( outName );

  sprintf( tmpFName, "%08lx", time( NULL ) );
  tmpName = (char *)_alloca( strlen(ldrive)+strlen(ldir)+strlen(tmpFName)+
                             sizeof(tmpExt) );
  strcpy( tmpName, ldrive );
  strcat( tmpName, ldir );
  strcat( tmpName, tmpFName );
  strcat( tmpName, tmpExt );
  capitalize( tmpName );
  makeFilePath( tmpName );

  FILE *out = _fsopen( tmpName, "w" );
  char illegal = 0;

  if( out==NULL )
  {
    log( Msg_ErrCmpUnableOpen, tmpName, strError() );
    illegal = 1;
  }
  else
  {
    int ok(1);
    char difStr[ strSize ];
    int line(0);

    unsigned short crc(0),
                   origCrc(0);

    char *sdif = fileName( difName ),
         *sndl = fileName( ndlName );

    int idif = strlen( sdif ),
        indl = strlen( sndl ),
        wid = idif>indl ? idif : indl;

    unsigned long ndlLen = filelength( fileno( ndl ) );
    int old(-1);
    char first(1);

    log( Msg_CmpApply, sdif, sndl );

    rewind( ndl );

    if( wid<12 )
      wid = 12;

    wid += strlen( Msg_ScrAppList )+5;

    Window wndow( (Z_ScreenWidth-wid)/2+1,
                  (Z_ScreenHeight-7)/2+1,
		  wid, 7, popUpColor,
		  Msg_ScrAppTitle, BS_SINGLELINE, DS_LOWERRIGHT );

    wndow( 2, 2 ) << Msg_ScrAppList << char(' ') << sndl;
    wndow( 2, 3 ) << Msg_ScrAppDiff << char(' ') << sdif;
    wndow( 2, 4 ) << Msg_ScrAppDone;

    time_t start = time( NULL );

    makeNdlPercent( wndow, ndlLen, ndl, old, start );
    +wndow;

    while( ok )
    {
      {
        register int readSt = readLine( dif, difStr, difName, 1 );

        if( readSt==1 )
          ok = 0;

        if( readSt )
          break;
      }

      line++;

      char *end;
      unsigned long how = strtoul( difStr+1, &end, 10 );

      if( *end && *end!='\n' )
      {
illegal_format:
        ok = 0;
        log( Msg_ErrCmpIllegalDiff, difName, line );
        break;
      }

      char skip=0;
      unsigned long i;

      switch( toupper(*difStr) )
      {
      default:
        goto illegal_format;

      case 'D':
        skip = 1;

      // fall

      case 'C':
        for( i=0; i<how; i++ )
        {
          if( readLine( ndl, difStr, ndlName ) )
          {
io_error:   ok = 0;
            break;
          }

          makeNdlPercent( wndow, ndlLen, ndl, old, start );

          if( !skip )
            if( writeLine( out, difStr, first, tmpName, crc, origCrc ) )
              goto io_error;
        }
        break;

      case 'A':
        for( i=0; i<how; i++ )
        {
          if( readLine( dif, difStr, difName ) )
            goto io_error;

          line++;

          if( writeLine( out, difStr, first, tmpName, crc, origCrc ) )
            goto io_error;
        }
      }
    }

    makeNdlPercent( wndow, ndlLen, ndl, old, start );
    fflush( out );

    long len = filelength( fileno( out ) );

    fclose( out );
    setExtendedAttribute( tmpName, ".TYPE", Msg_EANodeList );

    start = time( NULL )-start;
    log( Msg_CmpApplied, fileName( outName ), len/1024, start/60, start%60, len/1024/start );

    if( crc!=origCrc )
    {
      log( Msg_ErrCmpIllCrc, fileName( outName ),
           (unsigned long)crc, (unsigned long)origCrc );
      ok = 0;
    }

    if( !ok )
    {
delete_ill:
      log( Msg_CmpDelete, tmpName );

      if( unlink( tmpName ) )
        log( Msg_ErrUnableDelete, tmpName, strError() );

      illegal = 1;
    }
    else
      if( rename( tmpName, outName ) )
      {
        log( Msg_ErrUnableRename, tmpName, outName, strError() );
        goto delete_ill;
      }
  }

  fclose( dif );
  hideFile( difName, !illegal );

  return !illegal;
}

static int thisDiffIsMatched( FILE *ndl, char *firstStr, char *ndlName,
                                     char *path )
{
  FILE *dif = _fsopen( path, "r" );

  if( dif==NULL )
  {
    log( Msg_ErrCmpUnableOpen, path, strError() );
    return 0;
  }

  char firstDiffStr[ strSize ];
  int ret=0;

  fgets( firstDiffStr, strSize, dif );

  if( ferror( dif ) )
  {
    log( Msg_ErrCmpUnableRead, path, strError() );
    fclose( dif );
    hideFile( path, 0 );
  }
  else
    if( !stricmp( firstStr, firstDiffStr ) )
      ret = applyThisDiff( ndl, dif, ndlName, path );
    else
      fclose( dif );

  return ret;
}

static int searchMatchedDiff( FILE *ndl, char *firstStr, char *ndlName,
                                     char *path )
{
  char dir[_MAX_DIR],
       drive[_MAX_DRIVE],
       name[_MAX_FNAME],
       ext[_MAX_EXT];

  _splitpath( path, drive, dir, name, ext );

  if( !*ext )
  {
    int prefLen = strlen(dir)+strlen(drive)+1;
    char mask[] = ".*",
         *search = (char *)_alloca( strlen(path)+sizeof(mask) );
    int ret( 0 );

    strcpy( search, path );
    strcat( search, mask );

    for( Directory rc( search ); rc && !ret; rc++ )
    {
      char *name = rc.getName();
      char *full = new char [ prefLen+strlen( name ) ];

      strcpy( full, drive );
      strcat( full, dir );
      strcat( full, name );

      capitalize( full );
      ret = thisDiffIsMatched( ndl, firstStr, ndlName, full );

      delete full;
    }

    return ret;
  }
  else
    return thisDiffIsMatched( ndl, firstStr, ndlName, path );
}

static void processDiff( char *listIni, char *diff )
{
  for( int need(1); need; )
  {
    char *list = latestFile( listIni );

    if( list==NULL )
    {
      log( Msg_ErrCmpNoMemArr );
      return;
    }

    capitalize( list );
    need = 0;

    FILE *ndl = _fsopen( list, "r" );

    if( ndl==NULL )
      log( Msg_ErrCmpUnableOpen, list, strError() );
    else
    {
      char firstStr[ strSize ];

      fgets( firstStr, strSize, ndl );

      if( ferror( ndl ) )
        log( Msg_ErrCmpUnableRead, list, strError() );
      else
        need = searchMatchedDiff( ndl, firstStr, list, diff );

      fclose( ndl );

      if( need )
        hideFile( list, 1 );
    }

    delete list;
  }
}

static void processDiffs()
{
  for( DomainIterator i1( *outboundInfo.domains ); i1; i1++ )
  {
    NDLList *l = i1().getNdl();

    if( l!=NULL )
      for( NDLIterator i2( *l ); i2; i2++ )
      {
        NDLItem &cur = i2();
        char *diffName = cur.constructDiffName();

        if( diffName==NULL )
          continue;

        char *listName = cur.constructName();

        if( listName==NULL )
        {
          delete diffName;
          continue;
        }

        capitalize( listName );
        capitalize( diffName );
        processDiff( listName, diffName );
        delete listName;
        delete diffName;
      }
  }
}

void Nodelist::compile()
{
  int needCompile = 0;

  processDiffs();
  reset();

  if( idx==NULL )
    needCompile = 1;
  else
    needCompile = needToCompile();

  if( !needCompile )
  {
    log( Msg_InfoNoCmpNeed );
    return;
  }

  int maxFound = 0;
  char fileCounter = 0;

  for( DomainIterator i1( *outboundInfo.domains ); i1; i1++ )
  {
    NDLList *l = i1().getNdl();

    if( l!=NULL )
      for( NDLIterator i2( *l ); i2; i2++ )
      {
        int len = strlen( fileName( i2().getName() ) );

        if( len>maxFound )
          maxFound = len;

        fileCounter++;
      }
  }

  if( maxFound<12 )
    maxFound = 12;

  int wndWidth = strlen( Msg_ScrCmpName )+maxFound+6;
  cmpWindowPtr = new Window( (Z_ScreenWidth-wndWidth)/2+1,
                             (Z_ScreenHeight-10)/2+1,
		  	     wndWidth, 10, popUpColor,
			     Msg_ScrCmpTitle, BS_SINGLELINE, DS_LOWERRIGHT );

  window( 2, 2 ) << Msg_ScrCmpName;
  window( 2, 3 ) << Msg_ScrCmpDone;
  window( 2, 4 ) << Msg_ScrCmpZone;
  window( 2, 5 ) << Msg_ScrCmpRegion;
  window( 2, 6 ) << Msg_ScrCmpNet;
  window( 2, 7 ) << Msg_ScrCmpTotal;
  +*cmpWindowPtr;

  used = 0;
  count = 0;
  start = 0;
  nodeArray = NULL;
  tzone =0;
  tnet = 0;
  tnode = 0;
  tpoint = 0;
  tregion = 0;
  tentry = 0;
  maxNet = 0;
  lists=0;

  str = (char *)_alloca( 600 );

  count = 0x10000;
  nodeArray = new NDLEntry [ count ];

  if( nodeArray==NULL )
  {
no_memory:
    log( Msg_ErrCmpNoMemArr );
    return;
  }

  start = time( NULL );

  long i = 0,
       ttlSize = 0;

  for( DomainIterator i3( *outboundInfo.domains ); i3; i3++ )
  {
    NDLList *l = i3().getNdl();

    if( l!=NULL )
      for( NDLIterator i2( *l ); i2; i2++ )
      {
        NDLItem& cur = i2();
        char *name1 = cur.constructName();
        char *name = latestFile( name1 );

        if( name==NULL )
          goto no_memory;

        capitalize( name );
        compileFile( name, i++<<24, miscInfo.exclude, cur.getType(), ttlSize,
                     cur.getDefZone(), cur.getDefNet(), cur.getDefNode() );
        delete name;
        delete name1;
      }
  }

  if( tentry )
  {
    window.centre( 8, Msg_ScrCmpBuilding );
    tzone = 0;
    tnet = 0;

    short prevZone( 0 ),
 	  prevNet( 0 ),
	  zoneNet( 0 );

    for( count=0; count<used; count++ )
    {
      NDLEntry *cur = nodeArray+count;

      if( cur->point )
        tpoint++;
      else
        tnode++;

      if( cur->zone!=prevZone )
      {
        tzone++;
        prevZone = cur->zone;

        if( zoneNet>maxNet )
        {
	  maxNet = zoneNet;
	  zoneNet = 0;
        }
      }

      if( cur->net!=prevNet )
      {
        tnet++;
        zoneNet++;
        prevNet = cur->net;
      }
    }

    if( zoneNet>maxNet )
      maxNet = zoneNet;

    window( 1, 8 ).clearLine();
  }

  long fSize = writeNdl( fileCounter ),
       ela = time( NULL )-start;

  log( Msg_InfoCmpTotalLines, tentry, ttlSize/1024, int(ela/60), int(ela)%60,
       (unsigned long)ttlSize/1024/(ela ? ela : 1 ), fSize );
  log( Msg_InfoCmpTotalNodes, lists, tzone, tregion, tnet, tnode, tpoint );

  delete nodeArray;
  delete cmpWindowPtr;
  _heapmin();
}

static volatile long tid=-1;

static void _Optlink cmpList( void * )
{
  registerExceptionHandler;

//  DosSetPriority( PRTYS_THREAD, 0, -miscInfo.priorityDelta, 0 );

  while( !systemIsReady )
    DosSleep( 500 );

  nodeList.lock();
  nodeList.compile();
  nodeList.reset();
  nodeList.unlock();
  Queue::needForRescan();
  tid = -1;
  deRegisterExceptionHandler;
}

void compiler()
{
  if( tid!=-1 )
  {
    log( Msg_CmpAlreadyActive );
    return;
  }

  tid=_beginthread( cmpList, 0, 40960, 0 );

  if( tid==-1 )
    log( Msg_ErrCmpThreadError, strError() );
  else
    log( Msg_ErrCmpThreadStarted, tid );
}

void stopCompile()
{
  if( tid==-1 )
    return;

  log( Msg_InfoWaitCompiler );
  showAction( Msg_ScrWaitCompiler );
  DosWaitThread( (PTID)&tid, DCWW_WAIT );
}
