NAME
    RISCOS::DynamicArea -- routines to manipulate Dynamic Area

SYNOPSIS
        use RISCOS::DynamicArea(dynamic_areas,name_dynamic_area);

        print join "\n", name_dynamic_area dynamic_areas';


DESCRIPTION
    `RISCOS::DynamicArea' provides routines to list and manipulate
    dynamic areas.

  Methods

    dynamic_areas
        `dynamic_areas' returns an list of the numbers of dynamic
        areas.

    name_dynamic_area <number>, ...
        `name_dynamic_area' converts dynamic area numbers to names.
        In scalar context it returns the name of the dynamic area
        given by the first argument. In array context it returns a
        list of dynamic area names corresponding to the argument
        list of dynamic area numbers.

    hash_dynamic_areas
        `hash_dynamic_areas' returns a reference to a hash of
        dynamic areas, keyed by name. If a name is unique to one
        dynamic area then the hash value is that dynamic area's
        number. If more than one dynamic area uses the same name,
        then the hash value for that area is `undef'. Use `exists'
        (see <perlfunc/exists>) to distinguish between names used
        for 0 or for multiple areas.

    delete_dynamic_area
        `delete_dynamic_area' deletes dynamic areas by number. In
        scalar context it attempts to delete a single area,
        returning 1 on success, 0 on failure. In array context it
        returns a list of the results of attempting to the list of
        area numbers passed to it.


BUGS
    None known.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

