NAME
    RISCOS::Chunkfile -- class for manipulating Acorn chunkfiles
    (AOF & ALF)

SYNOPSIS
        use RISCOS::Chunkfile;
        my $chunks = new RISCOS::Chunkfile $file;


DESCRIPTION
    `RISCOS::Chunkfile' provides a class for manipulating Acorn
    chunkfiles (*e.g.* *AOF* - ARM Object Format and *ALF* - Acorn
    Library Format). Currently this module is only used by the AOF
    and ALF modules.

    `RISCOS::Chunkfile' provides the following methods:

    new <array_ref>

    new <file>
        If passed a reference to an array it is assumed to be an
        array of `RISCOS::Chunk' objects to use as the file
        contents. Otherwise calls `RISCOS::File::load' to loads the
        file specified using and checks that it is a chunkfile.
        Hence *file* can be a filename, a reference to a filehandle,
        or a reference to a scalar which is used as the file's
        contents.

        If passed an array reference then this is used internally in
        the object, so should be created with the anonymous array
        constructor `[]' rather than a reference to a named array
        variable (see the "Common Mistakes" entry in the perldsc
        manpage).

        Returns undefined if there was an error, or the file
        contents are corrupt.

    Chunks
        Returns a reference to the array of `RISCOS::Chunk' objects,
        which are in the same order as found in the file. Treat this
        as read only. Changing the order or number of the chunks
        will confuse all the other lookup methods. If you need to
        manipulate the chunks pass this array back to `new' to
        create a new chunkfile object, and delete the old object
        (most simply by reusing the same named variable).

    Index
        Returns a reference to a hash which indexes the array of
        `RISCOS::Chunk' objects returned by `chunks'. The hash keys
        are the textual chunk IDs from the chunk header, the hash
        entries are reference to arrays containing the numbers of
        all the chunks where this ID can be found. For most IDs the
        array referenced will have only one entry (for example an
        `ALF' file will contain only one `LIB_DIRY' for the library
        directory) but where an ID occurs multiple times in the
        chunk header the reference will be to an array of the
        indexes of all these chunks (*e.g.* in an `ALF' library each
        object file is stored in a `LIB_DATA' chunk - `$index-
        '{LIB_DATA}> will be a reference to the IDs of all of the
        chunks containing object files).

    Lookup <chunkID>
        Returns a reference to the array of chunk indexes in the
        file where this chunk ID is present. Effectively the value
        from a lookup on the hash returned by `Keys', so will return
        undefined if no chunks in the file have this chunk ID.

    By_Number <chunk_index>
        Returns the `RISCOS::Chunk' object at *chunk_index* position
        in the file. Effectively the value from the array returned
        by `Chunks'.

    Single <chunkID>
        Returns the index of the only chunk in the file with ID
        *chunkID*, or undefined if zero or multiple chunks have this
        ID.

    Multiple <chunkID> {
        Returns the list of chunks in the file with ID *chunkID*, or
        an empty list if if less than two chunks have this ID.

    Chunk <chunkID>
        Returns the actual chunk of the only chunk in the file with
        ID *chunkID*, or undefined if zero or multiple chunks have
        this ID.

        Effectively a call to `By_Number' with the value returned
        from `Single'


EXAMPLE
    To display the index of chunks in a chunkfile

        use RISCOS::Chunkfile;

        my $chunks = new RISCOS::Chunkfile $file;

        print "$file:\n";

        foreach my $id (sort keys %{$chunks->Index})
        {
    	print "\t$id\t", join (' ', @{$chunks->Lookup ($id)}), "\n";
        }


BUGS
    At present there is no standard way to return errors/diagnostics
    to the caller. Currently `new' will call `warn' if warnings are
    turned on.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

