# Panda-URI

Panda-URI - fast URI framework. It conforms to RFC 3986.

# Synopsis

```cpp
URISP u = new URI("http://mysite.com:8080/my/path?a=b&c=d#myhash");
CHECK(u->scheme() == "http");
CHECK(u->host() == "mysite.com");
CHECK(u->port() == 8080);
CHECK(u->path() == "/my/path");
CHECK(u->query_string() == "a=b&c=d");
CHECK(u->fragment() == "myhash");

URISP v = new URI(*u); // clone
v->port(443);
CHECK(v->port() == 443);

v->fragment("any_else");
CHECK(v->fragment() == "any_else");

CHECK(v->to_string() == "http://mysite.com:443/my/path?a=b&c=d#any_else");
```

# Build and Install

Panda-URI is suppose to be built with CMake.
```
mkdir build
cd build
cmake ..
cmake --build .
cmake --build . --target install
```

It can be used either way as installed stand alone library or subdirectory. It depends on
* [panda-lib](https://github.com/CrazyPandaLimited/panda-lib)
Make sure that [find_package](https://cmake.org/cmake/help/latest/command/find_package.html) can find it.

Tests use [Catch2](https://github.com/catchorg/Catch2). Tests are not built by default. To enable testing set PANDA_URI_TESTS=ON.

Parser is generated by [Ragel](http://www.colm.net/open-source/ragel/). All generated sources are commited to git so you do not need Ragel to build Panda-URI.

If you have any error messages about Ragel or files `parser.cc` and `parser_ext.cc` not found then check your `git status`. `make clean` deletes generated files, so you should launch `git checkout .` to recover them.
