/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.jndi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.springframework.jndi.JndiTemplate;

public class ExpectedLookupTemplate
extends JndiTemplate {
    private final Map<String, Object> jndiObjects = new ConcurrentHashMap<String, Object>(16);

    public ExpectedLookupTemplate() {
    }

    public ExpectedLookupTemplate(String name, Object object) {
        this.addObject(name, object);
    }

    public void addObject(String name, Object object) {
        this.jndiObjects.put(name, object);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object object = this.jndiObjects.get(name);
        if (object == null) {
            throw new NamingException("Unexpected JNDI name '" + name + "': expecting " + this.jndiObjects.keySet());
        }
        return object;
    }
}

