/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;

public class MockHttpOutputMessage
implements HttpOutputMessage {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final HttpHeaders headers = new HttpHeaders();
    private final ByteArrayOutputStream body = new ByteArrayOutputStream(1024);

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public OutputStream getBody() throws IOException {
        return this.body;
    }

    public byte[] getBodyAsBytes() {
        return this.body.toByteArray();
    }

    public String getBodyAsString() {
        return this.getBodyAsString(DEFAULT_CHARSET);
    }

    public String getBodyAsString(Charset charset) {
        byte[] bytes = this.getBodyAsBytes();
        try {
            return new String(bytes, charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

