/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.json;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.JsonEncoding;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.PrettyPrinter;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.util.DefaultIndenter;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.ser.FilterProvider;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJacksonInputMessage;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.util.Assert;
import org.springframework.util.TypeUtils;

public abstract class AbstractJackson2HttpMessageConverter
extends AbstractGenericHttpMessageConverter<Object> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final MediaType TEXT_EVENT_STREAM = new MediaType("text", "event-stream");
    protected ObjectMapper objectMapper;
    private Boolean prettyPrint;
    private PrettyPrinter ssePrettyPrinter;

    protected AbstractJackson2HttpMessageConverter(ObjectMapper objectMapper) {
        this.init(objectMapper);
    }

    protected AbstractJackson2HttpMessageConverter(ObjectMapper objectMapper, MediaType supportedMediaType) {
        super(supportedMediaType);
        this.init(objectMapper);
    }

    protected AbstractJackson2HttpMessageConverter(ObjectMapper objectMapper, MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
        this.init(objectMapper);
    }

    protected void init(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.setDefaultCharset(DEFAULT_CHARSET);
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentObjectsWith(new DefaultIndenter("  ", "\ndata:"));
        this.ssePrettyPrinter = prettyPrinter;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull(objectMapper, "ObjectMapper must not be null");
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, (boolean)this.prettyPrint);
        }
    }

    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.canRead(clazz, null, mediaType);
    }

    @Override
    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        AtomicReference<Throwable> causeRef;
        if (!this.canRead(mediaType)) {
            return false;
        }
        JavaType javaType = this.getJavaType(type, contextClass);
        if (this.objectMapper.canDeserialize(javaType, causeRef = new AtomicReference<Throwable>())) {
            return true;
        }
        this.logWarningIfNecessary(javaType, causeRef.get());
        return false;
    }

    @Override
    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        if (!this.canWrite(mediaType)) {
            return false;
        }
        AtomicReference<Throwable> causeRef = new AtomicReference<Throwable>();
        if (this.objectMapper.canSerialize(clazz, causeRef)) {
            return true;
        }
        this.logWarningIfNecessary(clazz, causeRef.get());
        return false;
    }

    protected void logWarningIfNecessary(Type type, Throwable cause) {
        boolean debugLevel;
        if (cause == null) {
            return;
        }
        boolean bl = debugLevel = cause instanceof JsonMappingException && (cause.getMessage().startsWith("Can not find") || cause.getMessage().startsWith("Cannot find"));
        if (debugLevel ? this.logger.isDebugEnabled() : this.logger.isWarnEnabled()) {
            String msg = "Failed to evaluate Jackson " + (type instanceof JavaType ? "de" : "") + "serialization for type [" + type + "]";
            if (debugLevel) {
                this.logger.debug(msg, cause);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.warn(msg, cause);
            } else {
                this.logger.warn(msg + ": " + cause);
            }
        }
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(clazz, null);
        return this.readJavaType(javaType, inputMessage);
    }

    @Override
    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(type, contextClass);
        return this.readJavaType(javaType, inputMessage);
    }

    private Object readJavaType(JavaType javaType, HttpInputMessage inputMessage) {
        try {
            Class<?> deserializationView;
            if (inputMessage instanceof MappingJacksonInputMessage && (deserializationView = ((MappingJacksonInputMessage)inputMessage).getDeserializationView()) != null) {
                return this.objectMapper.readerWithView(deserializationView).forType(javaType).readValue(inputMessage.getBody());
            }
            return this.objectMapper.readValue(inputMessage.getBody(), javaType);
        }
        catch (JsonProcessingException ex) {
            throw new HttpMessageNotReadableException("JSON parse error: " + ex.getOriginalMessage(), ex);
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("I/O error while reading input message", ex);
        }
    }

    @Override
    protected void writeInternal(Object object, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType contentType = outputMessage.getHeaders().getContentType();
        JsonEncoding encoding = this.getJsonEncoding(contentType);
        JsonGenerator generator = this.objectMapper.getFactory().createGenerator(outputMessage.getBody(), encoding);
        try {
            ObjectWriter objectWriter;
            this.writePrefix(generator, object);
            Object value = object;
            Class<?> serializationView = null;
            FilterProvider filters = null;
            JavaType javaType = null;
            if (object instanceof MappingJacksonValue) {
                MappingJacksonValue container = (MappingJacksonValue)object;
                value = container.getValue();
                serializationView = container.getSerializationView();
                filters = container.getFilters();
            }
            if (type != null && value != null && TypeUtils.isAssignable(type, value.getClass())) {
                javaType = this.getJavaType(type, null);
            }
            ObjectWriter objectWriter2 = objectWriter = serializationView != null ? this.objectMapper.writerWithView(serializationView) : this.objectMapper.writer();
            if (filters != null) {
                objectWriter = objectWriter.with(filters);
            }
            if (javaType != null && javaType.isContainerType()) {
                objectWriter = objectWriter.forType(javaType);
            }
            SerializationConfig config = objectWriter.getConfig();
            if (contentType != null && contentType.isCompatibleWith(TEXT_EVENT_STREAM) && config.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
                objectWriter = objectWriter.with(this.ssePrettyPrinter);
            }
            objectWriter.writeValue(generator, value);
            this.writeSuffix(generator, object);
            generator.flush();
        }
        catch (JsonProcessingException ex) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getOriginalMessage(), ex);
        }
    }

    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
    }

    protected void writeSuffix(JsonGenerator generator, Object object) throws IOException {
    }

    protected JavaType getJavaType(Type type, Class<?> contextClass) {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        if (contextClass != null) {
            ResolvableType resolvedType = ResolvableType.forType(type);
            if (type instanceof TypeVariable) {
                ResolvableType resolvedTypeVariable = this.resolveVariable((TypeVariable)type, ResolvableType.forClass(contextClass));
                if (resolvedTypeVariable != ResolvableType.NONE) {
                    return typeFactory.constructType(resolvedTypeVariable.resolve());
                }
            } else if (type instanceof ParameterizedType && resolvedType.hasUnresolvableGenerics()) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < typeArguments.length; ++i) {
                    Type typeArgument = typeArguments[i];
                    if (typeArgument instanceof TypeVariable) {
                        ResolvableType resolvedTypeArgument = this.resolveVariable((TypeVariable)typeArgument, ResolvableType.forClass(contextClass));
                        if (resolvedTypeArgument != ResolvableType.NONE) {
                            generics[i] = resolvedTypeArgument.resolve();
                            continue;
                        }
                        generics[i] = ResolvableType.forType(typeArgument).resolve();
                        continue;
                    }
                    generics[i] = ResolvableType.forType(typeArgument).resolve();
                }
                return typeFactory.constructType(ResolvableType.forClassWithGenerics(resolvedType.getRawClass(), generics).getType());
            }
        }
        return typeFactory.constructType(type);
    }

    private ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
        ResolvableType resolvedType;
        if (contextType.hasGenerics() && (resolvedType = ResolvableType.forType(typeVariable, contextType)).resolve() != null) {
            return resolvedType;
        }
        ResolvableType superType = contextType.getSuperType();
        if (superType != ResolvableType.NONE && (resolvedType = this.resolveVariable(typeVariable, superType)).resolve() != null) {
            return resolvedType;
        }
        for (ResolvableType ifc : contextType.getInterfaces()) {
            resolvedType = this.resolveVariable(typeVariable, ifc);
            if (resolvedType.resolve() == null) continue;
            return resolvedType;
        }
        return ResolvableType.NONE;
    }

    protected JsonEncoding getJsonEncoding(MediaType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            Charset charset = contentType.getCharset();
            for (JsonEncoding encoding : JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }

    @Override
    protected MediaType getDefaultContentType(Object object) throws IOException {
        if (object instanceof MappingJacksonValue) {
            object = ((MappingJacksonValue)object).getValue();
        }
        return super.getDefaultContentType(object);
    }

    @Override
    protected Long getContentLength(Object object, MediaType contentType) throws IOException {
        if (object instanceof MappingJacksonValue) {
            object = ((MappingJacksonValue)object).getValue();
        }
        return super.getContentLength(object, contentType);
    }
}

