/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.api.util.Strings;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.exception.StreamingException;
import org.apache.kylin.stream.core.source.StreamingSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSourceConfigManager {
    public static final Serializer<StreamingSourceConfig> STREAMING_SERIALIZER = new JsonSerializer<StreamingSourceConfig>(StreamingSourceConfig.class);
    private static final Logger logger = LoggerFactory.getLogger(StreamingSourceConfigManager.class);
    private static final ConcurrentHashMap<KylinConfig, StreamingSourceConfigManager> CACHE = new ConcurrentHashMap();
    private KylinConfig config;

    private StreamingSourceConfigManager(KylinConfig config) throws IOException {
        this.config = config;
    }

    public static StreamingSourceConfigManager getInstance(KylinConfig config) {
        StreamingSourceConfigManager r = CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<StreamingSourceConfigManager> clazz = StreamingSourceConfigManager.class;
        synchronized (StreamingSourceConfigManager.class) {
            r = CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new StreamingSourceConfigManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one streamingManager singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init StreamingManager from " + config, e);
            }
        }
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public List<StreamingSourceConfig> listAllStreaming() throws IOException {
        ArrayList<StreamingSourceConfig> results = Lists.newArrayList();
        ResourceStore store = this.getStore();
        logger.info("Load all streaming metadata from folder " + store.getReadableResourcePath("/streaming_v2"));
        List<String> paths = store.collectResourceRecursively("/streaming_v2", ".json");
        for (String path : paths) {
            StreamingSourceConfig streamingSourceConfig;
            try {
                streamingSourceConfig = this.loadStreamingConfigAt(path);
            }
            catch (Exception e) {
                logger.error("Error loading streaming desc " + path, e);
                continue;
            }
            if (!path.equals(streamingSourceConfig.getResourcePath()) && !path.equals(streamingSourceConfig.getResourcePathWithProjName())) {
                logger.error("Skip suspicious desc at " + path + ", " + streamingSourceConfig + " should be at " + streamingSourceConfig.getResourcePath());
                continue;
            }
            results.add(streamingSourceConfig);
        }
        logger.debug("Loaded " + results.size() + " StreamingSourceConfig(s)");
        return results;
    }

    public StreamingSourceConfig reloadStreamingConfigLocal(String name, String projectName) throws IOException {
        if (Strings.isEmpty((String)name) || Strings.isEmpty((String)projectName)) {
            throw new StreamingException(String.format(Locale.ROOT, "the table name %s or project name %s is null", name, projectName));
        }
        String path = StreamingSourceConfig.concatResourcePathWithProjName(name, projectName);
        StreamingSourceConfig config = this.loadStreamingConfigAt(path);
        if (config == null && (config = this.loadStreamingConfigAt(path = StreamingSourceConfig.concatResourcePath(name))) != null) {
            config.setProjectName(projectName);
            this.removeStreamingConfig(config);
            this.saveStreamingConfig(config);
        }
        return config;
    }

    public void removeStreamingConfig(StreamingSourceConfig streamingSourceConfig) throws IOException {
        String path = streamingSourceConfig.getResourcePathWithProjName();
        if (this.loadStreamingConfigAt(path) != null) {
            this.getStore().deleteResource(path);
        } else {
            path = streamingSourceConfig.getResourcePath();
            this.getStore().deleteResource(path);
        }
    }

    public StreamingSourceConfig getConfig(String name, String projectName) {
        name = name.toUpperCase(Locale.ROOT);
        try {
            return this.reloadStreamingConfigLocal(name, projectName);
        }
        catch (IOException e) {
            throw new StreamingException(e);
        }
    }

    public StreamingSourceConfig getConfigMustWithProject(String name, String projectName) {
        if (Strings.isEmpty((String)(name = name.toUpperCase(Locale.ROOT))) || Strings.isEmpty((String)projectName)) {
            throw new StreamingException(String.format(Locale.ROOT, "the table name %s or project name %s is null", name, projectName));
        }
        String path = StreamingSourceConfig.concatResourcePathWithProjName(name, projectName);
        try {
            return this.loadStreamingConfigAt(path);
        }
        catch (IOException e) {
            throw new StreamingException(e);
        }
    }

    public StreamingSourceConfig updateStreamingConfig(StreamingSourceConfig streamingSourceConfig) throws IOException {
        if (streamingSourceConfig.getUuid() == null || streamingSourceConfig.getName() == null) {
            throw new IllegalArgumentException("SteamingConfig Illegal.");
        }
        this.removeStreamingConfig(streamingSourceConfig);
        String path = streamingSourceConfig.getResourcePathWithProjName();
        this.getStore().putResource(path, streamingSourceConfig, System.currentTimeMillis(), STREAMING_SERIALIZER);
        StreamingSourceConfig newStreamingSourceConfig = this.loadStreamingConfigAt(path);
        return newStreamingSourceConfig;
    }

    public StreamingSourceConfig saveStreamingConfig(StreamingSourceConfig streamingSourceConfig) throws IOException {
        if (streamingSourceConfig == null || StringUtils.isEmpty(streamingSourceConfig.getName())) {
            throw new IllegalArgumentException();
        }
        String path = streamingSourceConfig.getResourcePathWithProjName();
        this.getStore().putResource(path, streamingSourceConfig, System.currentTimeMillis(), StreamingSourceConfig.SERIALIZER);
        return streamingSourceConfig;
    }

    private StreamingSourceConfig loadStreamingConfigAt(String path) throws IOException {
        ResourceStore store = this.getStore();
        StreamingSourceConfig streamingDesc = store.getResource(path, STREAMING_SERIALIZER);
        if (streamingDesc == null) {
            return null;
        }
        if (StringUtils.isBlank(streamingDesc.getName())) {
            throw new IllegalStateException("StreamingSourceConfig name must not be blank");
        }
        return streamingDesc;
    }
}

