/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.query.IStreamingSearchResult;
import org.apache.kylin.stream.core.query.ResultCollector;
import org.apache.kylin.stream.core.query.StreamingQueryProfile;
import org.apache.kylin.stream.core.storage.Record;
import org.apache.kylin.stream.core.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadsResultCollector
extends ResultCollector {
    private static Logger logger = LoggerFactory.getLogger(MultiThreadsResultCollector.class);
    private static ThreadPoolExecutor scannerThreadPool;
    private static int MAX_RUNNING_THREAD_COUNT;
    private long deadline;
    private String queryId;
    private AtomicBoolean cancelFlag = new AtomicBoolean(false);
    private Semaphore workersSemaphore;
    private AtomicInteger notCompletedWorkers;
    private final BlockingQueue<Record> recordCachePool = new LinkedBlockingQueue<Record>(10000);

    public MultiThreadsResultCollector(int numOfWorkers, long deadline) {
        this.workersSemaphore = new Semaphore(numOfWorkers);
        this.deadline = deadline;
        this.queryId = StreamingQueryProfile.get().getQueryId();
    }

    @Override
    public Iterator<Record> iterator() {
        this.notCompletedWorkers = new AtomicInteger(this.searchResults.size());
        final Thread masterThread = new Thread((Runnable)new WorkSubmitter(), "MultiThreadsResultCollector_" + this.queryId);
        masterThread.start();
        int batchSize = 100;
        final long startTime = System.currentTimeMillis();
        return new Iterator<Record>(){
            List<Record> recordList = Lists.newArrayListWithExpectedSize(100);
            Iterator<Record> internalIT = this.recordList.iterator();

            @Override
            public boolean hasNext() {
                boolean exits;
                boolean bl = exits = this.internalIT.hasNext() || !MultiThreadsResultCollector.this.recordCachePool.isEmpty();
                if (!exits) {
                    while (MultiThreadsResultCollector.this.notCompletedWorkers.get() > 0) {
                        Thread.yield();
                        if (System.currentTimeMillis() > MultiThreadsResultCollector.this.deadline) {
                            masterThread.interrupt();
                            MultiThreadsResultCollector.this.cancelFlag.set(true);
                            MultiThreadsResultCollector.this.recordCachePool.clear();
                            logger.warn("Beyond the deadline for {}.", (Object)MultiThreadsResultCollector.this.queryId);
                            throw new RuntimeException("Timeout when iterate search result");
                        }
                        if (!this.internalIT.hasNext() && MultiThreadsResultCollector.this.recordCachePool.isEmpty()) continue;
                        return true;
                    }
                }
                return exits;
            }

            @Override
            public Record next() {
                try {
                    if (System.currentTimeMillis() > MultiThreadsResultCollector.this.deadline) {
                        throw new RuntimeException("Timeout when iterate search result");
                    }
                    if (!this.internalIT.hasNext()) {
                        this.recordList.clear();
                        Record one = (Record)MultiThreadsResultCollector.this.recordCachePool.poll(MultiThreadsResultCollector.this.deadline - startTime, TimeUnit.MILLISECONDS);
                        if (one == null) {
                            masterThread.interrupt();
                            MultiThreadsResultCollector.this.cancelFlag.set(true);
                            MultiThreadsResultCollector.this.recordCachePool.clear();
                            logger.debug("Exceeded the deadline for {}.", (Object)MultiThreadsResultCollector.this.queryId);
                            throw new RuntimeException("Timeout when iterate search result");
                        }
                        this.recordList.add(one);
                        MultiThreadsResultCollector.this.recordCachePool.drainTo(this.recordList, 99);
                        this.internalIT = this.recordList.iterator();
                    }
                    return this.internalIT.next();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Error when waiting queue", e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not support");
            }
        };
    }

    public static boolean isFullUp() {
        boolean occupied;
        boolean bl = occupied = scannerThreadPool.getActiveCount() >= MAX_RUNNING_THREAD_COUNT;
        if (occupied) {
            logger.debug("ThreadPool {} is full .", (Object)scannerThreadPool);
        }
        return occupied;
    }

    static {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        MAX_RUNNING_THREAD_COUNT = config.getStreamingReceiverQueryMaxThreads();
        int coreThreads = config.getStreamingReceiverQueryCoreThreads();
        scannerThreadPool = new ThreadPoolExecutor(coreThreads, MAX_RUNNING_THREAD_COUNT, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("query-worker"));
    }

    private class WorkSubmitter
    implements Runnable {
        private WorkSubmitter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Future<?>> futureList = Lists.newArrayListWithExpectedSize(MultiThreadsResultCollector.this.searchResults.size());
            int cancelTimes = 0;
            try {
                for (IStreamingSearchResult iStreamingSearchResult : MultiThreadsResultCollector.this.searchResults) {
                    Future<?> f = scannerThreadPool.submit(new ResultIterateWorker(iStreamingSearchResult));
                    futureList.add(f);
                    MultiThreadsResultCollector.this.workersSemaphore.acquire();
                }
                while (MultiThreadsResultCollector.this.notCompletedWorkers.get() > 0) {
                    Thread.sleep(100L);
                    if (!MultiThreadsResultCollector.this.cancelFlag.get() && !Thread.currentThread().isInterrupted()) continue;
                    break;
                }
            }
            catch (InterruptedException inter) {
                logger.warn("Interrupted", inter);
            }
            finally {
                for (Future future : futureList) {
                    if (future.isCancelled() && future.isDone() || !future.cancel(true)) continue;
                    ++cancelTimes;
                }
            }
            logger.debug("Finish MultiThreadsResultCollector for queryId {}, cancel {}. Current thread pool: {}.", MultiThreadsResultCollector.this.queryId, cancelTimes, scannerThreadPool);
        }
    }

    private class ResultIterateWorker
    implements Runnable {
        IStreamingSearchResult result;

        public ResultIterateWorker(IStreamingSearchResult result) {
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long offserTimeout = 0L;
            try {
                this.result.startRead();
                for (Record record : this.result) {
                    offserTimeout = MultiThreadsResultCollector.this.deadline - System.currentTimeMillis();
                    if (MultiThreadsResultCollector.this.recordCachePool.offer(record.copy(), offserTimeout, TimeUnit.MILLISECONDS)) continue;
                    logger.warn("Timeout when offer to recordCachePool, deadline: {}, offser Timeout: {}", (Object)MultiThreadsResultCollector.this.deadline, (Object)offserTimeout);
                    break;
                }
                this.result.endRead();
            }
            catch (InterruptedException inter) {
                logger.debug("Cancelled scan streaming segment", inter);
            }
            catch (Exception e) {
                logger.warn("Error when iterate search result", e);
            }
            finally {
                MultiThreadsResultCollector.this.notCompletedWorkers.decrementAndGet();
                MultiThreadsResultCollector.this.workersSemaphore.release();
            }
        }
    }
}

