/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.storage.hbase.HBaseConnection;

public class PingHBaseCLI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String hbaseTable = args[0];
        System.out.println("Hello friend.");
        Configuration hconf = HBaseConnection.getCurrentHBaseConfiguration();
        if (User.isHBaseSecurityEnabled((Configuration)hconf)) {
            try {
                System.out.println("--------------Getting kerberos credential for user " + UserGroupInformation.getCurrentUser().getUserName());
                TokenUtil.obtainAndCacheToken((Configuration)hconf, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.out.println("--------------Error while getting kerberos credential for user " + UserGroupInformation.getCurrentUser().getUserName());
            }
        }
        Scan scan = new Scan();
        int limit = 20;
        Connection conn = null;
        Table table = null;
        ResultScanner scanner = null;
        try {
            conn = ConnectionFactory.createConnection((Configuration)hconf);
            table = conn.getTable(TableName.valueOf((String)hbaseTable));
            scanner = table.getScanner(scan);
            int count = 0;
            for (Result r : scanner) {
                byte[] rowkey = r.getRow();
                System.out.println(Bytes.toStringBinary(rowkey));
                if (++count != limit) continue;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(scanner);
            IOUtils.closeQuietly(table);
            IOUtils.closeQuietly((Closeable)conn);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)scanner);
        IOUtils.closeQuietly((Closeable)table);
        IOUtils.closeQuietly((Closeable)conn);
    }
}

