/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.kylin.common.KylinConfig;

public class VersionUtil {
    public static final String KYLIN_VERSION = "kylin.version";

    public static void loadKylinVersion() {
        String version = System.getProperty(KYLIN_VERSION);
        if (version != null) {
            return;
        }
        File vfile = VersionUtil.getDefaultVersionFile();
        if (vfile.exists()) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(vfile), StandardCharsets.UTF_8));){
                String l = in.readLine();
                if (l != null) {
                    System.setProperty(KYLIN_VERSION, l);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String getKylinVersion() {
        String version = System.getProperty(KYLIN_VERSION);
        return version == null ? "" : version;
    }

    public static File getDefaultVersionFile() {
        File kylinHome = KylinConfig.getKylinHomeAtBestEffort();
        return new File(kylinHome, "VERSION");
    }
}

