/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.prepost;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.AbstractMethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PostInvocationAttribute;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PreFilter;
import org.springframework.security.access.prepost.PreInvocationAttribute;
import org.springframework.security.access.prepost.PrePostInvocationAttributeFactory;
import org.springframework.util.ClassUtils;

public class PrePostAnnotationSecurityMetadataSource
extends AbstractMethodSecurityMetadataSource {
    private final PrePostInvocationAttributeFactory attributeFactory;

    public PrePostAnnotationSecurityMetadataSource(PrePostInvocationAttributeFactory attributeFactory) {
        this.attributeFactory = attributeFactory;
    }

    @Override
    public Collection<ConfigAttribute> getAttributes(Method method, Class<?> targetClass) {
        PostInvocationAttribute post;
        if (method.getDeclaringClass() == Object.class) {
            return Collections.emptyList();
        }
        this.logger.trace((Object)("Looking for Pre/Post annotations for method '" + method.getName() + "' on target class '" + targetClass + "'"));
        PreFilter preFilter = this.findAnnotation(method, targetClass, PreFilter.class);
        PreAuthorize preAuthorize = this.findAnnotation(method, targetClass, PreAuthorize.class);
        PostFilter postFilter = this.findAnnotation(method, targetClass, PostFilter.class);
        PostAuthorize postAuthorize = this.findAnnotation(method, targetClass, PostAuthorize.class);
        if (preFilter == null && preAuthorize == null && postFilter == null && postAuthorize == null) {
            this.logger.trace((Object)"No expression annotations found");
            return Collections.emptyList();
        }
        String preFilterAttribute = preFilter == null ? null : preFilter.value();
        String filterObject = preFilter == null ? null : preFilter.filterTarget();
        String preAuthorizeAttribute = preAuthorize == null ? null : preAuthorize.value();
        String postFilterAttribute = postFilter == null ? null : postFilter.value();
        String postAuthorizeAttribute = postAuthorize == null ? null : postAuthorize.value();
        ArrayList<ConfigAttribute> attrs = new ArrayList<ConfigAttribute>(2);
        PreInvocationAttribute pre = this.attributeFactory.createPreInvocationAttribute(preFilterAttribute, filterObject, preAuthorizeAttribute);
        if (pre != null) {
            attrs.add(pre);
        }
        if ((post = this.attributeFactory.createPostInvocationAttribute(postFilterAttribute, postAuthorizeAttribute)) != null) {
            attrs.add(post);
        }
        attrs.trimToSize();
        return attrs;
    }

    @Override
    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    private <A extends Annotation> A findAnnotation(Method method, Class<?> targetClass, Class<A> annotationClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod(method, targetClass);
        A annotation = AnnotationUtils.findAnnotation(specificMethod, annotationClass);
        if (annotation != null) {
            this.logger.debug((Object)(annotation + " found on specific method: " + specificMethod));
            return annotation;
        }
        if (specificMethod != method && (annotation = AnnotationUtils.findAnnotation(method, annotationClass)) != null) {
            this.logger.debug((Object)(annotation + " found on: " + method));
            return annotation;
        }
        annotation = AnnotationUtils.findAnnotation(specificMethod.getDeclaringClass(), annotationClass);
        if (annotation != null) {
            this.logger.debug((Object)(annotation + " found on: " + specificMethod.getDeclaringClass().getName()));
            return annotation;
        }
        return null;
    }
}

