/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.migration;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryInfoSerializer;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfoManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.dict.lookup.SnapshotTableSerializer;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.KylinUserService;
import org.apache.kylin.storage.hbase.util.DeployCoprocessorCLI;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.apache.kylin.tool.migration.ClusterUtil;
import org.apache.kylin.tool.migration.CompatibilityCheckRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DstClusterUtil
extends ClusterUtil {
    private static final Logger logger = LoggerFactory.getLogger(DstClusterUtil.class);
    public static final String hbaseSubDir = "migration/hbase/data/default/";
    private final String hbaseDataDirQualified;
    private final String hbaseDataDir;
    private final boolean ifExecute;

    public DstClusterUtil(String configURI, boolean ifExecute) throws IOException {
        this(configURI, true, true, ifExecute);
    }

    public DstClusterUtil(String configURI, boolean ifJobFSHAEnabled, boolean ifHBaseFSHAEnabled, boolean ifExecute) throws IOException {
        super(configURI, ifJobFSHAEnabled, ifHBaseFSHAEnabled);
        this.hbaseDataDirQualified = this.hbaseHdfsWorkingDirectoryQualified + hbaseSubDir;
        this.hbaseDataDir = this.hdfsWorkingDirectory + hbaseSubDir;
        this.ifExecute = ifExecute;
    }

    @Override
    public ProjectInstance getProject(String projName) throws IOException {
        return this.resourceStore.getResource(ProjectInstance.concatResourcePath(projName), ProjectManager.PROJECT_SERIALIZER);
    }

    @Override
    public DictionaryInfo getDictionaryInfo(String dictPath) throws IOException {
        return this.resourceStore.getResource(dictPath, DictionaryInfoSerializer.FULL_SERIALIZER);
    }

    @Override
    public SnapshotTable getSnapshotTable(String snapshotPath) throws IOException {
        return this.resourceStore.getResource(snapshotPath, SnapshotTableSerializer.FULL_SERIALIZER);
    }

    @Override
    public String getRootDirQualifiedOfHTable(String tableName) {
        return this.hbaseDataDirQualified + tableName;
    }

    private String getRootDirOfHTable(String tableName) {
        return this.hbaseDataDir + tableName;
    }

    public boolean exists(String resPath) throws IOException {
        return this.resourceStore.exists(resPath);
    }

    public void checkCompatibility(String projectName, Set<TableDesc> tableSet, DataModelDesc modelDesc, boolean ifHiveCheck) throws IOException {
        ArrayList tableDataList = Lists.newArrayList();
        for (TableDesc table : tableSet) {
            tableDataList.add(JsonUtil.writeValueAsIndentString(table));
        }
        String modelDescData = JsonUtil.writeValueAsIndentString(modelDesc);
        CompatibilityCheckRequest request = new CompatibilityCheckRequest();
        request.setProjectName(projectName);
        request.setTableDescDataList(tableDataList);
        request.setModelDescData(modelDescData);
        String jsonRequest = JsonUtil.writeValueAsIndentString(request);
        this.restClient.checkCompatibility(jsonRequest, ifHiveCheck);
    }

    public void saveProject(ProjectInstance projInstance) throws IOException {
        if (this.ifExecute) {
            this.putMetaResource(ProjectInstance.concatResourcePath(projInstance.getName()), projInstance, ProjectManager.PROJECT_SERIALIZER);
        }
        logger.info("saved project {}", (Object)projInstance);
    }

    public void saveHybrid(HybridInstance hybridInstance) throws IOException {
        if (this.ifExecute) {
            this.putMetaResource(HybridInstance.concatResourcePath(hybridInstance.getName()), hybridInstance, HybridManager.HYBRID_SERIALIZER);
        }
        logger.info("saved hybrid {}", (Object)hybridInstance);
    }

    public void saveTableDesc(TableDesc table) throws IOException {
        if (this.ifExecute) {
            this.putMetaResource(TableDesc.concatResourcePath(table.getIdentity(), table.getProject()), table, TableMetadataManager.TABLE_SERIALIZER);
        }
        logger.info("saved table {}", (Object)table);
    }

    public void saveModelDesc(DataModelDesc modelDesc) throws IOException {
        if (this.ifExecute) {
            this.putMetaResource(DataModelDesc.concatResourcePath(modelDesc.getName()), modelDesc, DataModelManager.MODELDESC_SERIALIZER);
        }
        logger.info("saved model {}", (Object)modelDesc);
    }

    public void saveCubeDesc(CubeDesc cubeDesc) throws IOException {
        if (this.ifExecute) {
            this.putMetaResource(CubeDesc.concatResourcePath(cubeDesc.getName()), cubeDesc, CubeDescManager.CUBE_DESC_SERIALIZER);
        }
        logger.info("saved cube desc {}", (Object)cubeDesc);
    }

    public void saveCubeInstance(CubeInstance cube) throws IOException {
        if (this.ifExecute) {
            this.putMetaResource(CubeInstance.concatResourcePath(cube.getName()), cube, CubeManager.CUBE_SERIALIZER);
        }
        logger.info("saved cube instance {}", (Object)cube);
    }

    public String saveDictionary(DictionaryInfo dictInfo) throws IOException {
        String dupDict = this.checkDupDict(dictInfo);
        if (dupDict == null) {
            this.putMetaResource(dictInfo.getResourcePath(), dictInfo, DictionaryInfoSerializer.FULL_SERIALIZER);
            logger.info("saved dictionary {}", (Object)dictInfo.getResourcePath());
        }
        return dupDict;
    }

    private String checkDupDict(DictionaryInfo dictInfo) throws IOException {
        NavigableSet<String> existings = this.resourceStore.listResources(dictInfo.getResourceDir());
        if (existings == null) {
            return null;
        }
        logger.info("{} existing dictionaries of the same column", (Object)existings.size());
        if (existings.size() > 100) {
            logger.warn("Too many dictionaries under {}, dict count: {}", (Object)dictInfo.getResourceDir(), (Object)existings.size());
        }
        for (String existing : existings) {
            DictionaryInfo existingInfo = this.getDictionaryInfo(existing);
            if (existingInfo == null || !dictInfo.getDictionaryObject().equals(existingInfo.getDictionaryObject())) continue;
            return existing;
        }
        return null;
    }

    public void saveSnapshotTable(SnapshotTable snapshotTable) throws IOException {
        this.putMetaResource(snapshotTable.getResourcePath(), snapshotTable, SnapshotTableSerializer.FULL_SERIALIZER);
        logger.info("saved snapshot table {}", (Object)snapshotTable.getResourcePath());
    }

    public void saveExtSnapshotTableInfo(ExtTableSnapshotInfo extTableSnapshotInfo) throws IOException {
        this.putMetaResource(extTableSnapshotInfo.getResourcePath(), extTableSnapshotInfo, ExtTableSnapshotInfoManager.SNAPSHOT_SERIALIZER);
        logger.info("saved ext snapshot table info {}", (Object)extTableSnapshotInfo.getResourcePath());
    }

    public void saveUserInfo(String userKey, ManagedUser user) throws IOException {
        if (this.ifExecute) {
            this.putMetaResource(userKey, user, KylinUserService.SERIALIZER);
        }
        logger.info("saved user info {}", (Object)userKey);
    }

    private <T extends RootPersistentEntity> void putMetaResource(String resPath, T obj, Serializer<T> serializer) throws IOException {
        this.putMetaResource(resPath, obj, serializer, true);
    }

    public <T extends RootPersistentEntity> void putMetaResource(String resPath, T obj, Serializer<T> serializer, boolean withoutCheck) throws IOException {
        if (this.ifExecute) {
            if (withoutCheck) {
                this.resourceStore.putResource(resPath, obj, System.currentTimeMillis(), serializer);
            } else {
                this.resourceStore.checkAndPutResource(resPath, obj, System.currentTimeMillis(), serializer);
            }
        }
        logger.info("saved resource {}", (Object)resPath);
    }

    public void putResource(String resPath, RawResource res) throws IOException {
        if (this.ifExecute) {
            this.resourceStore.putResource(resPath, res.content(), res.lastModified());
        }
        logger.info("saved resource {}", (Object)resPath);
    }

    public boolean checkExist(TableName htableName, CubeSegment segment) throws IOException {
        if (!this.htableExists(htableName)) {
            return false;
        }
        Table table = this.hbaseConn.getTable(htableName);
        HTableDescriptor tableDesc = table.getTableDescriptor();
        if (segment.toString().equals(tableDesc.getValue("SEGMENT"))) {
            if (this.hbaseAdmin.isTableEnabled(htableName)) {
                return true;
            }
            this.hbaseAdmin.deleteTable(htableName);
            logger.info("htable {} is deleted", (Object)htableName);
            return false;
        }
        throw new RuntimeException("htable name " + htableName + " has been used by " + tableDesc.getValue("SEGMENT"));
    }

    public void deleteHTable(String tableName) throws IOException {
        TableName htableName = TableName.valueOf((String)tableName);
        if (this.hbaseAdmin.isTableEnabled(htableName)) {
            this.hbaseAdmin.disableTable(htableName);
        }
        this.hbaseAdmin.deleteTable(htableName);
        logger.info("htable {} is deleted", (Object)htableName);
    }

    public boolean htableExists(TableName htableName) throws IOException {
        return this.hbaseAdmin.tableExists(htableName);
    }

    public void resetTableHost(HTableDescriptor tableDesc) {
        tableDesc.setValue("KYLIN_HOST", this.kylinConfig.getMetadataUrlPrefix());
    }

    public void deployCoprocessor(HTableDescriptor tableDesc, String localCoprocessorJar) throws IOException {
        List existingCoprocessors = tableDesc.getCoprocessors();
        for (String existingCoprocessor : existingCoprocessors) {
            tableDesc.removeCoprocessor(existingCoprocessor);
        }
        Path hdfsCoprocessorJar = DeployCoprocessorCLI.uploadCoprocessorJar(localCoprocessorJar, this.hbaseFS, this.hdfsWorkingDirectory, null);
        if (User.isHBaseSecurityEnabled((Configuration)this.hbaseConf)) {
            tableDesc.addCoprocessor("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
        }
        DeployCoprocessorCLI.addCoprocessorOnHTable(tableDesc, hdfsCoprocessorJar);
        logger.info("deployed hbase table {} with coprocessor.", (Object)tableDesc.getTableName());
    }

    public void createTable(HTableDescriptor tableDesc, byte[][] splitKeys) throws IOException {
        this.hbaseAdmin.createTable(tableDesc, splitKeys);
        logger.info("htable {} successfully created!", (Object)tableDesc.getTableName());
    }

    public void copyInitOnJobCluster(Path path) throws IOException {
        DstClusterUtil.copyInit(this.jobFS, path);
    }

    public void copyInitOnHBaseCluster(Path path) throws IOException {
        DstClusterUtil.copyInit(this.hbaseFS, path);
    }

    public static void copyInit(FileSystem fs, Path path) throws IOException {
        Path pathP = (path = Path.getPathWithoutSchemeAndAuthority((Path)path)).getParent();
        if (!fs.exists(pathP)) {
            fs.mkdirs(pathP);
        }
        if (fs.exists(path)) {
            logger.warn("path {} already existed and will be deleted", (Object)path);
            HadoopUtil.deletePath(fs.getConf(), path);
        }
    }

    public void bulkLoadTable(String tableName) throws Exception {
        FileStatus[] regionFiles;
        Path rootPathOfTable = new Path(this.getRootDirOfHTable(tableName));
        for (FileStatus regionFileStatus : regionFiles = this.hbaseFS.listStatus(rootPathOfTable, new PathFilter(){

            public boolean accept(Path path) {
                return !path.getName().startsWith(".");
            }
        })) {
            ToolRunner.run((Tool)new LoadIncrementalHFiles(this.hbaseConf), (String[])new String[]{regionFileStatus.getPath().toString(), tableName});
        }
        logger.info("succeed to migrate htable {}", (Object)tableName);
    }

    public void updateMeta() {
        if (this.ifExecute) {
            try {
                logger.info("update meta cache for {}", (Object)this.restClient);
                this.restClient.announceWipeCache("all", Broadcaster.Event.UPDATE.getType(), "all");
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }
}

