/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.shaded.com.google.common.base.Predicate;
import org.apache.kylin.shaded.com.google.common.collect.Iterables;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceManager;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleanupJob
extends AbstractApplication {
    protected static final Option OPTION_DELETE;
    protected static final Option OPTION_FORCE;
    protected static final Option THREAD_NUM;
    protected static final Logger logger;
    protected final KylinConfig config;
    protected final FileSystem hbaseFs;
    protected final FileSystem defaultFs;
    protected final ExecutableManager executableManager;
    protected boolean delete = false;
    protected boolean force = false;
    protected int threadsNum = 1;
    private List<String> hiveGarbageTables = Collections.emptyList();
    private List<String> hbaseGarbageTables = Collections.emptyList();
    private List<String> hdfsGarbageFiles = Collections.emptyList();
    private long hdfsGarbageFileBytes = 0L;

    public StorageCleanupJob() throws IOException {
        this(KylinConfig.getInstanceFromEnv(), HadoopUtil.getWorkingFileSystem(), HBaseConnection.getFileSystemInHBaseCluster(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory()));
    }

    protected StorageCleanupJob(KylinConfig config, FileSystem defaultFs, FileSystem hbaseFs) {
        this.config = config;
        this.defaultFs = defaultFs;
        this.hbaseFs = hbaseFs;
        this.executableManager = ExecutableManager.getInstance(config);
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public List<String> getHiveGarbageTables() {
        return this.hiveGarbageTables;
    }

    public List<String> getHbaseGarbageTables() {
        return this.hbaseGarbageTables;
    }

    public List<String> getHdfsGarbageFiles() {
        return this.hdfsGarbageFiles;
    }

    public long getHdfsFileGarbageBytes() {
        return this.hdfsGarbageFileBytes;
    }

    @Override
    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DELETE);
        options.addOption(OPTION_FORCE);
        options.addOption(THREAD_NUM);
        return options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        logger.info("options: '" + optionsHelper.getOptionsAsString() + "'");
        logger.info("delete option value: '" + optionsHelper.getOptionValue(OPTION_DELETE) + "'");
        logger.info("force option value: '" + optionsHelper.getOptionValue(OPTION_FORCE) + "'");
        logger.info("thread option value: '" + optionsHelper.getOptionValue(THREAD_NUM) + "'");
        this.delete = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_DELETE));
        this.force = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_FORCE));
        try {
            String threads = optionsHelper.getOptionValue(THREAD_NUM);
            if (threads != null) {
                this.threadsNum = Integer.parseInt(threads);
            }
        }
        catch (Exception e) {
            logger.info("Failed to parse value: {} for thread option: {}", (Object)optionsHelper.getOptionValue(THREAD_NUM), (Object)THREAD_NUM);
        }
        this.cleanup();
    }

    public void cleanup() throws Exception {
        boolean error = false;
        try {
            this.cleanUnusedIntermediateHiveTable();
        }
        catch (Exception e) {
            logger.warn("cleanUnusedIntermediateHiveTable() error", e);
            error = true;
        }
        try {
            this.cleanUnusedHBaseTables();
        }
        catch (Exception e) {
            logger.warn("cleanUnusedHBaseTables() error", e);
            error = true;
        }
        try {
            this.cleanUnusedHdfsFiles();
        }
        catch (Exception e) {
            logger.warn("cleanUnusedHdfsFiles() error", e);
            error = true;
        }
        if (error) {
            throw new Exception("clean job has exception");
        }
    }

    protected void cleanUnusedHBaseTables() throws IOException {
        if ("hbase".equals(this.config.getStorageUrl().getScheme()) && !"".equals(this.config.getMetadataUrl().getScheme())) {
            int deleteTimeoutMin = 2;
            try {
                Class<?> hbaseCleanUpUtil = Class.forName("org.apache.kylin.rest.job.StorageCleanJobHbaseUtil");
                Method cleanUnusedHBaseTables = hbaseCleanUpUtil.getDeclaredMethod("cleanUnusedHBaseTables", Boolean.TYPE, Integer.TYPE, Integer.TYPE);
                this.hbaseGarbageTables = (List)cleanUnusedHBaseTables.invoke(hbaseCleanUpUtil, this.delete, 2, this.threadsNum);
            }
            catch (Throwable e) {
                logger.error("Error during HBase clean up", e);
            }
        }
    }

    private void cleanUnusedHdfsFiles() throws IOException {
        UnusedHdfsFileCollector collector = new UnusedHdfsFileCollector();
        this.collectUnusedHdfsFiles(collector);
        if (collector.list.isEmpty()) {
            logger.info("No HDFS files to clean up");
            return;
        }
        long garbageBytes = 0L;
        ArrayList<String> garbageList = new ArrayList<String>();
        for (Pair pair : collector.list) {
            FileSystem fs = (FileSystem)pair.getKey();
            String path = (String)pair.getValue();
            try {
                garbageList.add(path);
                ContentSummary sum = fs.getContentSummary(new Path(path));
                if (sum != null) {
                    garbageBytes += sum.getLength();
                }
                if (this.delete) {
                    logger.info("Deleting HDFS path " + path);
                    fs.delete(new Path(path), true);
                    continue;
                }
                logger.info("Dry run, pending delete HDFS path " + path);
            }
            catch (IOException e) {
                logger.error("Error dealing unused HDFS path " + path, e);
            }
        }
        this.hdfsGarbageFileBytes = garbageBytes;
        this.hdfsGarbageFiles = garbageList;
    }

    protected void collectUnusedHdfsFiles(UnusedHdfsFileCollector collector) throws IOException {
        if (StringUtils.isNotEmpty(this.config.getHBaseClusterFs())) {
            this.cleanUnusedHdfsFiles(this.hbaseFs, collector, true);
        }
        this.cleanUnusedHdfsFiles(this.defaultFs, collector, false);
    }

    private void cleanUnusedHdfsFiles(FileSystem fs, UnusedHdfsFileCollector collector, boolean hbaseFs) throws IOException {
        JobEngineConfig engineConfig = new JobEngineConfig(this.config);
        CubeManager cubeMgr = CubeManager.getInstance(this.config);
        ArrayList<String> allHdfsPathsNeedToBeDeleted = new ArrayList<String>();
        try {
            FileStatus[] fStatus = fs.listStatus(Path.getPathWithoutSchemeAndAuthority((Path)new Path(this.config.getHdfsWorkingDirectory())));
            if (fStatus != null) {
                for (FileStatus status : fStatus) {
                    String path = status.getPath().getName();
                    if (!path.startsWith("kylin-")) continue;
                    allHdfsPathsNeedToBeDeleted.add(status.getPath().toString());
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Working Directory does not exist on HDFS.", e);
        }
        List<String> allJobs = this.executableManager.getAllJobIds();
        for (String jobId : allJobs) {
            ExecutableState state = this.executableManager.getOutput(jobId).getState();
            if (state.isFinalState()) continue;
            String path = JobBuilderSupport.getJobWorkingDir(engineConfig.getHdfsWorkingDirectory(), jobId);
            if (hbaseFs) {
                path = HBaseConnection.makeQualifiedPathInHBaseCluster(path);
            } else {
                Path p = Path.getPathWithoutSchemeAndAuthority((Path)new Path(path));
                path = HadoopUtil.getFileSystem(path).makeQualified(p).toString();
            }
            allHdfsPathsNeedToBeDeleted.remove(path);
            logger.info("Skip " + path + " from deletion list, as the path belongs to job " + jobId + " with status " + (Object)((Object)state));
        }
        long maxSegMergeSpan = KylinConfig.getInstanceFromEnv().getMaxSegmentMergeSpan();
        for (CubeInstance cube : cubeMgr.reloadAndListAllCubes()) {
            for (CubeSegment seg : cube.getSegments()) {
                String jobUuid = seg.getLastBuildJobID();
                if (jobUuid == null || jobUuid.equals("")) continue;
                String path = JobBuilderSupport.getJobWorkingDir(engineConfig.getHdfsWorkingDirectory(), jobUuid);
                if (hbaseFs) {
                    path = HBaseConnection.makeQualifiedPathInHBaseCluster(path);
                } else {
                    Path p = Path.getPathWithoutSchemeAndAuthority((Path)new Path(path));
                    path = HadoopUtil.getFileSystem(path).makeQualified(p).toString();
                }
                if (maxSegMergeSpan > 0L && seg.getTSRange().duration() >= maxSegMergeSpan) {
                    logger.info("Keep " + path + " from deletion list, as the path belongs to segment " + seg + " of cube " + cube.getName() + " with max merging span.");
                    continue;
                }
                allHdfsPathsNeedToBeDeleted.remove(path);
                logger.info("Skip " + path + " from deletion list, as the path belongs to segment " + seg + " of cube " + cube.getName());
            }
        }
        for (String path : allHdfsPathsNeedToBeDeleted) {
            collector.add(fs, path);
        }
    }

    private void cleanUnusedIntermediateHiveTable() throws Exception {
        try {
            this.cleanUnusedIntermediateHiveTableInternal();
        }
        catch (NoClassDefFoundError e) {
            if (e.getMessage().contains("HiveConf")) {
                logger.info("Skip cleanup of tntermediate Hive table, seems no Hive on classpath");
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUnusedIntermediateHiveTableInternal() throws Exception {
        int uuidLength = 36;
        final String prefix = this.config.getHiveIntermediateTablePrefix();
        String uuidPattern = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
        HiveCmdBuilder.getHiveTablePrefix().set(prefix);
        List<String> hiveTableNames = null;
        try {
            hiveTableNames = this.getHiveTables();
        }
        finally {
            HiveCmdBuilder.getHiveTablePrefix().remove();
        }
        Iterable<String> kylinIntermediates = Iterables.filter(hiveTableNames, new Predicate<String>(){

            @Override
            public boolean apply(@Nullable String input) {
                return input != null && input.startsWith(prefix);
            }
        });
        List<String> allJobs = this.executableManager.getAllJobIds();
        ArrayList<String> workingJobList = new ArrayList<String>();
        List<String> allUuids = this.getAllUuids(allJobs);
        HashMap<String, String> segmentId2JobId = Maps.newHashMap();
        for (String string : allJobs) {
            ExecutableState executableState = this.executableManager.getOutput(string).getState();
            if (!executableState.isFinalState()) {
                workingJobList.add(string);
            }
            try {
                String string2 = this.getSegmentIdFromJobId(string);
                if (string2 == null) continue;
                segmentId2JobId.put(string2, string);
            }
            catch (Exception exception) {
                logger.warn("Failed to find segment ID from job ID " + string + ", ignore it");
            }
        }
        logger.debug("Working jobIDs: " + workingJobList);
        ArrayList<String> allHiveTablesNeedToBeDeleted = new ArrayList<String>();
        for (String string : kylinIntermediates) {
            logger.debug("Checking if table is garbage -- " + string);
            if (!string.startsWith(prefix)) continue;
            if (this.force) {
                logger.debug("Force include table " + string);
                allHiveTablesNeedToBeDeleted.add(string);
                continue;
            }
            boolean bl = true;
            if (string.length() < prefix.length() + 36) {
                logger.debug("Skip table because length is not qualified, " + string);
                continue;
            }
            String uuid = string.substring(string.length() - 36, string.length());
            uuid = uuid.replace("_", "-");
            Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
            if (!UUID_PATTERN.matcher(uuid).matches()) {
                logger.debug("Skip table because pattern doesn't match, " + string);
                continue;
            }
            if (!allUuids.contains(uuid)) {
                logger.debug("Skip table because is not current deployment create, " + string);
                continue;
            }
            if (allJobs.contains(uuid)) {
                bl = !workingJobList.contains(uuid);
            } else if (this.isTableInUse(uuid, workingJobList)) {
                logger.debug("Skip table because the table is in use, " + string);
                bl = false;
            }
            if (!bl) continue;
            allHiveTablesNeedToBeDeleted.add(string);
        }
        this.hiveGarbageTables = allHiveTablesNeedToBeDeleted;
        if (allHiveTablesNeedToBeDeleted.isEmpty()) {
            logger.info("No Hive tables to clean up");
            return;
        }
        if (this.delete) {
            try {
                List<List<String>> list = Lists.partition(allHiveTablesNeedToBeDeleted, 20);
                for (List<String> list2 : list) {
                    this.deleteHiveTables(list2, segmentId2JobId);
                }
            }
            catch (IOException iOException) {
                logger.error("Error during deleting Hive tables", iOException);
            }
        } else {
            for (String string : allHiveTablesNeedToBeDeleted) {
                logger.info("Dry run, pending delete Hive table " + string);
            }
        }
    }

    protected List<String> getHiveTables() throws Exception {
        ISourceMetadataExplorer explr = SourceManager.getDefaultSource().getSourceMetadataExplorer();
        return explr.listTables(this.config.getHiveDatabaseForIntermediateTable());
    }

    protected CliCommandExecutor getCliCommandExecutor() throws IOException {
        return this.config.getCliCommandExecutor();
    }

    private void deleteHiveTables(List<String> allHiveTablesNeedToBeDeleted, Map<String, String> segmentId2JobId) throws IOException {
        JobEngineConfig engineConfig = new JobEngineConfig(this.config);
        int uuidLength = 36;
        String useDatabaseHql = "USE " + this.config.getHiveDatabaseForIntermediateTable() + ";";
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement(useDatabaseHql);
        for (String delHive : allHiveTablesNeedToBeDeleted) {
            hiveCmdBuilder.addStatement("drop table if exists " + delHive + "; ");
            logger.info("Deleting Hive table " + delHive);
        }
        this.getCliCommandExecutor().execute(hiveCmdBuilder.build());
        for (String tableToDelete : allHiveTablesNeedToBeDeleted) {
            String uuid = tableToDelete.substring(tableToDelete.length() - 36, tableToDelete.length());
            String segmentId = uuid.replace("_", "-");
            if (segmentId2JobId.containsKey(segmentId)) {
                String path = JobBuilderSupport.getJobWorkingDir(engineConfig.getHdfsWorkingDirectory(), segmentId2JobId.get(segmentId)) + "/" + tableToDelete;
                Path externalDataPath = new Path(path);
                if (this.defaultFs.exists(externalDataPath)) {
                    this.defaultFs.delete(externalDataPath, true);
                    logger.info("Hive table {}'s external path {} deleted", (Object)tableToDelete, (Object)path);
                    continue;
                }
                logger.info("Hive table {}'s external path {} not exist. It's normal if kylin.source.hive.keep-flat-table set false (By default)", (Object)tableToDelete, (Object)path);
                continue;
            }
            logger.warn("Hive table {}'s job ID not found, segmentId2JobId: {}", (Object)tableToDelete, (Object)segmentId2JobId.toString());
        }
    }

    private List<String> getAllUuids(List<String> allJobs) {
        ArrayList<String> allUuids = new ArrayList<String>();
        for (String jobId : allJobs) {
            allUuids.add(jobId);
            try {
                String segmentId = this.getSegmentIdFromJobId(jobId);
                if (segmentId == null) continue;
                allUuids.add(segmentId);
            }
            catch (Exception ex) {
                logger.warn("Failed to find segment ID from job ID " + jobId + ", ignore it");
            }
        }
        return allUuids;
    }

    private String getSegmentIdFromJobId(String jobId) {
        AbstractExecutable abstractExecutable = this.executableManager.getJob(jobId);
        if (abstractExecutable == null) {
            return null;
        }
        String segmentId = abstractExecutable.getParam("segmentId");
        return segmentId;
    }

    private boolean isTableInUse(String segUuid, List<String> workingJobList) {
        for (String jobId : workingJobList) {
            String segmentId = this.getSegmentIdFromJobId(jobId);
            if (!segUuid.equals(segmentId)) continue;
            return true;
        }
        return false;
    }

    static {
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Delete the unused storage");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
        OptionBuilder.withArgName((String)"force");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Warning: will delete all kylin intermediate hive tables");
        OPTION_FORCE = OptionBuilder.create((String)"force");
        OptionBuilder.withArgName((String)"thread");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Warning: use at multi threads to cleanup storage");
        THREAD_NUM = OptionBuilder.create((String)"thread");
        logger = LoggerFactory.getLogger(StorageCleanupJob.class);
    }

    protected class UnusedHdfsFileCollector {
        LinkedHashSet<Pair<FileSystem, String>> list = new LinkedHashSet();

        protected UnusedHdfsFileCollector() {
        }

        public void add(FileSystem fs, String path) {
            this.list.add(Pair.newPair(fs, path));
        }
    }
}

