/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.StringCodeSystem;

public class FilterCodeSystemFactory {
    private static final HashMap<String, IFilterCodeSystem> codeSystemMap = new HashMap();

    public static IFilterCodeSystem getFilterCodeSystem(DataType dataType) {
        if (dataType.isIntegerFamily()) {
            return codeSystemMap.get("integer");
        }
        if (dataType.isNumberFamily()) {
            return codeSystemMap.get("decimal");
        }
        if (dataType.isDateTimeFamily()) {
            return codeSystemMap.get("integer");
        }
        return codeSystemMap.get("string");
    }

    static {
        codeSystemMap.put("string", StringCodeSystem.INSTANCE);
        codeSystemMap.put("integer", new IntegerCodeSystem());
        codeSystemMap.put("decimal", new DecimalCodeSystem());
    }

    private static class DecimalCodeSystem
    implements IFilterCodeSystem {
        private DecimalCodeSystem() {
        }

        public boolean isNull(Object code) {
            return code == null;
        }

        public void serialize(Object code, ByteBuffer buf) {
            BytesUtil.writeUTFString(code.toString(), buf);
        }

        public Object deserialize(ByteBuffer buf) {
            return Double.parseDouble(BytesUtil.readUTFString(buf));
        }

        @Override
        public int compare(Object o, Object t1) {
            double d1 = Double.parseDouble(o.toString());
            double d2 = Double.parseDouble(t1.toString());
            return Double.compare(d1, d2);
        }
    }

    private static class IntegerCodeSystem
    implements IFilterCodeSystem {
        private IntegerCodeSystem() {
        }

        public boolean isNull(Object code) {
            return code == null;
        }

        public void serialize(Object code, ByteBuffer buf) {
            BytesUtil.writeLong(Long.parseLong(code.toString()), buf);
        }

        public Object deserialize(ByteBuffer buf) {
            return BytesUtil.readLong(buf);
        }

        @Override
        public int compare(Object o, Object t1) {
            long l1 = Long.parseLong(o.toString());
            long l2 = Long.parseLong(t1.toString());
            return Long.compare(l1, l2);
        }
    }
}

