/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.CuboidStatsReaderUtil;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCubeInfoAfterCheckpointStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCubeInfoAfterCheckpointStep.class);

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        CubeManager cubeManager = CubeManager.getInstance(context.getConfig());
        CubeInstance cube = cubeManager.getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        Set<Long> recommendCuboids = cube.getCuboidsRecommend();
        try {
            Segments<CubeSegment> newSegments = cube.getSegments(SegmentStatusEnum.READY_PENDING);
            Map<Long, Long> recommendCuboidsWithStats = CuboidStatsReaderUtil.readCuboidStatsFromSegments(recommendCuboids, newSegments);
            if (recommendCuboidsWithStats == null) {
                throw new RuntimeException("Fail to get statistics info for recommended cuboids after optimization!!!");
            }
            cubeManager.promoteCheckpointOptimizeSegments(cube, recommendCuboidsWithStats, newSegments.toArray((CubeSegment[])new CubeSegment[newSegments.size()]));
            return new ExecuteResult();
        }
        catch (Exception e) {
            logger.error("fail to update cube after build", e);
            return ExecuteResult.createError(e);
        }
    }
}

