/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.MergeDictionaryJob;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchMergeJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchMergeJobBuilder2.class);
    private final IMROutput2.IMRBatchMergeOutputSide2 outputSide;
    private final IMRInput.IMRBatchMergeInputSide inputSide;

    public BatchMergeJobBuilder2(CubeSegment mergeSegment, String submitter) {
        super(mergeSegment, submitter);
        this.outputSide = MRUtil.getBatchMergeOutputSide2(this.seg);
        this.inputSide = MRUtil.getBatchMergeInputSide(this.seg);
    }

    public CubingJob build() {
        logger.info("MR_V2 new job to MERGE segment " + this.seg);
        CubeSegment cubeSegment = this.seg;
        CubingJob result = CubingJob.createMergeJob(cubeSegment, this.submitter, this.config);
        String jobId = result.getId();
        Segments<CubeSegment> mergingSegments = cubeSegment.getCubeInstance().getMergingSegments(cubeSegment);
        Preconditions.checkState(mergingSegments.size() > 1, "there should be more than 2 segments to merge, target segment " + cubeSegment);
        ArrayList<String> mergingSegmentIds = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingSegmentIds.add(merging.getUuid());
        }
        this.inputSide.addStepPhase1_MergeDictionary(result);
        result.addTask(this.createMergeDictionaryStep(cubeSegment, jobId, mergingSegmentIds));
        result.addTask(this.createUpdateDictionaryStep(cubeSegment, jobId, mergingSegmentIds));
        this.outputSide.addStepPhase1_MergeDictionary(result);
        this.outputSide.addStepPhase2_BuildCube(this.seg, mergingSegments, result);
        result.addTask(this.createUpdateCubeInfoAfterMergeStep(mergingSegmentIds, jobId));
        this.outputSide.addStepPhase3_Cleanup(result);
        return result;
    }

    public MapReduceExecutable createMergeDictionaryStep(CubeSegment seg, String jobID, List<String> mergingSegmentIds) {
        MapReduceExecutable mergeDictionaryStep = new MapReduceExecutable();
        mergeDictionaryStep.setName("Merge Cuboid Dictionary");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, "cube_merge");
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, "cubename", seg.getCubeInstance().getName());
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, "segmentId", seg.getUuid());
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, "metaUrl", this.getSegmentMetadataUrl(seg.getConfig(), jobID));
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, MergeDictionaryJob.OPTION_MERGE_SEGMENT_IDS.getOpt(), StringUtil.join(mergingSegmentIds, ","));
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, MergeDictionaryJob.OPTION_OUTPUT_PATH_DICT.getOpt(), this.getDictInfoPath(jobID));
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, MergeDictionaryJob.OPTION_OUTPUT_PATH_STAT.getOpt(), this.getStatisticsPath(jobID));
        BatchMergeJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Merge_Dictionary_" + seg.getCubeInstance().getName() + "_Step");
        mergeDictionaryStep.setMapReduceParams(cmd.toString());
        mergeDictionaryStep.setMapReduceJobClass(MergeDictionaryJob.class);
        return mergeDictionaryStep;
    }
}

