/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.IExtLookupProvider;
import org.apache.kylin.dict.lookup.IExtLookupTableCache;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.dict.lookup.LookupStringTable;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(LookupProviderFactory.class);
    private static Map<String, String> lookupProviderImplClassMap = Maps.newConcurrentMap();

    public static void registerLookupProvider(String storageType, String implClassName) {
        lookupProviderImplClassMap.put(storageType, implClassName);
    }

    public static IExtLookupProvider getExtLookupProvider(String storageType) {
        String className = lookupProviderImplClassMap.get(storageType);
        if (className == null) {
            throw new IllegalStateException("no implementation class found for storage type:" + storageType);
        }
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (IExtLookupProvider)constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("the lookup implementation class is invalid for storage type:" + storageType, e);
        }
    }

    public static ILookupTable getInMemLookupTable(TableDesc tableDesc, String[] pkCols, IReadableTable readableTable) throws IOException {
        return new LookupStringTable(tableDesc, pkCols, readableTable);
    }

    public static ILookupTable getExtLookupTable(TableDesc tableDesc, ExtTableSnapshotInfo extTableSnapshot) {
        IExtLookupTableCache extLookupTableCache = LookupProviderFactory.getExtLookupProvider(extTableSnapshot.getStorageType()).getLocalCache();
        if (extLookupTableCache == null) {
            return LookupProviderFactory.getExtLookupTableWithoutCache(tableDesc, extTableSnapshot);
        }
        ILookupTable cachedLookupTable = extLookupTableCache.getCachedLookupTable(tableDesc, extTableSnapshot, true);
        if (cachedLookupTable != null) {
            logger.info("try to use cached lookup table:{}", (Object)extTableSnapshot.getResourcePath());
            return cachedLookupTable;
        }
        logger.info("use ext lookup table:{}", (Object)extTableSnapshot.getResourcePath());
        return LookupProviderFactory.getExtLookupTableWithoutCache(tableDesc, extTableSnapshot);
    }

    public static ILookupTable getExtLookupTableWithoutCache(TableDesc tableDesc, ExtTableSnapshotInfo extTableSnapshot) {
        IExtLookupProvider provider = LookupProviderFactory.getExtLookupProvider(extTableSnapshot.getStorageType());
        return provider.getLookupTable(tableDesc, extTableSnapshot);
    }

    public static <T> T createEngineAdapter(String lookupStorageType, Class<T> engineInterface) {
        IExtLookupProvider provider = LookupProviderFactory.getExtLookupProvider(lookupStorageType);
        return provider.adaptToBuildEngine(engineInterface);
    }

    public static void rebuildLocalCache(TableDesc tableDesc, ExtTableSnapshotInfo extTableSnapshotInfo) {
        IExtLookupTableCache tablesCache = LookupProviderFactory.getExtLookupProvider(extTableSnapshotInfo.getStorageType()).getLocalCache();
        if (tablesCache != null) {
            tablesCache.buildSnapshotCache(tableDesc, extTableSnapshotInfo, LookupProviderFactory.getExtLookupTableWithoutCache(tableDesc, extTableSnapshotInfo));
        }
    }

    public static void removeLocalCache(ExtTableSnapshotInfo extTableSnapshotInfo) {
        IExtLookupTableCache tablesCache = LookupProviderFactory.getExtLookupProvider(extTableSnapshotInfo.getStorageType()).getLocalCache();
        if (tablesCache != null) {
            tablesCache.removeSnapshotCache(extTableSnapshotInfo);
        }
    }

    public static IExtLookupTableCache.CacheState getCacheState(ExtTableSnapshotInfo extTableSnapshotInfo) {
        IExtLookupTableCache tablesCache = LookupProviderFactory.getExtLookupProvider(extTableSnapshotInfo.getStorageType()).getLocalCache();
        if (tablesCache != null) {
            return tablesCache.getCacheState(extTableSnapshotInfo);
        }
        return IExtLookupTableCache.CacheState.NONE;
    }

    static {
        LookupProviderFactory.registerLookupProvider("hbase", "org.apache.kylin.storage.hbase.lookup.HBaseLookupProvider");
    }
}

